/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.tags;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.xsrf.XsrfTokenGenerator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;

public class URLTag
extends webwork.view.taglib.URLTag {
    private boolean atltoken = true;

    public int doStartTag() throws JspException {
        int rc = super.doStartTag();
        if (this.atltoken) {
            this.addXsrfToken();
        }
        return rc;
    }

    private void addXsrfToken() {
        HttpServletRequest httpServletRequest = (HttpServletRequest)this.pageContext.getRequest();
        this.addParameter("atl_token", this.getXsrfToken(httpServletRequest));
    }

    String getXsrfToken(HttpServletRequest request) {
        return this.getXsrfTokenGenerator().generateToken(request);
    }

    XsrfTokenGenerator getXsrfTokenGenerator() {
        return (XsrfTokenGenerator)ComponentAccessor.getComponentOfType(XsrfTokenGenerator.class);
    }

    public boolean isAtltoken() {
        return this.atltoken;
    }

    public void setAtltoken(boolean atltoken) {
        this.atltoken = atltoken;
    }
}

