/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.servlet;

import com.atlassian.fugue.Unit;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.thumbnail.ThumbnailManager;
import com.atlassian.jira.util.AttachmentUtils;
import com.atlassian.jira.util.io.InputStreamConsumer;
import com.atlassian.jira.web.servlet.AbstractViewFileServlet;
import com.atlassian.jira.web.servlet.HttpResponseHeaders;
import com.atlassian.jira.web.servlet.RangeResponse;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ViewThumbnailServlet
extends AbstractViewFileServlet {
    @Override
    protected int getContentLength(String attachmentPath) {
        Attachment attachment = this.getAttachment(attachmentPath);
        File thumbnailFile = AttachmentUtils.getThumbnailFile((Attachment)attachment);
        return (int)thumbnailFile.length();
    }

    @Override
    protected boolean supportsRangeRequests() {
        return false;
    }

    @Override
    protected void getInputStream(String attachmentPath, InputStreamConsumer<Unit> consumer) throws IOException, PermissionException {
        Attachment attachment = this.getAttachment(attachmentPath);
        if (!this.loggedInUserHasPermissionToViewAttachment(attachment)) {
            throw new PermissionException("You do not have permissions to view this attachment");
        }
        ((ThumbnailManager)ComponentAccessor.getComponentOfType(ThumbnailManager.class)).streamThumbnailContent(attachment, consumer);
    }

    @Override
    protected void setResponseHeaders(HttpServletRequest request, Optional<RangeResponse> rangeResponse, HttpServletResponse response) {
        Attachment attachment = this.getAttachment(this.attachmentQuery(request));
        File thumbnailFile = AttachmentUtils.getThumbnailFile((Attachment)attachment);
        response.setContentType(ThumbnailManager.MIME_TYPE.toString());
        response.setContentLength((int)thumbnailFile.length());
        response.setHeader("Content-Disposition", "inline; filename=" + thumbnailFile.getName() + ";");
        HttpResponseHeaders.cachePrivatelyForAboutOneYear(response);
    }
}

