/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.servlet;

import com.atlassian.fugue.Unit;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.AttachmentNotFoundException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.util.io.InputStreamConsumer;
import com.atlassian.jira.web.servlet.AbstractViewFileServlet;
import com.atlassian.jira.web.servlet.HttpResponseHeaders;
import com.atlassian.jira.web.servlet.MimeSniffingKit;
import com.atlassian.jira.web.servlet.RangeResponse;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ViewAttachmentServlet
extends AbstractViewFileServlet {
    @Override
    protected int getContentLength(String attachmentPath) {
        Attachment attachment = this.getAttachment(attachmentPath);
        return attachment.getFilesize().intValue();
    }

    @Override
    protected boolean supportsRangeRequests() {
        return true;
    }

    @Override
    protected void getInputStream(String attachmentQuery, InputStreamConsumer<Unit> consumer) throws PermissionException, IOException {
        Attachment attachment = this.getAttachment(attachmentQuery);
        if (!this.loggedInUserHasPermissionToViewAttachment(attachment)) {
            throw new PermissionException("You do not have permissions to view this issue");
        }
        ComponentAccessor.getAttachmentManager().streamAttachmentContent(attachment, consumer);
    }

    @Override
    protected void setResponseHeaders(HttpServletRequest request, Optional<RangeResponse> rangeResponse, HttpServletResponse response) throws AttachmentNotFoundException, IOException {
        Attachment attachment = this.getAttachment(this.attachmentQuery(request));
        response.setContentType(attachment.getMimetype());
        if (rangeResponse.isPresent()) {
            response.setStatus(206);
            response.setContentLength(rangeResponse.get().calculateContentLength());
            response.setHeader("Content-Range", rangeResponse.get().calculateContentRange());
        } else {
            response.setContentLength(attachment.getFilesize().intValue());
        }
        response.setHeader("Accept-Ranges", "bytes");
        this.getMimeSniffingKit().setAttachmentResponseHeaders(attachment, request.getHeader("USER-AGENT"), response);
        HttpResponseHeaders.cachePrivatelyForAboutOneYear(response);
    }

    private MimeSniffingKit getMimeSniffingKit() {
        return (MimeSniffingKit)ComponentAccessor.getComponent(MimeSniffingKit.class);
    }
}

