/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.servlet;

import com.atlassian.fugue.Unit;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.AttachmentNotFoundException;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.attachment.NoAttachmentDataException;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.http.JiraHttpUtils;
import com.atlassian.jira.util.io.InputStreamConsumer;
import com.atlassian.jira.web.exception.WebExceptionChecker;
import com.atlassian.jira.web.servlet.BadRequestException;
import com.atlassian.jira.web.servlet.InvalidAttachmentPathException;
import com.atlassian.jira.web.servlet.RangeNotSatisfiableException;
import com.atlassian.jira.web.servlet.RangeRequest;
import com.atlassian.jira.web.servlet.RangeResponse;
import com.atlassian.jira.web.servlet.ViewAttachmentServlet;
import com.atlassian.seraph.util.RedirectUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractViewFileServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(ViewAttachmentServlet.class);
    private static final int BUFFER_SIZE = 4096;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String attachmentQuery;
            try {
                attachmentQuery = this.attachmentQuery(request);
            }
            catch (InvalidAttachmentPathException e) {
                response.sendError(400, "Invalid attachment path");
                return;
            }
            catch (AttachmentNotFoundException nfe) {
                this.send404(request, response);
                return;
            }
            this.streamFileData(request, response, attachmentQuery);
        }
        catch (Exception e) {
            if (WebExceptionChecker.canBeSafelyIgnored(e)) {
                return;
            }
            log.error("Error serving file for path " + request.getPathInfo() + ": " + e.getMessage(), (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    private void send404(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendError(404, String.format("Attachment %s was not found", request.getPathInfo()));
    }

    private void redirectForSecurityBreach(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.getLoggedInUser() != null) {
            RequestDispatcher rd = request.getRequestDispatcher("/secure/views/securitybreach.jsp");
            JiraHttpUtils.setNoCacheHeaders((HttpServletResponse)response);
            rd.forward((ServletRequest)request, (ServletResponse)response);
        } else {
            response.sendRedirect(RedirectUtils.getLoginUrl((HttpServletRequest)request));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void streamFileData(HttpServletRequest request, HttpServletResponse response, String attachmentPath) throws IOException, ServletException {
        Optional<Object> rangeResponse;
        try {
            RangeRequest rangeRequest;
            rangeResponse = this.supportsRangeRequests() ? ((rangeRequest = this.parseRangeHeader(request)) == null ? Optional.empty() : Optional.of(rangeRequest.calculateRangeResponse(this.getContentLength(attachmentPath)))) : Optional.empty();
        }
        catch (BadRequestException ex) {
            this.send400(response, ex);
            return;
        }
        catch (RangeNotSatisfiableException ex) {
            this.send416(response, ex);
            return;
        }
        ServletOutputStream out = response.getOutputStream();
        try {
            this.getInputStream(attachmentPath, (InputStreamConsumer<Unit>)((InputStreamConsumer)arg_0 -> this.lambda$streamFileData$0(request, rangeResponse, response, (OutputStream)out, arg_0)));
        }
        catch (AttachmentNotFoundException | NoAttachmentDataException | FileNotFoundException ex) {
            log.error("Error finding " + request.getPathInfo() + " : " + ex.getMessage());
            this.send404(request, response);
            return;
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug("Error serving content to client", (Throwable)e);
            }
        }
        catch (PermissionException e) {
            this.redirectForSecurityBreach(request, response);
            return;
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    private void send400(HttpServletResponse response, BadRequestException ex) throws IOException {
        response.sendError(400, ex.getMessage());
    }

    private void send416(HttpServletResponse response, RangeNotSatisfiableException ex) throws IOException {
        response.setHeader("Accept-Ranges", "bytes");
        response.setHeader("Content-Range", "bytes */" + ex.getActualContentLength());
        response.sendError(416, ex.getMessage());
    }

    protected abstract int getContentLength(String var1);

    protected abstract boolean supportsRangeRequests();

    @VisibleForTesting
    protected void copyRange(InputStream is, OutputStream out, RangeResponse rangeResponse) throws IOException {
        int idx;
        is.skip(idx);
        if (rangeResponse.getEndIndex() == null) {
            IOUtils.copy((InputStream)is, (OutputStream)out);
        } else {
            int numBytesRead;
            int endIndex = rangeResponse.getEndIndex();
            byte[] buffer = new byte[4096];
            for (idx = rangeResponse.getStartIndex(); idx <= endIndex; idx += numBytesRead) {
                int numBytesWanted = Math.min(4096, endIndex - idx + 1);
                numBytesRead = is.read(buffer, 0, numBytesWanted);
                if (numBytesRead == -1) {
                    return;
                }
                out.write(buffer, 0, numBytesRead);
            }
        }
    }

    private void copyAll(InputStream is, OutputStream out) throws IOException {
        IOUtils.copy((InputStream)is, (OutputStream)out);
    }

    @Nullable
    private RangeRequest parseRangeHeader(HttpServletRequest request) throws BadRequestException {
        String headerValue = request.getHeader("Range");
        if (headerValue == null) {
            return null;
        }
        return RangeRequest.parse(headerValue);
    }

    protected final String attachmentQuery(HttpServletRequest request) {
        String pi = request.getPathInfo();
        if (pi == null || pi.length() == 1 || pi.indexOf(47, 1) == -1) {
            throw new InvalidAttachmentPathException();
        }
        return pi;
    }

    protected Attachment getAttachment(String query) {
        Long id;
        int x = query.indexOf(47, 1);
        String idStr = query.substring(1, x);
        try {
            id = new Long(idStr);
        }
        catch (NumberFormatException e) {
            throw new AttachmentNotFoundException((Object)idStr);
        }
        if (query.indexOf(47, x + 1) != -1) {
            throw new AttachmentNotFoundException((Object)idStr);
        }
        return ComponentAccessor.getAttachmentManager().getAttachment(id);
    }

    protected boolean loggedInUserHasPermissionToViewAttachment(Attachment attachment) throws DataAccessException {
        Issue issue = attachment.getIssueObject();
        return ComponentAccessor.getPermissionManager().hasPermission(ProjectPermissions.BROWSE_PROJECTS, issue, this.getLoggedInUser());
    }

    protected abstract void getInputStream(String var1, InputStreamConsumer<Unit> var2) throws IOException, PermissionException;

    protected abstract void setResponseHeaders(HttpServletRequest var1, Optional<RangeResponse> var2, HttpServletResponse var3) throws InvalidAttachmentPathException, DataAccessException, IOException;

    protected final ApplicationUser getLoggedInUser() {
        return ComponentAccessor.getJiraAuthenticationContext().getLoggedInUser();
    }

    private /* synthetic */ Unit lambda$streamFileData$0(HttpServletRequest request, Optional rangeResponse, HttpServletResponse response, OutputStream out, InputStream is) throws IOException {
        this.setResponseHeaders(request, rangeResponse, response);
        if (rangeResponse.isPresent()) {
            this.copyRange(is, out, (RangeResponse)rangeResponse.get());
        } else {
            this.copyAll(is, out);
        }
        return Unit.Unit();
    }
}

