/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.pagebuilder;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.servermetrics.RequestCheckpoints;
import com.atlassian.jira.servermetrics.ServerMetricsDetailCollector;
import com.atlassian.jira.web.filters.CommittedResponseHtmlErrorRecoveryFilter;
import com.atlassian.jira.web.pagebuilder.DecoratablePage;
import com.atlassian.jira.web.pagebuilder.Decorator;
import com.atlassian.jira.web.pagebuilder.DecoratorListener;
import com.atlassian.jira.web.pagebuilder.JspDecorator;
import com.atlassian.jira.web.pagebuilder.PageBuilder;
import com.atlassian.jira.web.pagebuilder.PageBuilderSpi;
import com.opensymphony.module.sitemesh.RequestConstants;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DefaultPageBuilder
implements PageBuilder,
PageBuilderSpi {
    private final ApplicationProperties applicationProperties;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final DecoratorListener decoratorListener;
    private final ServletContext servletContext;
    private final FeatureManager featureManager;
    private final ServerMetricsDetailCollector serverMetricsDetailCollector;
    private boolean firstByteSent = false;
    private boolean preHeadSent = false;
    private boolean finished = false;
    private Decorator decorator;

    public DefaultPageBuilder(ApplicationProperties applicationProperties, HttpServletRequest request, HttpServletResponse response, DecoratorListener decoratorListener, ServletContext servletContext, FeatureManager featureManager, ServerMetricsDetailCollector serverMetricsDetailCollector) {
        this.applicationProperties = applicationProperties;
        this.request = request;
        this.response = response;
        this.decoratorListener = decoratorListener;
        this.servletContext = servletContext;
        this.featureManager = featureManager;
        this.serverMetricsDetailCollector = serverMetricsDetailCollector;
    }

    @Override
    public void setDecorator(Decorator decorator) {
        this.request.setAttribute(CommittedResponseHtmlErrorRecoveryFilter.ENABLE_COMMITTED_RESPONSE_HTML_ERROR_RECOVERY, (Object)Boolean.TRUE);
        if (this.firstByteSent) {
            throw new IllegalStateException("Cannot set decorator after first byte has been sent");
        }
        this.decorator = decorator;
        this.decoratorListener.onDecoratorSet();
        if (decorator instanceof JspDecorator) {
            ((JspDecorator)((Object)decorator)).setContext(this.servletContext, this.request, this.response);
        }
        this.request.setAttribute(RequestConstants.DISABLE_BUFFER_AND_DECORATION, (Object)true);
    }

    @Override
    public void flush() {
        if (null == this.decorator) {
            throw new IllegalStateException("Attempting to flush before setting decorator");
        }
        this.firstByteSent = true;
        try {
            if (!this.preHeadSent) {
                this.preHeadSent = true;
                this.response.setContentType(this.applicationProperties.getContentType());
                this.response.setCharacterEncoding(this.applicationProperties.getEncoding());
                this.response.setHeader("X-Accel-Buffering", "no");
                this.serverMetricsDetailCollector.checkpointReached(RequestCheckpoints.beforePageBuilderFlushHeadEarly.name());
                this.decorator.writePreHead(this.response.getWriter());
                this.serverMetricsDetailCollector.checkpointReached(RequestCheckpoints.pageBuilderFlushHeadEarly.name());
            }
            this.decorator.writeOnFlush(this.response.getWriter());
            this.request.getSession(true);
            this.response.getWriter().flush();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void finish(DecoratablePage page) {
        if (this.finished) {
            throw new IllegalStateException("Attempting to call PageBuilder.finish() multiple times");
        }
        this.finished = true;
        this.serverMetricsDetailCollector.checkpointReached(RequestCheckpoints.beforePageBuilderFinish.name());
        try {
            if (null == this.decorator) {
                page.writeHead(this.response.getWriter());
                this.serverMetricsDetailCollector.checkpointReached(RequestCheckpoints.afterPageBuilderWriteHead.name());
                this.serverMetricsDetailCollector.checkpointReached(RequestCheckpoints.afterPageBuilderPreBodyDecorator.name());
                this.serverMetricsDetailCollector.checkpointReached(RequestCheckpoints.afterPageBuilderWriteBody.name());
                page.writeBody(this.response.getWriter());
            } else {
                this.flush();
                page.writeHead(this.response.getWriter());
                this.serverMetricsDetailCollector.checkpointReached(RequestCheckpoints.afterPageBuilderWriteHead.name());
                this.decorator.writePostHead(this.response.getWriter(), new DefaultParsedHead(page));
                this.decorator.writePreBody(this.response.getWriter(), new DefaultParsedBody(page));
                this.serverMetricsDetailCollector.checkpointReached(RequestCheckpoints.afterPageBuilderPreBodyDecorator.name());
                page.writeBody(this.response.getWriter());
                this.serverMetricsDetailCollector.checkpointReached(RequestCheckpoints.afterPageBuilderWriteBody.name());
                this.decorator.writePostBody(this.response.getWriter(), new DefaultParsedBody(page));
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.serverMetricsDetailCollector.checkpointReached(RequestCheckpoints.pageBuilderFinish.name());
        }
    }

    private class DefaultParsedBody
    implements DecoratablePage.ParsedBody {
        private final DecoratablePage page;

        private DefaultParsedBody(DecoratablePage page) {
            this.page = page;
        }

        @Override
        public String getBodyTagProperty(String key) {
            return this.page.getBodyTagProperty(key);
        }

        @Override
        public String getPageProperty(String key) {
            return this.page.getPageProperty(key);
        }
    }

    private class DefaultParsedHead
    implements DecoratablePage.ParsedHead {
        private final DecoratablePage page;

        private DefaultParsedHead(DecoratablePage page) {
            this.page = page;
        }

        @Override
        public String getTitle() {
            return this.page.getTitle();
        }

        @Override
        public String getMetaProperty(String key) {
            return this.page.getMetaProperty(key);
        }
    }
}

