/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters.pagebuilder;

import com.atlassian.jira.web.pagebuilder.DecoratorListener;
import com.opensymphony.module.sitemesh.PageParser;
import com.opensymphony.module.sitemesh.filter.Buffer;
import com.opensymphony.module.sitemesh.filter.HttpContentType;
import com.opensymphony.module.sitemesh.parser.HTMLPageParser;
import com.opensymphony.module.sitemesh.scalability.NoopScalabilitySupport;
import com.opensymphony.module.sitemesh.scalability.ScalabilitySupport;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

class PageBuilderResponseWrapper
extends HttpServletResponseWrapper
implements DecoratorListener {
    private Buffer buffer;
    private boolean writerHasBeenExposed;
    private boolean outputStreamHasBeenExposed;
    private boolean decoratorHasBeenSet;

    PageBuilderResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    @Override
    public void onDecoratorSet() {
        if (this.writerHasBeenExposed) {
            throw new IllegalStateException("Cannot set decorator after the response writer has been accessed.");
        }
        this.decoratorHasBeenSet = true;
    }

    public PrintWriter getWriter() throws IOException {
        this.writerHasBeenExposed = true;
        if (this.outputStreamHasBeenExposed) {
            throw new IllegalStateException("getWriter() called after getOutputStream()");
        }
        String contentType = this.getContentType();
        if (this.decoratorHasBeenSet && contentType != null) {
            if (this.buffer == null) {
                HttpContentType httpContentType = new HttpContentType(contentType);
                this.buffer = new Buffer((PageParser)new HTMLPageParser(), httpContentType.getEncoding(), (ScalabilitySupport)new NoopScalabilitySupport());
            }
            return this.buffer.getWriter();
        }
        return this.getResponse().getWriter();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        this.outputStreamHasBeenExposed = true;
        if (this.writerHasBeenExposed) {
            throw new IllegalStateException("getOutputStream() called after getWriter()");
        }
        if (this.decoratorHasBeenSet) {
            throw new IllegalStateException("getOutputStream() does not support decorators");
        }
        return super.getOutputStream();
    }

    Buffer getBuffer() {
        return this.buffer;
    }

    boolean isBuffering() {
        return null != this.buffer;
    }
}

