/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters;

import com.atlassian.core.filters.AbstractHttpFilter;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.startup.InstantUpgradeManager;
import com.atlassian.jira.web.util.CloudControlIPCheck;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.MDC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstantUpgradeHoldingFilter
extends AbstractHttpFilter {
    private static final String HOLDING_FILTER_TIMEOUT_KEY = "holding.filter.timeout.seconds";
    private static final long HOLDING_FILTER_TIMEOUT_SECONDS = 55L;
    private static final int SMART_STATUS_TAKE_THE_WHEEL = 510;
    private static final String REQUEST_HELD_TIME = "jira.instant.holdingfilter.millis";
    private static final String REQUEST_METHOD = "jira.instant.holdingfilter.method";
    private static final String REQUEST_HAS_TIMEDOUT = "jira.instant.holdingfilter.hastimedout";
    private static final Logger log = LoggerFactory.getLogger(InstantUpgradeHoldingFilter.class);
    private final AtomicReference<InstantUpgradeManager.State> applicationState = new AtomicReference();
    private Set<String> permittedRequestPaths;

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        this.permittedRequestPaths = new HashSet<String>();
        String paths = filterConfig.getInitParameter("permittedPaths");
        if (!StringUtils.isEmpty((CharSequence)paths)) {
            Arrays.asList(paths.split(",")).stream().map(arg -> arg.trim()).forEach(this.permittedRequestPaths::add);
        }
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (this.isFullContainerInitialised() && this.isHoldingRequests() && this.shouldHoldThisRequest(request)) {
            boolean timedOut;
            InstantUpgradeManager instantUpgradeManager = (InstantUpgradeManager)ComponentAccessor.getComponent(InstantUpgradeManager.class);
            JiraProperties jiraProperties = (JiraProperties)ComponentAccessor.getComponent(JiraProperties.class);
            Stopwatch stopwatch = Stopwatch.createStarted();
            log.info("Holding {} request {} while JIRA finishes starting up", (Object)request.getMethod(), (Object)request.getRequestURI());
            try {
                timedOut = !instantUpgradeManager.waitTillFullyStarted(jiraProperties.getLong(HOLDING_FILTER_TIMEOUT_KEY, Long.valueOf(55L)), TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                response.sendError(510);
                return;
            }
            long heldTimeMillis = stopwatch.elapsed(TimeUnit.MILLISECONDS);
            this.logRequestHoldingMetadata(request, heldTimeMillis, timedOut);
            if (timedOut) {
                response.sendError(510);
            } else {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    @VisibleForTesting
    boolean isFullContainerInitialised() {
        return ComponentManager.getInstance().getState().isStarted();
    }

    private void logRequestHoldingMetadata(HttpServletRequest request, long holdTimeMillis, boolean timedOut) {
        String message = timedOut ? "JIRA didn't start fast enough. Erroring {} {} after {} millis" : "Releasing previously held {} request {} after {} millis";
        MDC.put((String)REQUEST_HELD_TIME, (Object)holdTimeMillis);
        MDC.put((String)REQUEST_METHOD, (Object)request.getMethod());
        MDC.put((String)REQUEST_HAS_TIMEDOUT, (Object)timedOut);
        log.info(message, new Object[]{request.getMethod(), request.getRequestURI(), holdTimeMillis});
        MDC.remove((String)REQUEST_HAS_TIMEDOUT);
        MDC.remove((String)REQUEST_HELD_TIME);
        MDC.remove((String)REQUEST_METHOD);
    }

    private boolean shouldHoldThisRequest(HttpServletRequest request) {
        if (new CloudControlIPCheck().test(request)) {
            String path = request.getRequestURL().substring(request.getContextPath().length());
            log.debug("Passing control IP request: {}", (Object)path);
            return false;
        }
        String path = request.getRequestURI().substring(request.getContextPath().length());
        return !this.permittedRequestPaths.contains(path);
    }

    @VisibleForTesting
    public boolean isHoldingRequests() {
        if (this.applicationState.get() != null) {
            switch (this.applicationState.get()) {
                case DISABLED: 
                case FULLY_STARTED: 
                case ERROR: {
                    return false;
                }
            }
        }
        InstantUpgradeManager instantUpgradeManager = (InstantUpgradeManager)ComponentAccessor.getComponent(InstantUpgradeManager.class);
        this.applicationState.set(instantUpgradeManager.getState());
        switch (this.applicationState.get()) {
            case DISABLED: 
            case FULLY_STARTED: 
            case ERROR: {
                return false;
            }
            case EARLY_STARTUP: {
                log.warn("During instant upgrade requests should not be coming through during early startup. This is probably a bug in the icebat");
            }
            case WAITING_FOR_ACTIVATION: 
            case LATE_STARTUP: {
                return true;
            }
        }
        log.error("Unknown application status {}", (Object)this.applicationState.get());
        return false;
    }
}

