/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.dispatcher;

import com.atlassian.jira.action.ActionContextKit;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.config.webwork.ActionNotFoundException;
import com.atlassian.jira.config.webwork.LookupAliasActionFactoryProxy;
import com.atlassian.jira.security.xsrf.XsrfFailureException;
import com.atlassian.jira.servermetrics.NoopServerMetricsDetailCollector;
import com.atlassian.jira.servermetrics.RequestCheckpoints;
import com.atlassian.jira.servermetrics.ServerMetricsDetailCollector;
import com.atlassian.jira.startup.JiraStartupChecklist;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.jira.web.action.XsrfErrorAction;
import com.atlassian.jira.web.dispatcher.JiraWebworkViewDispatcher;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import java.beans.Introspector;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import javax.annotation.Nullable;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import webwork.action.ResultException;
import webwork.config.Configuration;
import webwork.dispatcher.ActionResult;
import webwork.dispatcher.GenericDispatcher;
import webwork.multipart.MultiPartRequest;
import webwork.multipart.MultiPartRequestWrapper;
import webwork.util.ValueStack;

public class JiraWebworkActionDispatcher
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(JiraWebworkActionDispatcher.class);
    public static final String STACK_HEAD = "webwork.valuestack.head";
    public static final String GD = "jira.webwork.generic.dispatcher";
    public static final String CLEANUP = "jira.webwork.cleanup";
    public static final String ACTION_VIEW_DATA = "jira.action.view.context.data";
    private static final String NEW_LINE = JiraSystemProperties.getInstance().getProperty("line.separator");
    private static final String ACTION_EXTENSION = ".jspa";
    private String saveDir;
    private JiraWebworkViewDispatcher viewDispatcher = new JiraWebworkViewDispatcher();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (JiraStartupChecklist.startupOK()) {
            Introspector.flushCaches();
            ValueStack.clearMethods();
            File tempdir = (File)config.getServletContext().getAttribute("javax.servlet.context.tempdir");
            if (tempdir != null) {
                this.saveDir = tempdir.getAbsolutePath();
            } else {
                log.error("Servlet Context Temp Directory isn't set. No save directory set for file uploads.");
            }
            log.info("Setting Upload File Directory to '{}'", (Object)this.saveDir);
            log.info("JiraWebworkActionDispatcher initialized");
        } else {
            String message = "JIRA startup failed, JIRA has been locked.";
            String line = StringUtils.repeat((String)"*", (int)message.length());
            log.error(NEW_LINE + NEW_LINE + line + NEW_LINE + message + NEW_LINE + line + NEW_LINE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Pair<HttpServletRequest, HttpServletResponse> wrap = this.wrap(httpServletRequest, httpServletResponse);
        httpServletRequest = (HttpServletRequest)wrap.first();
        httpServletResponse = (HttpServletResponse)wrap.second();
        boolean doCleanup = httpServletRequest.getAttribute(CLEANUP) == null || httpServletRequest.getAttribute(CLEANUP).equals(Boolean.TRUE);
        ServerMetricsDetailCollector serverMetricsDetailCollector = ComponentAccessor.getComponentSafely(ServerMetricsDetailCollector.class).orElseGet(NoopServerMetricsDetailCollector::new);
        GenericDispatcher gd = null;
        try {
            String actionName = this.getActionName(httpServletRequest);
            serverMetricsDetailCollector.checkpointReached(RequestCheckpoints.beforeWorkActionPrepareDispatcher.name());
            gd = this.prepareDispatcher(httpServletRequest, httpServletResponse, actionName);
            ActionResult ar = null;
            try {
                serverMetricsDetailCollector.checkpointReached(RequestCheckpoints.beforeWorkActionStarts.name());
                gd.executeAction();
                serverMetricsDetailCollector.checkpointReached(RequestCheckpoints.afterWorkActionExecute.name());
                ar = gd.finish();
            }
            catch (XsrfFailureException e) {
                httpServletRequest.getRequestDispatcher(XsrfErrorAction.FORWARD_PATH).forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
            catch (WebSudoSessionException websudoException) {
                ar = new ActionResult("login", (Object)("/secure/admin/WebSudoAuthenticate!default.jspa?webSudoDestination=" + this.getDestinationUrl(httpServletRequest)), Collections.emptyList(), null);
            }
            catch (ActionNotFoundException e) {
                log.debug("Action '{}' was not found, returning 404", (Object)e.getActionName());
                this.sendErrorImpl(httpServletResponse, 404, null);
            }
            catch (LookupAliasActionFactoryProxy.UnauthorisedActionException unauthorisedActionException) {
                httpServletRequest.getRequestDispatcher("/login.jsp?permissionViolation=true&os_destination=" + this.getDestinationUrl(httpServletRequest)).forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
            catch (Exception e) {
                this.onActionRecoverableThrowable(httpServletResponse, actionName, e);
            }
            if (ar != null && ar.getActionException() != null) {
                this.onActionException(actionName, ar);
            }
            if (ar != null && ar.getResult() != null && ar.getView() == null && !ar.getResult().equals("none")) {
                this.onNoViewDefined(httpServletResponse, actionName, ar);
            }
            if (ar != null && ar.getView() != null && ar.getActionException() == null) {
                this.viewDispatcher.dispatchView(httpServletRequest, httpServletResponse, doCleanup, ar, actionName);
                serverMetricsDetailCollector.checkpointReached(RequestCheckpoints.webworkViewDispatch.name());
            }
            this.performFinallyCleanup(httpServletRequest, doCleanup, gd);
        }
        catch (Throwable throwable) {
            this.performFinallyCleanup(httpServletRequest, doCleanup, gd);
            throw throwable;
        }
    }

    private String getDestinationUrl(HttpServletRequest httpServletRequest) {
        return JiraUrlCodec.encode((String)(httpServletRequest.getServletPath() + (httpServletRequest.getPathInfo() == null ? "" : httpServletRequest.getPathInfo()) + (httpServletRequest.getQueryString() == null ? "" : "?" + httpServletRequest.getQueryString())));
    }

    private GenericDispatcher prepareDispatcher(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String actionName) {
        GenericDispatcher gd = new GenericDispatcher(actionName, false);
        gd.prepareContext();
        ActionContextKit.setContext(httpServletRequest, httpServletResponse, this.getServletContext(), actionName);
        gd.prepareValueStack();
        return gd;
    }

    private void onActionException(String actionName, ActionResult ar) throws ServletException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Could not execute action '%s', throwing ServletException", actionName), (Throwable)ar.getActionException());
        }
        if (IllegalStateException.class == ar.getActionException().getClass() && "Cannot create a session after the response has been committed".equals(ar.getActionException().getMessage())) {
            log.warn("SUPPRESSED IllegalStateException: Cannot create a session after the response has been committed");
            return;
        }
        throw new ServletException((Throwable)ar.getActionException());
    }

    private void onActionRecoverableThrowable(HttpServletResponse httpServletResponse, String actionName, Throwable e) {
        log.error(String.format("Exception thrown from action '%s', returning 404 ", actionName), e);
        this.sendErrorImpl(httpServletResponse, 404, e.getMessage());
    }

    private void onNoViewDefined(HttpServletResponse httpServletResponse, String actionName, ActionResult ar) {
        log.debug("No view '{}' defined for '{}', returning 404", (Object)ar.getResult(), (Object)actionName);
        this.sendErrorImpl(httpServletResponse, 404, "No view for result [" + ar.getResult() + "] exists for action [" + actionName + "]");
    }

    private void sendErrorImpl(HttpServletResponse httpServletResponse, int statusCode, @Nullable String msg) {
        try {
            if (!httpServletResponse.isCommitted()) {
                if (msg == null) {
                    httpServletResponse.sendError(statusCode);
                } else {
                    httpServletResponse.sendError(statusCode, msg);
                }
            }
        }
        catch (IOException e1) {
            log.error("Error occurred while sending error response : " + statusCode + " - " + msg + " because of" + e1.getMessage());
        }
    }

    private void performFinallyCleanup(HttpServletRequest httpServletRequest, boolean doCleanup, GenericDispatcher gd) {
        if (doCleanup) {
            if (gd != null) {
                gd.finalizeContext();
            }
        } else {
            httpServletRequest.setAttribute(GD, (Object)gd);
        }
    }

    private String getActionName(HttpServletRequest httpServletRequest) {
        String servletPath = (String)httpServletRequest.getAttribute("javax.servlet.include.servlet_path");
        if (servletPath == null) {
            servletPath = httpServletRequest.getServletPath();
        }
        int beginIdx = servletPath.lastIndexOf("/");
        int endIdx = servletPath.lastIndexOf(ACTION_EXTENSION);
        return servletPath.substring(beginIdx == -1 ? 0 : beginIdx + 1, endIdx == -1 ? servletPath.length() : endIdx);
    }

    private Pair<HttpServletRequest, HttpServletResponse> wrap(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (httpServletRequest instanceof MultiPartRequestWrapper) {
            return Pair.of((Object)httpServletRequest, (Object)httpServletResponse);
        }
        httpServletResponse.setContentType(httpServletResponse.getContentType());
        String disableMultipartGetString = this.multipartDisableGetString();
        boolean disableMultipartGet = Boolean.valueOf(disableMultipartGetString);
        if (this.needsMultipartWrapper(httpServletRequest, disableMultipartGet)) {
            try {
                httpServletRequest = new MultiPartRequestWrapper(httpServletRequest, this.saveDir, this.getMaxSize());
            }
            catch (IOException e) {
                httpServletRequest.setAttribute("webwork.action.ResultException", (Object)new ResultException("error", e.getLocalizedMessage()));
            }
        }
        return Pair.of((Object)httpServletRequest, (Object)httpServletResponse);
    }

    private String multipartDisableGetString() {
        return this.applicationProperties().getDefaultString("jira.disable.multipart.get.http.request");
    }

    private ApplicationProperties applicationProperties() {
        return ComponentAccessor.getApplicationProperties();
    }

    private boolean needsMultipartWrapper(HttpServletRequest httpServletRequest, boolean disableMultipartGet) {
        return MultiPartRequest.isMultiPart((HttpServletRequest)httpServletRequest) && ("POST".equals(httpServletRequest.getMethod()) || "GET".equals(httpServletRequest.getMethod()) && !disableMultipartGet);
    }

    private Integer getMaxSize() {
        Integer maxSize;
        try {
            String maxSizeStr = Configuration.getString((String)"webwork.multipart.maxSize");
            if (maxSizeStr != null) {
                try {
                    maxSize = new Integer(maxSizeStr);
                }
                catch (NumberFormatException e) {
                    maxSize = Integer.MAX_VALUE;
                    log.warn("Property 'webwork.multipart.maxSize' with value '" + maxSizeStr + "' is not a number. Defaulting to Integer.MAX_VALUE");
                }
            } else {
                maxSize = Integer.MAX_VALUE;
                log.warn("Property 'webwork.multipart.maxSize' is not set. Defaulting to Integer.MAX_VALUE");
            }
        }
        catch (IllegalArgumentException e1) {
            maxSize = Integer.MAX_VALUE;
            log.warn("Failed getting string from Configuration for 'webwork.multipart.maxSize' property. Defaulting to Integer.MAX_VALUE", (Throwable)e1);
        }
        return maxSize;
    }
}

