/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.bean;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.UserQuery;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestriction;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.fugue.Option;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.crowd.embedded.ofbiz.UnsortedNullRestriction;
import com.atlassian.jira.issue.comparator.UserNameComparator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.LazyLoadingApplicationUser;
import com.atlassian.jira.web.bean.FilterUtils;
import com.atlassian.jira.web.bean.PagerFilter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;

public class UserBrowserFilter
extends PagerFilter<ApplicationUser> {
    public static final String ANY_APPLICATION_ACCESS_FILTER = "-1";
    public static final String NO_APPLICATION_ACCESS_FILTER = "-2";
    public String userSearchFilter = null;
    private Option<Boolean> activeFilter = Option.none();
    public String group = null;
    private final Locale userLocale;
    private final ApplicationRoleManager roleManager;
    private AccessFilterType applicationFilterType = AccessFilterType.IGNORE;
    private ApplicationKey applicationFilter = null;

    public UserBrowserFilter(Locale userLocale, ApplicationRoleManager roleManager) {
        this.userLocale = userLocale;
        this.roleManager = roleManager;
    }

    public String getActiveFilter() {
        return (String)this.activeFilter.map(Object::toString).getOrElse((Object)"");
    }

    public void setActiveFilter(String activeFilter) {
        this.activeFilter = Strings.isNullOrEmpty((String)activeFilter) ? Option.none() : Option.option((Object)Boolean.valueOf(activeFilter));
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = FilterUtils.verifyString(group);
    }

    public String getUserSearchFilter() {
        return this.userSearchFilter;
    }

    public void setUserSearchFilter(String userSearchFilter) {
        this.userSearchFilter = userSearchFilter;
    }

    public void setApplicationFilter(String applicationFilter) {
        this.applicationFilterType = AccessFilterType.IGNORE;
        this.applicationFilter = null;
        switch (applicationFilter) {
            case "-1": {
                this.applicationFilterType = AccessFilterType.SPECIAL_ANY;
                break;
            }
            case "-2": {
                this.applicationFilterType = AccessFilterType.SPECIAL_NONE;
                break;
            }
            default: {
                try {
                    Option role = this.roleManager.getRole(ApplicationKey.valueOf((String)applicationFilter));
                    if (!role.isDefined()) break;
                    this.applicationFilterType = AccessFilterType.REGULAR;
                    this.applicationFilter = ((ApplicationRole)role.get()).getKey();
                    break;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    public String getApplicationFilter() {
        switch (this.applicationFilterType) {
            case SPECIAL_ANY: {
                return ANY_APPLICATION_ACCESS_FILTER;
            }
            case SPECIAL_NONE: {
                return NO_APPLICATION_ACCESS_FILTER;
            }
            case REGULAR: {
                return this.applicationFilter.value();
            }
        }
        return null;
    }

    public List<ApplicationUser> getFilteredUsers() throws Exception {
        Iterable users = this.getUsersFilteredByGroupAndCriteria();
        if (this.applicationFilterType != AccessFilterType.IGNORE) {
            users = Iterables.filter(users, this::includeBasedOnApplicationAccess);
        }
        ArrayList sortedUsers = Lists.newArrayList(users);
        Collections.sort(sortedUsers, new UserNameComparator(this.userLocale));
        return sortedUsers;
    }

    private Iterable<ApplicationUser> getUsersFilteredByGroupAndCriteria() {
        CrowdService crowdService = (CrowdService)ComponentAccessor.getComponentOfType(CrowdService.class);
        Iterable<String> userNames = this.getUserNamesFilteredByCriteria();
        if (this.group != null) {
            Set userNamesSet = userNames instanceof Set ? (Set)userNames : ImmutableSet.copyOf(userNames);
            return this.makeLazyApplicationUsersFromNames((Iterable<String>)Sets.intersection((Set)userNamesSet, (Set)ImmutableSet.copyOf(this.getUsersFilteredByGroup())), crowdService);
        }
        return this.makeLazyApplicationUsersFromNames(userNames, crowdService);
    }

    private Iterable<String> getUsersFilteredByGroup() {
        CrowdService crowdService = (CrowdService)ComponentAccessor.getComponentOfType(CrowdService.class);
        MembershipQuery membershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(this.group).returningAtMost(-1);
        return crowdService.search((Query)membershipQuery);
    }

    @VisibleForTesting
    Iterable<String> getUserNamesFilteredByCriteria() {
        CrowdService crowdService = (CrowdService)ComponentAccessor.getComponentOfType(CrowdService.class);
        UserQuery query = new UserQuery(String.class, this.makeCrowdRestriction(this.userSearchFilter), 0, -1);
        Iterable userNames = crowdService.search((Query)query);
        if (this.activeFilter.isDefined()) {
            Predicate<User> usersMatchingActivityFilter = user -> user.isActive() == ((Boolean)this.activeFilter.get()).booleanValue();
            List userNamesList = userNames instanceof List ? (List)userNames : ImmutableList.copyOf((Iterable)userNames);
            return () -> userNamesList.stream().map(arg_0 -> ((CrowdService)crowdService).getUser(arg_0)).filter(usersMatchingActivityFilter).map(Principal::getName).iterator();
        }
        return userNames;
    }

    private Iterable<ApplicationUser> makeLazyApplicationUsersFromNames(Iterable<String> userNames, CrowdService crowdService) {
        return Iterables.transform(userNames, userName -> new LazyLoadingApplicationUser((String)userName, crowdService));
    }

    private Option<SearchRestriction> makeUserSearchRestrictions(String searchFilter) {
        return Strings.isNullOrEmpty((String)searchFilter) ? Option.none() : Option.option((Object)new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.OR, (Collection)ImmutableList.of((Object)new TermRestriction(UserTermKeys.USERNAME, MatchMode.CONTAINS, (Object)searchFilter), (Object)new TermRestriction(UserTermKeys.DISPLAY_NAME, MatchMode.CONTAINS, (Object)searchFilter), (Object)new TermRestriction(UserTermKeys.EMAIL, MatchMode.CONTAINS, (Object)searchFilter))));
    }

    private SearchRestriction makeCrowdRestriction(String userSearchFilter) {
        Option<SearchRestriction> userSearchRestrictions = this.makeUserSearchRestrictions(userSearchFilter);
        return (SearchRestriction)userSearchRestrictions.getOrElse((Object)UnsortedNullRestriction.INSTANCE);
    }

    private boolean includeBasedOnApplicationAccess(ApplicationUser user) {
        switch (this.applicationFilterType) {
            case REGULAR: {
                return this.roleManager.userOccupiesRole(user, this.applicationFilter);
            }
            case SPECIAL_NONE: {
                return !this.roleManager.hasAnyRole(user);
            }
            case SPECIAL_ANY: {
                return this.roleManager.hasAnyRole(user);
            }
        }
        return true;
    }

    private static enum AccessFilterType {
        SPECIAL_ANY,
        SPECIAL_NONE,
        REGULAR,
        IGNORE;

    }
}

