/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.setup;

import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.extension.JiraStartedEvent;
import com.atlassian.jira.issue.fields.layout.field.EditableDefaultFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.renderer.RenderableField;
import com.atlassian.jira.license.LicenseJohnsonEventRaiser;
import com.atlassian.jira.upgrade.SetupUpgradeService;
import com.atlassian.jira.upgrade.UpgradeResult;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.SneakyAutoLoginUtil;
import com.atlassian.jira.util.FileFactory;
import com.atlassian.jira.util.JiraProductInformation;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.johnson.JohnsonProvider;
import com.atlassian.jira.web.action.setup.AbstractSetupAction;
import com.atlassian.jira.web.action.setup.SetupAdminUserSessionStorage;
import com.atlassian.jira.web.action.setup.SetupCompleteRedirectHelper;
import com.atlassian.plugin.event.PluginEventManager;
import java.util.List;

public class SetupComplete
extends AbstractSetupAction {
    private final String title;
    private final SetupUpgradeService setupUpgradeService;
    private final LicenseJohnsonEventRaiser licenseJohnsonEventRaiser;
    private final SubTaskManager subTaskManager;
    private final FieldLayoutManager fieldLayoutManager;
    private final PluginEventManager pluginEventManager;
    private final SetupCompleteRedirectHelper setupCompleteRedirectHelper;
    private final JohnsonProvider johnsonProvider;

    public SetupComplete(SetupUpgradeService setupUpgradeService, LicenseJohnsonEventRaiser licenseJohnsonEventRaiser, SubTaskManager subTaskManager, FieldLayoutManager fieldLayoutManager, FileFactory fileFactory, PluginEventManager pluginEventManager, JiraProperties jiraProperties, SetupCompleteRedirectHelper setupCompleteRedirectHelper, JohnsonProvider johnsonProvider, JiraProductInformation jiraProductInformation) {
        super(fileFactory, jiraProperties, jiraProductInformation);
        this.setupCompleteRedirectHelper = setupCompleteRedirectHelper;
        this.johnsonProvider = johnsonProvider;
        this.pluginEventManager = (PluginEventManager)Assertions.notNull((String)"pluginEventManager", (Object)pluginEventManager);
        this.setupUpgradeService = (SetupUpgradeService)Assertions.notNull((String)"setupUpgradeService", (Object)setupUpgradeService);
        this.licenseJohnsonEventRaiser = (LicenseJohnsonEventRaiser)Assertions.notNull((String)"licenseJohnsonEventRaiser", (Object)licenseJohnsonEventRaiser);
        this.subTaskManager = (SubTaskManager)Assertions.notNull((String)"subTaskManager", (Object)subTaskManager);
        this.fieldLayoutManager = (FieldLayoutManager)Assertions.notNull((String)"fieldLayoutManager", (Object)fieldLayoutManager);
        ApplicationProperties applicationProperties = this.getApplicationProperties();
        this.title = applicationProperties.getString("jira.title");
    }

    public String doDefault() throws Exception {
        return this.doExecute();
    }

    protected String doExecute() throws Exception {
        if (this.setupAlready()) {
            return "setupalready";
        }
        this.getApplicationProperties().setString("jira.setup", "true");
        this.initialiseSystemPropertiesBeforeSetupUpgradeTasks();
        if (this.licenseTooOld()) {
            return this.getRedirect(this.johnsonProvider.getConfig().getErrorPath());
        }
        UpgradeResult result = this.setupUpgradeService.runUpgrades();
        if (!result.successful()) {
            result.getErrors().forEach(arg_0 -> ((SetupComplete)this).addErrorMessage(arg_0));
        } else {
            this.initialiseSystemPropertiesAfterSetupUpgradeTasks();
            this.pluginEventManager.broadcast((Object)new JiraStartedEvent());
        }
        ApplicationUser user = this.logUserInAutomatically();
        return this.getRedirect(this.setupCompleteRedirectHelper.getRedirectUrl(user));
    }

    private ApplicationUser logUserInAutomatically() {
        try {
            SetupAdminUserSessionStorage sessionStorage = (SetupAdminUserSessionStorage)this.request.getSession().getAttribute(SetupAdminUserSessionStorage.SESSION_KEY);
            this.request.getSession().removeAttribute(SetupAdminUserSessionStorage.SESSION_KEY);
            if (sessionStorage != null) {
                return SneakyAutoLoginUtil.logUserInByName(sessionStorage.getUsername(), this.request);
            }
            this.log.warn((Object)"Unable to automatically login after setup complete: sessionStorage is null");
        }
        catch (Exception e) {
            this.log.warn((Object)"Error with automatic login after setup complete. The user will need to login in manually.", (Throwable)e);
        }
        return null;
    }

    private void initialiseSystemPropertiesBeforeSetupUpgradeTasks() {
        this.getApplicationProperties().setOption("jira.option.user.externalmanagement", false);
        this.getApplicationProperties().setOption("jira.option.voting", true);
        this.getApplicationProperties().setOption("jira.option.watching", true);
        this.getApplicationProperties().setOption("jira.option.issuelinking", true);
        this.getApplicationProperties().setString("jira.option.emailvisible", "show");
    }

    private void initialiseSystemPropertiesAfterSetupUpgradeTasks() {
        this.enableSubTasks();
        this.setWikiRendererOnAllRenderableFields();
    }

    private void enableSubTasks() {
        try {
            this.subTaskManager.enableSubTasks(false);
        }
        catch (CreateException e) {
            this.log.error((Object)"Error encountered when trying to enable sub tasks", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    void setWikiRendererOnAllRenderableFields() {
        EditableDefaultFieldLayout editableDefaultFieldLayout = this.fieldLayoutManager.getEditableDefaultFieldLayout();
        List fieldLayoutItems = editableDefaultFieldLayout.getFieldLayoutItems();
        for (FieldLayoutItem fieldLayoutItem : fieldLayoutItems) {
            RenderableField field;
            if (!(fieldLayoutItem.getOrderableField() instanceof RenderableField) || !(field = (RenderableField)fieldLayoutItem.getOrderableField()).isRenderable()) continue;
            editableDefaultFieldLayout.setRendererType(fieldLayoutItem, "atlassian-wiki-renderer");
        }
        this.fieldLayoutManager.storeEditableDefaultFieldLayout(editableDefaultFieldLayout);
    }

    protected boolean licenseTooOld() {
        return this.licenseJohnsonEventRaiser.checkLicenseIsTooOldForBuild();
    }

    public String getTitle() {
        return this.title;
    }
}

