/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.setup;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.license.JiraProductLicense;
import com.atlassian.jira.license.LicenseDetailsFactoryImpl;
import com.atlassian.jira.util.FileFactory;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraProductInformation;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.setup.AbstractSetupAction;
import com.atlassian.jira.web.action.setup.SetupSharedVariables;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetupAccount
extends AbstractSetupAction {
    private static final Logger log = LoggerFactory.getLogger(SetupAccount.class);
    public static final String LICENSE_PROBLEM = "licenseproblem";
    private final SetupSharedVariables setupSharedVariables;
    private String setupOption = "classic";
    private String productLicense;
    private String email;
    private String password;

    public SetupAccount(FileFactory fileFactory, JiraProperties jiraProperties, JiraProductInformation jiraProductInformation, SetupSharedVariables setupSharedVariables) {
        super(fileFactory, jiraProperties, jiraProductInformation);
        this.setupSharedVariables = setupSharedVariables;
    }

    public String doDefault() throws Exception {
        if (this.setupAlready()) {
            return "setupalready";
        }
        if (!this.validateLicense()) {
            return LICENSE_PROBLEM;
        }
        return "input";
    }

    public String doExecute() throws Exception {
        if (this.setupAlready()) {
            return "setupalready";
        }
        if (!this.validateLicense()) {
            return LICENSE_PROBLEM;
        }
        if (StringUtils.isBlank((CharSequence)this.getEmail()) || StringUtils.isBlank((CharSequence)this.getPassword())) {
            return "input";
        }
        if (this.setupSharedVariables.getIsInstantSetup()) {
            return this.forceRedirect("SetupFinishing!default.jspa");
        }
        return this.forceRedirect("SetupDatabase!default.jspa");
    }

    @ActionViewData
    public String getErrorTextsJson() throws JSONException {
        I18nHelper i18nHelper = ComponentAccessor.getI18nHelperFactory().getInstance(this.getLocale());
        JSONObject json = new JSONObject();
        json.put("invalidEmail", (Object)i18nHelper.getText("setup.account.form.email.invalid"));
        json.put("invalidUsername", (Object)i18nHelper.getText("setup.account.form.username.invalid"));
        json.put("tooLongUsername", (Object)i18nHelper.getText("setup.account.form.username.too.long"));
        json.put("emailRequired", (Object)i18nHelper.getText("setup.account.form.email.required"));
        json.put("usernameRequired", (Object)i18nHelper.getText("setup.account.form.username.required"));
        json.put("passwordRequired", (Object)i18nHelper.getText("setup.account.form.password.required"));
        json.put("passwordRetypeRequired", (Object)i18nHelper.getText("setup.account.form.retype.password.required"));
        json.put("passwordsDoNotMatch", (Object)i18nHelper.getText("setup.account.form.retype.password.mismatch"));
        return json.toString();
    }

    @ActionViewData
    public String getLicenseFlagTextsJson() throws JSONException {
        I18nHelper i18nHelper = ComponentAccessor.getI18nHelperFactory().getInstance(this.getLocale());
        JSONObject json = new JSONObject();
        json.put("successTitle", (Object)i18nHelper.getText("setup.license.flag.title"));
        json.put("successContent", (Object)i18nHelper.getText("setup.license.flag.content"));
        json.put("errorTitle", (Object)i18nHelper.getText("setup.license.flag.error.title"));
        json.put("errorContent", (Object)i18nHelper.getText("setup.license.flag.error.content", String.format("<a href=\"%s\">", this.setupSharedVariables.getBaseUrl()), "</a>"));
        return json.toString();
    }

    private boolean validateLicense() {
        JiraProductLicense jiraProductLicense;
        I18nHelper i18nHelper = ComponentAccessor.getI18nHelperFactory().getInstance(this.getLocale());
        if (this.productLicense == null || this.productLicense.trim().isEmpty()) {
            this.addError("licenseError", i18nHelper.getText("setup.license.error.no.license.provided"));
            return false;
        }
        try {
            jiraProductLicense = LicenseDetailsFactoryImpl.JiraProductLicenseManager.INSTANCE.getProductLicense(this.productLicense);
        }
        catch (RuntimeException e) {
            log.error("Provided license could not be decoded or is not a JIRA license", (Throwable)e);
            this.addError("licenseError", i18nHelper.getText("setup.license.error.not.a.jira.license"));
            return false;
        }
        if (!jiraProductLicense.getApplications().getKeys().stream().filter(key -> key.value().toLowerCase().contains("jira")).findAny().isPresent()) {
            this.addError("licenseError", i18nHelper.getText("setup.license.error.jira.not.licensed"));
            return false;
        }
        return true;
    }

    @ActionViewData
    public Map<String, String> getErrors() {
        return super.getErrors();
    }

    public void setProductLicense(String productLicense) {
        this.productLicense = productLicense;
    }

    @ActionViewData
    public String getProductLicense() {
        return this.productLicense;
    }

    public String getSetupOption() {
        return this.setupOption;
    }

    public void setSetupOption(String setupOption) {
        this.setupOption = setupOption;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

