/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.setup;

import com.atlassian.jira.bc.dataimport.DataImportService;
import com.atlassian.jira.bc.dataimport.DefaultDataImportService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.JiraAuthenticationContextImpl;
import com.atlassian.jira.task.CompositeProgressSink;
import com.atlassian.jira.task.JohnsonEventProgressSink;
import com.atlassian.jira.task.LoggingProgressSink;
import com.atlassian.jira.task.ProvidesTaskProgress;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.seraph.spi.rememberme.RememberMeTokenDao;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class DataImportAsyncCommand
implements Callable<DataImportService.ImportResult>,
ProvidesTaskProgress {
    private final JohnsonEventContainer eventCont;
    private final DataImportService dataImportService;
    private final ApplicationUser loggedInUser;
    private final DataImportService.ImportValidationResult validationResult;
    private final Event johnsonEvent;
    private final VelocityRequestContext velocityRequestContext;
    private final HttpSession session;
    private TaskProgressSink taskProgressSink;

    public DataImportAsyncCommand(JohnsonEventContainer eventCont, DataImportService dataImportService, ApplicationUser loggedInUser, DataImportService.ImportValidationResult validationResult, Event johnsonEvent, VelocityRequestContext velocityRequestContext, HttpSession session) {
        this.eventCont = eventCont;
        this.dataImportService = dataImportService;
        this.loggedInUser = loggedInUser;
        this.validationResult = validationResult;
        this.johnsonEvent = johnsonEvent;
        this.velocityRequestContext = velocityRequestContext;
        this.session = session;
    }

    @Override
    public DataImportService.ImportResult call() throws Exception {
        if (this.eventCont != null) {
            this.eventCont.addEvent(this.johnsonEvent);
        }
        JiraAuthenticationContextImpl.getRequestCache().put("jira.velocity.request.context", this.velocityRequestContext);
        try {
            DataImportService.ImportResult result = this.dataImportService.doImport(this.loggedInUser, this.validationResult, this.taskProgressSink);
            if (result.isValid()) {
                if (this.session != null) {
                    this.session.invalidate();
                }
                ((RememberMeTokenDao)ComponentAccessor.getComponentOfType(RememberMeTokenDao.class)).removeAll();
            }
            DataImportService.ImportResult importResult = result;
            return importResult;
        }
        finally {
            if (this.eventCont != null) {
                this.eventCont.removeEvent(this.johnsonEvent);
            }
            JiraAuthenticationContextImpl.getRequestCache().remove("jira.velocity.request.context");
        }
    }

    @Override
    public void setTaskProgressSink(TaskProgressSink taskProgressSink) {
        this.taskProgressSink = new CompositeProgressSink(taskProgressSink, new JohnsonEventProgressSink(this.johnsonEvent), new LoggingProgressSink(Logger.getLogger(DefaultDataImportService.class), "Importing data is {0}% complete...", 1));
    }
}

