/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.project;

import com.atlassian.fugue.Option;
import com.atlassian.jira.entity.ProjectCategoryFactory;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.ofbiz.core.entity.GenericEntityException;

@WebSudoRequired
public class SelectProjectCategory
extends JiraWebActionSupport {
    public static final long NONE_PROJECT_CATEGORY_ID = -1L;
    private Long pid;
    private Long projectCategoryId;
    private String source;
    private final ProjectManager projectManager;

    public SelectProjectCategory(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    public String doDefault() throws Exception {
        ProjectCategory projectCategory = this.projectManager.getProjectCategoryForProject(this.getProject());
        if (null != projectCategory) {
            this.setProjectCategoryId(projectCategory.getId());
        } else {
            this.setProjectCategoryId(-1L);
        }
        return super.doDefault();
    }

    protected void doValidation() {
        if (this.isCurrentProjectValid()) {
            this.addErrorMessage(this.getText("admin.errors.project.specify.project"));
        }
        if (this.getProjectCategory().isEmpty() && this.isSelectedProjectCategoryNotNone()) {
            this.addError("projectCategoryId", this.getText("admin.errors.project.specify.project.category"));
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        this.projectManager.setProjectCategory(this.getProject(), (ProjectCategory)this.getProjectCategory().getOrNull());
        if ("viewprojects".equals(this.getSource())) {
            return this.returnCompleteWithInlineRedirect("/secure/project/ViewProjects.jspa");
        }
        return this.returnCompleteWithInlineRedirect("/plugins/servlet/project-config/" + this.getProject().getKey() + "/summary");
    }

    public Collection<ProjectCategory> getProjectCategories() throws GenericEntityException {
        ArrayList projectCategoriesToDisplay = Lists.newArrayList((Object[])new ProjectCategory[]{this.createEmptyProjectCategory()});
        projectCategoriesToDisplay.addAll(this.projectManager.getAllProjectCategories());
        return projectCategoriesToDisplay;
    }

    private ProjectCategory createEmptyProjectCategory() {
        return new ProjectCategoryFactory.Builder().id(-1L).name("None").build();
    }

    public Project getProject() {
        return this.projectManager.getProjectObj(this.getPid());
    }

    private Option<ProjectCategory> getProjectCategory() {
        if (null == this.getProjectCategoryId() || this.getProjectCategoryId().equals(-1L)) {
            return Option.none();
        }
        return Option.some((Object)this.projectManager.getProjectCategoryObject(this.getProjectCategoryId()));
    }

    public Long getPid() {
        return this.pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public Long getProjectCategoryId() {
        return this.projectCategoryId;
    }

    public void setProjectCategoryId(Long projectCategoryId) {
        this.projectCategoryId = projectCategoryId;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    private boolean isSelectedProjectCategoryNotNone() {
        return this.getProjectCategoryId() != null && !this.getProjectCategoryId().equals(-1L);
    }

    private boolean isCurrentProjectValid() {
        return null == this.getProject();
    }
}

