/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue.util;

import com.atlassian.fugue.Option;
import com.atlassian.jira.issue.AttachmentError;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.AttachmentsBulkOperationResult;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.TemporaryAttachmentsMonitorLocator;
import com.atlassian.jira.issue.attachment.TemporaryAttachment;
import com.atlassian.jira.issue.attachment.TemporaryWebAttachmentManager;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.action.issue.TemporaryAttachmentsMonitor;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackwardCompatibleTemporaryAttachmentUtil {
    private static final Logger log = LoggerFactory.getLogger(BackwardCompatibleTemporaryAttachmentUtil.class);
    private final TemporaryAttachmentsMonitorLocator temporaryAttachmentsMonitorLocator;
    private final TemporaryWebAttachmentManager temporaryWebAttachmentManager;
    private final AttachmentManager attachmentManager;
    private final I18nHelper.BeanFactory i18nFactory;

    public BackwardCompatibleTemporaryAttachmentUtil(TemporaryAttachmentsMonitorLocator temporaryAttachmentsMonitorLocator, TemporaryWebAttachmentManager temporaryWebAttachmentManager, AttachmentManager attachmentManager, I18nHelper.BeanFactory i18nFactory) {
        this.temporaryAttachmentsMonitorLocator = temporaryAttachmentsMonitorLocator;
        this.temporaryWebAttachmentManager = temporaryWebAttachmentManager;
        this.attachmentManager = attachmentManager;
        this.i18nFactory = i18nFactory;
    }

    public boolean allAttachmentsExists(List<String> temporaryAttachmentEntryIds) {
        return this.allAttachmentExists(temporaryAttachmentEntryIds) || this.allAttachmentExistsInOldMonitor(temporaryAttachmentEntryIds);
    }

    private boolean allAttachmentExistsInOldMonitor(final List<String> temporaryAttachmentEntryIds) {
        return (Boolean)Option.option((Object)this.temporaryAttachmentsMonitorLocator.get(false)).flatMap((Function)new Function<TemporaryAttachmentsMonitor, Option<Boolean>>(){

            public Option<Boolean> apply(final @Nullable TemporaryAttachmentsMonitor monitor) {
                return BackwardCompatibleTemporaryAttachmentUtil.this.convertToLongIds(temporaryAttachmentEntryIds).map((Function)new Function<List<Long>, Boolean>(){

                    public Boolean apply(@Nullable List<Long> longIds) {
                        return BackwardCompatibleTemporaryAttachmentUtil.this.allAttachmentExistsInOldMonitor(longIds, monitor);
                    }
                });
            }
        }).getOrElse((Object)false);
    }

    private boolean allAttachmentExistsInOldMonitor(List<Long> temporaryAttachmentEntryIds, TemporaryAttachmentsMonitor monitor) {
        return Iterables.all(this.lazyGetAllTemporaryAttachmentsFromOldMonitor(temporaryAttachmentEntryIds, monitor), (Predicate)new Predicate<TemporaryAttachment>(){

            public boolean apply(@Nullable TemporaryAttachment input) {
                return input != null && input.getFile() != null && input.getFile().exists();
            }
        });
    }

    private boolean allAttachmentExists(List<String> temporaryAttachmentEntryIds) {
        return Iterables.all(temporaryAttachmentEntryIds, (Predicate)new Predicate<String>(){

            public boolean apply(String temporaryAttachmentEntryId) {
                return BackwardCompatibleTemporaryAttachmentUtil.this.temporaryWebAttachmentManager.getTemporaryWebAttachment(temporaryAttachmentEntryId).isDefined();
            }
        });
    }

    private Iterable<TemporaryAttachment> lazyGetAllTemporaryAttachmentsFromOldMonitor(List<Long> temporaryAttachmentEntryIds, final TemporaryAttachmentsMonitor monitor) {
        return Iterables.transform(temporaryAttachmentEntryIds, (Function)new Function<Long, TemporaryAttachment>(){

            public TemporaryAttachment apply(Long temporaryAttachmentEntryId) {
                return monitor.getById(temporaryAttachmentEntryId);
            }
        });
    }

    private Option<List<Long>> convertToLongIds(Collection<String> stringIds) {
        try {
            return Option.some((Object)ImmutableList.copyOf((Iterable)Iterables.transform(stringIds, (Function)new Function<String, Long>(){

                public Long apply(String input) {
                    return Long.parseLong(input);
                }
            })));
        }
        catch (NumberFormatException e) {
            return Option.none();
        }
    }

    public AttachmentsBulkOperationResult<ChangeItemBean> convertTemporaryAttachments(final ApplicationUser user, final Issue issue, final List<String> temporaryAttachmentsIds) {
        return (AttachmentsBulkOperationResult)this.convertToLongIds(temporaryAttachmentsIds).fold((Supplier)new Supplier<AttachmentsBulkOperationResult<ChangeItemBean>>(){

            public AttachmentsBulkOperationResult<ChangeItemBean> get() {
                return BackwardCompatibleTemporaryAttachmentUtil.this.temporaryWebAttachmentManager.convertTemporaryAttachments(user, issue, temporaryAttachmentsIds);
            }
        }, (Function)new Function<List<Long>, AttachmentsBulkOperationResult<ChangeItemBean>>(){

            public AttachmentsBulkOperationResult<ChangeItemBean> apply(List<Long> longIds) {
                return BackwardCompatibleTemporaryAttachmentUtil.this.convertTemporaryAttachmentsInOldWay(user, issue, longIds);
            }
        });
    }

    private AttachmentsBulkOperationResult<ChangeItemBean> convertTemporaryAttachmentsInOldWay(ApplicationUser user, Issue issue, List<Long> longIds) {
        log.warn("Using deprecated method for adding attachments to issue! Someone still uses TemporaryAttachmentsMonitor - you can probably track him by looking at the referrer or previous requests to JIRA.");
        TemporaryAttachmentsMonitor monitor = this.temporaryAttachmentsMonitorLocator.get(false);
        if (monitor == null) {
            I18nHelper i18n = this.i18nFactory.getInstance(user);
            return new AttachmentsBulkOperationResult((List)ImmutableList.of((Object)new AttachmentError("Couldn't get temporary attachments monitor - session probably expired!", i18n.getText("attachment.temporary.id.session.time.out"), "", ErrorCollection.Reason.SERVER_ERROR)), Collections.emptyList());
        }
        return this.attachmentManager.tryConvertTemporaryAttachments(user, issue, longIds, monitor);
    }

    public Collection<?> getTemporaryWebAttachmentsByFormToken(String formToken) {
        Collection attachments = this.temporaryWebAttachmentManager.getTemporaryWebAttachmentsByFormToken(formToken);
        if (attachments.isEmpty()) {
            TemporaryAttachmentsMonitor monitor = this.temporaryAttachmentsMonitorLocator.get(false);
            return monitor != null ? monitor.getByFormToken(formToken) : Collections.emptyList();
        }
        return attachments;
    }

    public void clearTemporaryAttachmentsByFormToken(String formToken) {
        Assertions.notNull((String)"formToken", (Object)formToken);
        this.temporaryWebAttachmentManager.clearTemporaryAttachmentsByFormToken(formToken);
        TemporaryAttachmentsMonitor monitor = this.temporaryAttachmentsMonitorLocator.get(false);
        if (monitor != null) {
            monitor.clearEntriesForFormToken(formToken);
        }
    }
}

