/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue.bulkedit;

import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.bulkedit.operation.BulkMigrateOperation;
import com.atlassian.jira.bulkedit.operation.BulkMoveOperation;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.SecurityLevelSystemField;
import com.atlassian.jira.issue.fields.rest.json.beans.SuggestionBean;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.http.JiraUrl;
import com.atlassian.jira.web.action.issue.bulkedit.BulkMove;
import com.atlassian.jira.web.action.issue.bulkedit.SingleIssueModeInitializer;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.jira.web.bean.BulkEditBeanImpl;
import com.atlassian.jira.web.bean.BulkEditBeanSessionHelper;
import com.atlassian.jira.web.bean.MultiBulkMoveBean;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.lang3.StringUtils;

public class BulkMigrate
extends BulkMove {
    private static final String SINGLE_ISSUE_MOVE_ERROR = "singleerror";
    private String sameAsBulkEditBean;
    private Long singleIssueId;
    protected final BulkMigrateOperation bulkMigrateOperation;
    protected final PageBuilderService pageBuilderService;
    protected final IssueService issueService;

    public BulkMigrate(SearchService searchService, BulkMoveOperation bulkMoveOperation, FieldManager fieldManager, WorkflowManager workflowManager, ConstantsManager constantsManager, IssueFactory issueFactory, BulkMigrateOperation bulkMigrateOperation, PermissionManager permissionManager, BulkEditBeanSessionHelper bulkEditBeanSessionHelper, TaskManager taskManager, I18nHelper i18nHelper, PageBuilderService pageBuilderService, IssueService issueService) {
        super(searchService, bulkMoveOperation, fieldManager, workflowManager, constantsManager, issueFactory, permissionManager, bulkEditBeanSessionHelper, taskManager, i18nHelper);
        this.bulkMigrateOperation = bulkMigrateOperation;
        this.pageBuilderService = pageBuilderService;
        this.issueService = issueService;
    }

    @Override
    public String doDetails() {
        BulkEditBean rootBulkEditBean;
        if (this.singleIssueId != null) {
            this.clearBulkEditBean();
            MutableIssue singleIssueObject = this.getIssueManager().getIssueObject(this.singleIssueId);
            if (singleIssueObject != null) {
                if (!this.isAbleToMoveSingleIssue((Issue)singleIssueObject, this.getLoggedInUser())) {
                    this.addErrorMessage(this.getText("move.issue.nopermissions"));
                    return SINGLE_ISSUE_MOVE_ERROR;
                }
                this.initSingleIssueBulkEditBean((Issue)singleIssueObject);
            } else {
                this.addErrorMessage(this.getText("admin.errors.issues.issue.does.not.exist"));
                return SINGLE_ISSUE_MOVE_ERROR;
            }
        }
        if ((rootBulkEditBean = this.getRootBulkEditBean()) == null) {
            return this.redirectToStart();
        }
        rootBulkEditBean.setOperationName(this.getBulkMigrateOperation().getOperationName());
        rootBulkEditBean.resetMoveData();
        rootBulkEditBean.initMultiBulkBean();
        rootBulkEditBean.clearAvailablePreviousSteps();
        rootBulkEditBean.addAvailablePreviousStep(1);
        rootBulkEditBean.addAvailablePreviousStep(2);
        if (this.isCanDisableMailNotifications()) {
            rootBulkEditBean.setSendBulkNotification(false);
        } else {
            rootBulkEditBean.setSendBulkNotification(true);
        }
        rootBulkEditBean.setCurrentStep(3);
        this.includeResourcesForParentIssuePicker();
        return "success";
    }

    private void includeResourcesForParentIssuePicker() {
        this.pageBuilderService.assembler().resources().requireWebResource("jira.webresources:jira-bulk-edit");
    }

    private void includeResourcesForAnalytics() {
        this.pageBuilderService.assembler().resources().requireWebResource("jira.webresources:jira-bulk-edit-analytics");
    }

    private boolean isAbleToMoveSingleIssue(Issue singleIssueObject, ApplicationUser user) {
        return this.permissionManager.hasPermission(ProjectPermissions.MOVE_ISSUES, singleIssueObject, user);
    }

    private void initSingleIssueBulkEditBean(Issue singleIssueObject) {
        BulkEditBeanImpl bulkEditBean = new BulkEditBeanImpl(this.getIssueManager());
        SingleIssueModeInitializer.initialize(bulkEditBean, singleIssueObject);
        this.storeBulkEditBean(bulkEditBean);
    }

    public String doStart() throws Exception {
        return "success";
    }

    public String doChooseContext() throws Exception {
        BulkEditBean currentRootBulkEditBean = this.getCurrentRootBulkEditBean();
        if (currentRootBulkEditBean == null) {
            return this.redirectToStart();
        }
        MultiBulkMoveBean rootMultiBulkMoveBean = currentRootBulkEditBean.getRelatedMultiBulkMoveBean();
        ListOrderedMap bulkEditBeans = rootMultiBulkMoveBean.getBulkEditBeans();
        for (Object o1 : bulkEditBeans.values()) {
            BulkEditBean bulkEditBean = (BulkEditBean)o1;
            bulkEditBean.resetMoveData();
        }
        this.getBulkMigrateOperation().chooseContext(currentRootBulkEditBean, this.getLoggedInUser(), (I18nHelper)this, (ErrorCollection)this);
        if (this.invalidInput()) {
            return this.goToInput();
        }
        rootMultiBulkMoveBean.remapBulkEditBeansByTargetContext();
        this.getBulkMigrateOperation().getBulkMoveOperation().finishChooseContext(rootMultiBulkMoveBean, this.getLoggedInUser());
        boolean needsSubTaskChooseContext = false;
        for (Object o : rootMultiBulkMoveBean.getBulkEditBeans().values()) {
            BulkEditBean targetContextBean = (BulkEditBean)o;
            if (targetContextBean.getSubTaskBulkEditBean() == null) continue;
            needsSubTaskChooseContext = true;
            targetContextBean.initMultiBulkBeanWithSubTasks();
        }
        if (needsSubTaskChooseContext) {
            return this.getRedirect(this.decorateRedirectUrl("BulkMigrateChooseSubTaskContext!default.jspa"));
        }
        return this.getNextRedirect();
    }

    private String goToInput() {
        this.includeResourcesForParentIssuePicker();
        return "input";
    }

    public String doChooseSubTaskContext() throws Exception {
        BulkEditBean currentRootBulkEditBean;
        BulkEditBean rootBulkEditBean = this.getRootBulkEditBean();
        if (rootBulkEditBean == null) {
            return this.redirectToStart();
        }
        for (Object o1 : rootBulkEditBean.getRelatedMultiBulkMoveBean().getBulkEditBeans().values()) {
            currentRootBulkEditBean = (BulkEditBean)o1;
            if (currentRootBulkEditBean.getRelatedMultiBulkMoveBean() == null) continue;
            ListOrderedMap subTaskBeans = currentRootBulkEditBean.getRelatedMultiBulkMoveBean().getBulkEditBeans();
            for (Object o : subTaskBeans.values()) {
                BulkEditBean subTaskBean = (BulkEditBean)o;
                subTaskBean.resetMoveData();
            }
            this.getBulkMigrateOperation().chooseContext(currentRootBulkEditBean, this.getLoggedInUser(), (I18nHelper)this, (ErrorCollection)this);
        }
        if (this.invalidInput()) {
            return this.goToInput();
        }
        for (Object o : rootBulkEditBean.getRelatedMultiBulkMoveBean().getBulkEditBeans().values()) {
            currentRootBulkEditBean = (BulkEditBean)o;
            MultiBulkMoveBean multiBulkMoveBean = currentRootBulkEditBean.getRelatedMultiBulkMoveBean();
            if (multiBulkMoveBean == null) continue;
            multiBulkMoveBean.remapBulkEditBeansByTargetContext();
            this.getBulkMigrateOperation().getBulkMoveOperation().finishChooseContext(multiBulkMoveBean, this.getLoggedInUser());
        }
        return this.getNextRedirect();
    }

    public String doChooseStatus() throws Exception {
        if (this.getBulkEditBean() == null) {
            return this.redirectToStart();
        }
        this.getBulkMigrateOperation().setStatusFields(this.getCurrentRootBulkEditBean());
        return this.getRedirect(this.decorateRedirectUrl("BulkMigrateSetFields!default.jspa"));
    }

    public String doSetFields() throws Exception {
        if (this.getBulkEditBean() == null) {
            return this.redirectToStart();
        }
        this.getBulkMigrateOperation().validatePopulateFields(this.getCurrentRootBulkEditBean(), (I18nHelper)this, (ErrorCollection)this);
        if (this.invalidInput()) {
            return "error";
        }
        if (this.getBulkEditBean().getRelatedMultiBulkMoveBean() != null) {
            this.setSubTaskPhase(true);
            return this.getNextRedirect();
        }
        if (!this.getCurrentRootBulkEditBean().getRelatedMultiBulkMoveBean().isLastBulkEditBean()) {
            this.getCurrentRootBulkEditBean().getRelatedMultiBulkMoveBean().progressToNextBulkEditBean();
            return this.getNextRedirect();
        }
        if (this.isSubTaskPhase()) {
            this.setSubTaskPhase(false);
        }
        if (!this.getCurrentRootBulkEditBean().getRelatedMultiBulkMoveBean().isLastBulkEditBean()) {
            this.getCurrentRootBulkEditBean().getRelatedMultiBulkMoveBean().progressToNextBulkEditBean();
            return this.getNextRedirect();
        }
        this.progressToLastStep();
        this.includeResourcesForAnalytics();
        return "confirm";
    }

    @Override
    public String doPerform() throws Exception {
        if (this.getBulkEditBean() == null) {
            return this.redirectToStart();
        }
        if (!this.permissionManager.hasPermission(33, this.getLoggedInUser()) && !this.getBulkEditBean().isSingleMode()) {
            this.addErrorMessage(this.getText("bulk.change.no.permission", String.valueOf(this.getBulkEditBean().getSelectedIssues().size())));
            return "error";
        }
        if (!this.getBulkMigrateOperation().canPerform(this.getRootBulkEditBean(), this.getLoggedInUser())) {
            this.addErrorMessage(this.getText("bulk.move.cannotperform"));
            return "error";
        }
        String movedIssueKey = this.findFirstMovedIssueKey();
        if (movedIssueKey != null) {
            this.addErrorMessage(this.getText("bulk.move.error.issue.already.moved", movedIssueKey));
            return "error";
        }
        Optional<Issue> firstUpdated = this.bulkMigrateOperation.isConcurrentIssueUpdate(this.getRootBulkEditBean());
        if (firstUpdated.isPresent()) {
            this.addErrorMessage(this.getText("bulk.move.error.issue.updated", firstUpdated.get().getKey()));
            return "error";
        }
        String taskName = this.getText("bulk.operation.progress.taskname.migrate", this.getRootBulkEditBean().getSelectedIssuesIncludingSubTasks().size());
        return this.submitBulkOperationTask(this.getRootBulkEditBean(), this.getBulkMigrateOperation(), taskName);
    }

    private String findFirstMovedIssueKey() {
        List selectedIssues = this.getBulkEditBean().getSelectedIssues();
        for (Issue selectedIssue : selectedIssues) {
            MutableIssue latestIssue = this.getIssueManager().getIssueObject(selectedIssue.getId());
            if (latestIssue.getKey().equals(selectedIssue.getKey())) continue;
            return selectedIssue.getKey();
        }
        return null;
    }

    @Override
    public BulkEditBean getBulkEditBean() {
        if (this.getCurrentRootBulkEditBean() != null) {
            return this.getCurrentRootBulkEditBean().getRelatedMultiBulkMoveBean().getCurrentBulkEditBean();
        }
        return null;
    }

    public MultiBulkMoveBean getMultiBulkMoveBean() {
        return this.getCurrentRootBulkEditBean().getRelatedMultiBulkMoveBean();
    }

    public IssueContext getCurrentIssueContext() {
        return this.getCurrentRootBulkEditBean().getRelatedMultiBulkMoveBean().getCurrentIssueContext();
    }

    public String getNameTranslation(IssueType issueType) {
        if (issueType != null) {
            return issueType.getNameTranslation();
        }
        return null;
    }

    public BulkEditBean getCurrentRootBulkEditBean() {
        BulkEditBean currentBulkEditBean = null;
        if (!this.isSubTaskPhase()) {
            currentBulkEditBean = this.getRootBulkEditBean();
        } else if (this.getRootBulkEditBean() != null) {
            currentBulkEditBean = this.getRootBulkEditBean().getRelatedMultiBulkMoveBean().getCurrentBulkEditBean();
        }
        return currentBulkEditBean;
    }

    @Override
    public String getOperationDetailsActionName() {
        return this.getBulkMigrateOperation().getOperationName() + "Details.jspa";
    }

    public String getprojectFieldName(BulkEditBean bulkEditBean) {
        return bulkEditBean.getKey() + "pid";
    }

    public String getIssueParentFieldName(BulkEditBean bulkEditBean) {
        return bulkEditBean.getKey() + "parentIssueKey";
    }

    public String getSameAsBulkEditBean() {
        return this.sameAsBulkEditBean;
    }

    public void setSameAsBulkEditBean(String sameAsBulkEditBean) {
        this.sameAsBulkEditBean = sameAsBulkEditBean;
    }

    protected BulkMigrateOperation getBulkMigrateOperation() {
        return this.bulkMigrateOperation;
    }

    @Override
    public String getRedirectUrl() throws Exception {
        return this.decorateRedirectUrl(super.getRedirectUrl());
    }

    private String decorateRedirectUrl(String url) {
        return this.isSubTaskPhase() ? url + "?subTaskPhase=" + this.isSubTaskPhase() : url;
    }

    private String getNextRedirect() {
        if (!this.getBulkMigrateOperation().isStatusValid(this.getCurrentRootBulkEditBean())) {
            return this.getRedirect(this.decorateRedirectUrl("BulkMigrateChooseStatus!default.jspa"));
        }
        return this.getRedirect(this.decorateRedirectUrl("BulkMigrateSetFields!default.jspa"));
    }

    public Long getSingleIssueId() {
        return this.singleIssueId;
    }

    public void setSingleIssueId(Long singleIssueId) {
        this.singleIssueId = singleIssueId;
    }

    public SuggestionBean getIssuepickerDataSuggestion(String currentIssueKey) {
        if (StringUtils.isEmpty((CharSequence)currentIssueKey)) {
            return new SuggestionBean("", "", null, false);
        }
        IssueService.IssueResult issueResult = this.issueService.getIssue(this.getLoggedInUser(), currentIssueKey);
        MutableIssue issue = issueResult.getIssue();
        if (issue != null) {
            String description = "";
            if (!StringUtils.isBlank((CharSequence)issue.getDescription())) {
                description = String.format(" - %s", issue.getDescription());
            }
            return new SuggestionBean(issue.getKey() + description, issue.getKey(), JiraUrl.constructBaseUrl((HttpServletRequest)this.getHttpRequest()) + issue.getIssueType().getIconUrl(), true);
        }
        return new SuggestionBean(currentIssueKey, currentIssueKey, null, true);
    }

    public boolean isParentIssueInherited(BulkEditBean bulkEditBean) {
        return bulkEditBean.getParentBulkEditBean() != null && bulkEditBean.getParentIssueKey() != null;
    }

    public boolean isParentSelectPresent(BulkEditBean bulkEditBean) {
        return bulkEditBean.getParentBulkEditBean() == null;
    }

    public String getIssueKeys(BulkEditBean bulkEditBean) {
        return StringUtils.join((Iterable)bulkEditBean.getSelectedIssues().stream().map(issue -> issue.getKey()).collect(Collectors.toList()), (char)',');
    }

    public boolean isFieldCopiedFromParent(OrderableField orderableField, BulkEditBean bulkEditBean) {
        return orderableField instanceof SecurityLevelSystemField && bulkEditBean.getParentIssueObject() != null;
    }

    public boolean isSubtaskToIssue(BulkEditBean bulkEditBean) {
        return bulkEditBean.getSelectedIssues().size() > 0 && ((Issue)bulkEditBean.getSelectedIssues().iterator().next()).getIssueType().isSubTask() && !bulkEditBean.getTargetIssueType().isSubTask();
    }

    public boolean isIssueToSubtask(BulkEditBean bulkEditBean) {
        return bulkEditBean.getSelectedIssues().size() > 0 && !((Issue)bulkEditBean.getSelectedIssues().iterator().next()).getIssueType().isSubTask() && bulkEditBean.getTargetIssueType().isSubTask();
    }

    public boolean isSubtaskToSubtask(BulkEditBean bulkEditBean) {
        return bulkEditBean.getSelectedIssues().stream().findFirst().map(Issue::isSubTask).orElse(false);
    }

    @Override
    public boolean isAllowProjectEdit(BulkEditBean bulkEditBean) {
        return bulkEditBean.getParentBulkEditBean() == null;
    }
}

