/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.search.SearchRequestInfo;
import com.atlassian.jira.plugin.searchrequestview.SearchRequestViewModuleDescriptor;
import com.atlassian.jira.plugin.util.ModuleDescriptorComparator;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.action.issue.IssueSearchLimits;
import com.atlassian.jira.web.action.issue.URLUtil;
import com.atlassian.jira.web.action.issue.navigator.ToolOptionGroup;
import com.atlassian.jira.web.action.issue.navigator.ToolOptionItem;
import com.atlassian.jira.web.action.issue.util.ConditionalDescriptorPredicate;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import webwork.action.ServletActionContext;

public class IssueNavigatorViewsHelper {
    private static final Logger log = LoggerFactory.getLogger(IssueNavigatorViewsHelper.class);
    private final JiraAuthenticationContext authContext;
    private final PluginAccessor pluginAccessor;
    private final IssueSearchLimits issueSearchLimits;
    private final SearchRequestInfo searchRequestInfo;
    private final SearchService searchService;

    public IssueNavigatorViewsHelper(JiraAuthenticationContext authContext, PluginAccessor pluginAccessor, IssueSearchLimits issueSearchLimits, SearchService searchService, SearchRequestInfo searchRequestInfo) {
        this.authContext = authContext;
        this.pluginAccessor = pluginAccessor;
        this.issueSearchLimits = issueSearchLimits;
        this.searchRequestInfo = searchRequestInfo;
        this.searchService = searchService;
    }

    public List<ToolOptionGroup> getViewOptions(String view) {
        Collection<SearchRequestViewModuleDescriptor> nonSystemSearchRequestViews;
        ArrayList groups = Lists.newArrayList();
        ToolOptionGroup viewGroup = new ToolOptionGroup("viewOptions-dropdown", "");
        if ("bulk".equals(view)) {
            String href = "?view=&tempMax=-1&decorator=";
            viewGroup.addItem(new ToolOptionItem("", this.getText("navigator.results.currentview.browser"), href, null, "nofollow"));
        }
        this.addModuleDescriptor(viewGroup, this.searchRequestInfo, this.getPrintable(), "printable", this.getText("navigator.results.currentview.browser.printable"));
        this.addModuleDescriptor(viewGroup, this.searchRequestInfo, this.getFullContent(), "fullContent", this.getText("navigator.results.currentview.browser.full"));
        this.addIfNonEmpty(groups, viewGroup);
        ToolOptionGroup rssGroup = new ToolOptionGroup();
        this.addModuleDescriptor(rssGroup, this.searchRequestInfo, this.getRssIssues(), "rssIssues", this.getText("navigator.results.currentview.rss") + " (" + this.getText("navigator.results.currentview.rss.issues") + ")");
        this.addModuleDescriptor(rssGroup, this.searchRequestInfo, this.getRssComments(), "rssComments", this.getText("navigator.results.currentview.rss") + " (" + this.getText("navigator.results.currentview.rss.comments") + ")");
        this.addIfNonEmpty(groups, rssGroup);
        ToolOptionGroup dataGroup = new ToolOptionGroup();
        this.addModuleDescriptor(dataGroup, this.searchRequestInfo, this.getAllCsvFields(), "allCsvFields", this.getText("navigator.results.currentview.excel.csv.all"), Function.identity());
        this.addModuleDescriptor(dataGroup, this.searchRequestInfo, this.getCurrentCsvFields(), "currentCsvFields", this.getText("navigator.results.currentview.excel.csv.current"), Function.identity());
        this.addModuleDescriptor(dataGroup, this.searchRequestInfo, this.getXml(), "xml", this.getText("navigator.results.currentview.xml"));
        this.addIfNonEmpty(groups, dataGroup);
        ToolOptionGroup officeGroup = new ToolOptionGroup();
        this.addModuleDescriptor(officeGroup, this.searchRequestInfo, this.getWord(), "word", this.getText("navigator.results.currentview.word"));
        this.addModuleDescriptor(officeGroup, this.searchRequestInfo, this.getAllExcelFields(), "allExcelFields", this.getText("navigator.results.currentview.excel.html.all"), Function.identity());
        this.addModuleDescriptor(officeGroup, this.searchRequestInfo, this.getCurrentExcelFields(), "currentExcelFields", this.getText("navigator.results.currentview.excel.html.current"), Function.identity());
        this.addIfNonEmpty(groups, officeGroup);
        SearchRequestViewModuleDescriptor chart = this.getChart();
        if (null != chart && null != this.authContext.getLoggedInUser()) {
            ToolOptionGroup dashboardGroup = new ToolOptionGroup();
            dashboardGroup.addItem(new ToolOptionItem("onDashboard", this.getText("navigator.results.currentview.dashboard.charts"), "#", true, null, "nofollow"));
            groups.add(dashboardGroup);
        }
        if (!(nonSystemSearchRequestViews = this.getNonSystemSearchRequestViews()).isEmpty()) {
            ToolOptionGroup nonSystemGroup = new ToolOptionGroup();
            for (SearchRequestViewModuleDescriptor moduleDescriptor : nonSystemSearchRequestViews) {
                String href = moduleDescriptor.getURLWithoutContextPath(this.searchRequestInfo);
                nonSystemGroup.addItem(new ToolOptionItem(null, moduleDescriptor.getName(), href, null, "nofollow"));
            }
            this.addIfNonEmpty(groups, nonSystemGroup);
        }
        return groups;
    }

    private void addModuleDescriptor(ToolOptionGroup options, SearchRequestInfo searchRequestInfo, SearchRequestViewModuleDescriptor moduleDescriptor, String id, String labelKey) {
        this.addModuleDescriptor(options, searchRequestInfo, moduleDescriptor, id, labelKey, this::getRestricted);
    }

    private void addModuleDescriptor(ToolOptionGroup options, SearchRequestInfo searchRequestInfo, SearchRequestViewModuleDescriptor moduleDescriptor, String id, String labelKey, Function<String, String> urlFilter) {
        if (null != moduleDescriptor && (moduleDescriptor.getCondition() == null || moduleDescriptor.getCondition().shouldDisplay((Map)Maps.newHashMap()))) {
            String href = urlFilter.apply(moduleDescriptor.getURLWithoutContextPath(searchRequestInfo));
            options.addItem(new ToolOptionItem(id, labelKey, href, null, "nofollow"));
        }
    }

    private void addIfNonEmpty(List<ToolOptionGroup> groups, ToolOptionGroup group) {
        if (!group.isEmpty()) {
            groups.add(group);
        }
    }

    public SearchRequestViewModuleDescriptor getPrintable() {
        return (SearchRequestViewModuleDescriptor)this.pluginAccessor.getEnabledPluginModule("jira.issueviews:searchrequest-printable");
    }

    public SearchRequestViewModuleDescriptor getFullContent() {
        return (SearchRequestViewModuleDescriptor)this.pluginAccessor.getEnabledPluginModule("jira.issueviews:searchrequest-fullcontent");
    }

    public SearchRequestViewModuleDescriptor getXml() {
        return (SearchRequestViewModuleDescriptor)this.pluginAccessor.getEnabledPluginModule("jira.issueviews:searchrequest-xml");
    }

    public SearchRequestViewModuleDescriptor getRssIssues() {
        return (SearchRequestViewModuleDescriptor)this.pluginAccessor.getEnabledPluginModule("jira.issueviews:searchrequest-rss");
    }

    public SearchRequestViewModuleDescriptor getRssComments() {
        return (SearchRequestViewModuleDescriptor)this.pluginAccessor.getEnabledPluginModule("jira.issueviews:searchrequest-comments-rss");
    }

    public SearchRequestViewModuleDescriptor getWord() {
        return (SearchRequestViewModuleDescriptor)this.pluginAccessor.getEnabledPluginModule("jira.issueviews:searchrequest-word");
    }

    public SearchRequestViewModuleDescriptor getAllExcelFields() {
        return (SearchRequestViewModuleDescriptor)this.pluginAccessor.getEnabledPluginModule("jira.issueviews:searchrequest-excel-all-fields");
    }

    public SearchRequestViewModuleDescriptor getCurrentExcelFields() {
        return (SearchRequestViewModuleDescriptor)this.pluginAccessor.getEnabledPluginModule("jira.issueviews:searchrequest-excel-current-fields");
    }

    public SearchRequestViewModuleDescriptor getAllCsvFields() {
        return (SearchRequestViewModuleDescriptor)this.pluginAccessor.getEnabledPluginModule("jira.issueviews:searchrequest-csv-all-fields");
    }

    public SearchRequestViewModuleDescriptor getCurrentCsvFields() {
        return (SearchRequestViewModuleDescriptor)this.pluginAccessor.getEnabledPluginModule("jira.issueviews:searchrequest-csv-current-fields");
    }

    public SearchRequestViewModuleDescriptor getChart() {
        return (SearchRequestViewModuleDescriptor)this.pluginAccessor.getEnabledPluginModule("jira.issueviews:searchrequest-charts-view");
    }

    public String getRestricted(String url) {
        return URLUtil.addRequestParameter(url, this.getRestrictionClause());
    }

    public String getSearchRequestJqlString() {
        if (this.searchRequestInfo != null) {
            return this.searchService.getJqlString(this.searchRequestInfo.getQuery());
        }
        return "";
    }

    private String getRestrictionClause() {
        int count = this.issueSearchLimits.getMaxResults();
        if (count <= 0) {
            return null;
        }
        return "tempMax=" + count;
    }

    public Collection<SearchRequestViewModuleDescriptor> getNonSystemSearchRequestViews() {
        ArrayList enabledModuleDescriptorsByClass = new ArrayList(this.pluginAccessor.getEnabledModuleDescriptorsByClass(SearchRequestViewModuleDescriptor.class));
        Iterator iterator = enabledModuleDescriptorsByClass.iterator();
        while (iterator.hasNext()) {
            SearchRequestViewModuleDescriptor moduleDescriptor = (SearchRequestViewModuleDescriptor)iterator.next();
            if ("jira.issueviews:searchrequest-printable".equals(moduleDescriptor.getCompleteKey())) {
                iterator.remove();
            }
            if ("jira.issueviews:searchrequest-fullcontent".equals(moduleDescriptor.getCompleteKey())) {
                iterator.remove();
            }
            if ("jira.issueviews:searchrequest-xml".equals(moduleDescriptor.getCompleteKey())) {
                iterator.remove();
            }
            if ("jira.issueviews:searchrequest-rss".equals(moduleDescriptor.getCompleteKey())) {
                iterator.remove();
            }
            if ("jira.issueviews:searchrequest-comments-rss".equals(moduleDescriptor.getCompleteKey())) {
                iterator.remove();
            }
            if ("jira.issueviews:searchrequest-word".equals(moduleDescriptor.getCompleteKey())) {
                iterator.remove();
            }
            if ("jira.issueviews:searchrequest-excel-all-fields".equals(moduleDescriptor.getCompleteKey())) {
                iterator.remove();
            }
            if ("jira.issueviews:searchrequest-excel-current-fields".equals(moduleDescriptor.getCompleteKey())) {
                iterator.remove();
            }
            if ("jira.issueviews:searchrequest-charts-view".equals(moduleDescriptor.getCompleteKey())) {
                iterator.remove();
            }
            if ("jira.issueviews:searchrequest-csv-all-fields".equals(moduleDescriptor.getCompleteKey())) {
                iterator.remove();
            }
            if (!"jira.issueviews:searchrequest-csv-current-fields".equals(moduleDescriptor.getCompleteKey())) continue;
            iterator.remove();
        }
        return Ordering.from((Comparator)ModuleDescriptorComparator.COMPARATOR).compound((Comparator)Ordering.natural().onResultOf(input -> input == null ? null : input.getName())).sortedCopy(Iterables.filter(enabledModuleDescriptorsByClass, (Predicate)new ConditionalDescriptorPredicate(IssueNavigatorViewsHelper.makeContext(this.authContext.getLoggedInUser(), new JiraHelper(ServletActionContext.getRequest())))));
    }

    public static Map<String, Object> makeContext(ApplicationUser remoteUser, JiraHelper jiraHelper) {
        Map params = jiraHelper.getContextParams();
        params.put("user", remoteUser);
        params.put("helper", jiraHelper);
        return params;
    }

    private String getText(String key) {
        return this.authContext.getI18nHelper().getText(key);
    }

    private String getText(String key, Object values) {
        return this.authContext.getI18nHelper().getText(key, values);
    }
}

