/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.bc.issue.visibility.Visibilities;
import com.atlassian.jira.bc.issue.visibility.Visibility;
import com.atlassian.jira.bc.issue.worklog.WorklogAdjustmentAmountInputParameters;
import com.atlassian.jira.bc.issue.worklog.WorklogAdjustmentAmountResult;
import com.atlassian.jira.bc.issue.worklog.WorklogInputParameters;
import com.atlassian.jira.bc.issue.worklog.WorklogInputParametersImpl;
import com.atlassian.jira.bc.issue.worklog.WorklogNewEstimateInputParameters;
import com.atlassian.jira.bc.issue.worklog.WorklogNewEstimateResult;
import com.atlassian.jira.bc.issue.worklog.WorklogResult;
import com.atlassian.jira.bc.issue.worklog.WorklogService;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.exception.IssueNotFoundException;
import com.atlassian.jira.exception.IssuePermissionException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.fields.CommentVisibility;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.JiraDurationUtils;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.jira.web.action.issue.AbstractWorklogAction;
import java.util.Date;

public class CreateWorklog
extends AbstractWorklogAction {
    private static final String SECURITY_BREACH = "securitybreach";
    private Worklog worklog;
    private WorklogResult worklogResult;

    public CreateWorklog(WorklogService worklogService, CommentService commentService, ProjectRoleManager projectRoleManager, JiraDurationUtils jiraDurationUtils, DateTimeFormatterFactory dateTimeFormatterFactory, FieldVisibilityManager fieldVisibilityManager, FieldLayoutManager fieldLayoutManager, RendererManager rendererManager, UserUtil userUtil, FeatureManager featureManager) {
        super(worklogService, commentService, projectRoleManager, jiraDurationUtils, fieldVisibilityManager, fieldLayoutManager, rendererManager, userUtil, featureManager, dateTimeFormatterFactory);
    }

    public String doDefault() throws Exception {
        this.setStartDate(this.getFormattedStartDate(new Date()));
        return super.doDefault();
    }

    protected void doValidation() {
        try {
            this.getIssue();
        }
        catch (IssuePermissionException ipe) {
            return;
        }
        catch (IssueNotFoundException infe) {
            return;
        }
        CommentVisibility commentVisibility = this.getCommentVisibility();
        Visibility visibility = Visibilities.fromGroupAndStrRoleId((String)commentVisibility.getGroupLevel(), (String)commentVisibility.getRoleLevel());
        WorklogInputParametersImpl.Builder builder = WorklogInputParametersImpl.issue((Issue)this.getIssueObject()).timeSpent(this.getTimeLogged()).startDate(this.getParsedStartDate()).comment(this.getComment()).visibility(visibility);
        if ("new".equalsIgnoreCase(this.adjustEstimate)) {
            WorklogNewEstimateInputParameters params = builder.newEstimate(this.getNewEstimate()).buildNewEstimate();
            this.worklogResult = this.worklogService.validateCreateWithNewEstimate(this.getJiraServiceContext(), params);
        } else if ("manual".equalsIgnoreCase(this.adjustEstimate)) {
            WorklogAdjustmentAmountInputParameters params = builder.adjustmentAmount(this.getAdjustmentAmount()).buildAdjustmentAmount();
            this.worklogResult = this.worklogService.validateCreateWithManuallyAdjustedEstimate(this.getJiraServiceContext(), params);
        } else {
            WorklogInputParameters params = builder.build();
            this.worklogResult = this.worklogService.validateCreate(this.getJiraServiceContext(), params);
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        if (this.isTimeTrackingFieldHidden(this.getIssueObject())) {
            return SECURITY_BREACH;
        }
        this.worklog = "auto".equalsIgnoreCase(this.adjustEstimate) ? this.worklogService.createAndAutoAdjustRemainingEstimate(this.getJiraServiceContext(), this.worklogResult, true) : ("new".equalsIgnoreCase(this.adjustEstimate) ? this.worklogService.createWithNewRemainingEstimate(this.getJiraServiceContext(), (WorklogNewEstimateResult)this.worklogResult, true) : ("manual".equalsIgnoreCase(this.adjustEstimate) ? this.worklogService.createWithManuallyAdjustedEstimate(this.getJiraServiceContext(), (WorklogAdjustmentAmountResult)this.worklogResult, true) : this.worklogService.createAndRetainRemainingEstimate(this.getJiraServiceContext(), this.worklogResult, true)));
        if (this.getHasErrorMessages()) {
            return "error";
        }
        if (this.isInlineDialogMode()) {
            return this.returnComplete();
        }
        return this.getRedirect("/browse/" + this.getIssue().getString("key"));
    }

    public Worklog getWorklog() {
        if (this.worklog == null && this.worklogResult != null) {
            this.worklog = this.worklogResult.getWorklog();
        }
        return this.worklog;
    }

    public boolean isCreateWorklog() {
        return true;
    }
}

