/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.user;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.plugin.user.PasswordPolicyManager;
import com.atlassian.jira.plugin.user.WebErrorMessage;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.action.admin.user.PasswordChangeService;
import com.atlassian.jira.web.action.admin.user.ViewUser;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SetPassword
extends ViewUser {
    private final PasswordPolicyManager passwordPolicyManager;
    private final PasswordChangeService passwordChangeService;
    private final List<WebErrorMessage> passwordErrors = new ArrayList<WebErrorMessage>();
    private String password;
    private String confirm;

    public SetPassword(CrowdService crowdService, CrowdDirectoryService crowdDirectoryService, UserPropertyManager userPropertyManager, UserManager userManager, PasswordPolicyManager passwordPolicyManager, PasswordChangeService passwordChangeService) {
        super(crowdService, crowdDirectoryService, userPropertyManager, userManager);
        this.passwordChangeService = passwordChangeService;
        this.passwordPolicyManager = (PasswordPolicyManager)Assertions.notNull((String)"passwordPolicyManager", (Object)passwordPolicyManager);
    }

    @Override
    protected void doValidation() {
        super.doValidation();
        if (!this.hasGlobalPermission(GlobalPermissionKey.ADMINISTER)) {
            this.addErrorMessage(this.getText("admin.errors.must.be.admin.to.set.password"));
        }
        if (!this.isRemoteUserPermittedToEditSelectedUser()) {
            this.addErrorMessage(this.getText("admin.errors.must.be.sysadmin.to.set.sysadmin.password"));
        }
        if (!TextUtils.stringSet((String)this.password)) {
            this.addError("password", this.getText("admin.errors.must.specify.a.password"));
        } else if (!this.password.equals(this.confirm)) {
            this.addError("confirm", this.getText("admin.errors.two.passwords.do.not.match"));
        } else {
            Collection<WebErrorMessage> messages = this.passwordPolicyManager.checkPolicy(this.getApplicationUser(), null, this.password);
            if (!messages.isEmpty()) {
                this.addError("password", this.getText("changepassword.new.password.rejected"));
                for (WebErrorMessage message : messages) {
                    this.passwordErrors.add(message);
                }
            }
        }
    }

    @Override
    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        this.passwordChangeService.setPassword((ErrorCollection)this, this.getUser(), this.password);
        if (this.invalidInput()) {
            return "error";
        }
        return this.returnComplete("/secure/admin/user/ViewUser.jspa?name=" + JiraUrlCodec.encode((String)this.getName()) + "&showPasswordUpdateMsg=true");
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public List<WebErrorMessage> getPasswordErrors() {
        return this.passwordErrors;
    }

    public String getConfirm() {
        return this.confirm;
    }

    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }
}

