/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.permission;

import com.atlassian.fugue.Option;
import com.atlassian.jira.permission.PermissionSchemeEntry;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.permission.PermissionTypeManager;
import com.atlassian.jira.permission.ProjectPermission;
import com.atlassian.jira.permission.management.ProjectPermissionFeatureHelper;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.scheme.SchemeType;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.web.action.admin.permission.SchemeAwarePermissionAction;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.Map;
import org.ofbiz.core.entity.GenericEntityException;
import webwork.action.ActionContext;

@WebSudoRequired
public class AddPermission
extends SchemeAwarePermissionAction {
    private String type;
    private String[] permissions;
    private final PermissionManager permissionManager;
    private final PermissionSchemeManager permissionSchemeManager;
    private final PermissionTypeManager permissionTypeManager;
    private final UserKeyService userKeyService;
    private final ProjectPermissionFeatureHelper projectPermissionFeatureHelper;

    public AddPermission(PermissionManager permissionManager, PermissionSchemeManager permissionSchemeManager, PermissionTypeManager permissionTypeManager, UserKeyService userKeyService, ProjectPermissionFeatureHelper projectPermissionFeatureHelper) {
        this.permissionManager = permissionManager;
        this.permissionSchemeManager = permissionSchemeManager;
        this.permissionTypeManager = permissionTypeManager;
        this.userKeyService = userKeyService;
        this.projectPermissionFeatureHelper = projectPermissionFeatureHelper;
    }

    public String doDefault() throws Exception {
        if (!this.projectPermissionFeatureHelper.useOldProjectPermissionPage().booleanValue()) {
            return this.getRedirect(this.projectPermissionFeatureHelper.getNewEditPermissionUrl(this.getSchemeId()));
        }
        return super.doDefault();
    }

    protected void doValidation() {
        try {
            String permType = this.getType();
            SchemeType schemeType = (SchemeType)this.permissionTypeManager.getSchemeType(permType);
            if (this.getSchemeId() == null || this.getScheme() == null) {
                this.addErrorMessage(this.getText("admin.permissions.errors.mustselectscheme"));
            }
            if (this.getPermissions() == null || this.getPermissions().length == 0) {
                this.addError("permissions", this.getText("admin.permissions.errors.mustselectpermission"));
            }
            if (!TextUtils.stringSet((String)permType)) {
                this.addErrorMessage(this.getText("admin.permissions.errors.mustselecttype"));
            } else if (schemeType != null) {
                schemeType.doValidation(permType, this.getParameters(), this.getJiraServiceContext());
            }
            if (this.getPermissions() != null) {
                for (String permissionKeyStr : this.getPermissions()) {
                    if (permissionKeyStr == null) continue;
                    ProjectPermissionKey permissionKey = new ProjectPermissionKey(permissionKeyStr);
                    if (this.permissionManager.getProjectPermission(permissionKey).isEmpty()) {
                        this.addErrorMessage(this.getText("admin.permissions.errors.permissiondoesnotexist", permissionKey.permissionKey()));
                        continue;
                    }
                    if (schemeType == null || schemeType.isValidForPermission(permissionKey)) continue;
                    String permName = this.getPermissionName(permissionKey);
                    this.addErrorMessage(this.getText("admin.permissions.errors.invalid.combination", permName, schemeType.getDisplayName()));
                }
            }
        }
        catch (GenericEntityException e) {
            this.addErrorMessage(this.getText("admin.errors.permissions.error.occured.adding", "\n") + e.getMessage());
        }
    }

    private String getPermissionName(ProjectPermissionKey permissionKey) {
        Option permission = this.permissionManager.getProjectPermission(permissionKey);
        return permission.isDefined() ? this.getText(((ProjectPermission)permission.get()).getNameI18nKey()) : "";
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        String permissionType = this.getType();
        String parameter = this.getParameter(permissionType);
        for (String permissionKeyStr : this.getPermissions()) {
            ProjectPermissionKey permissionKey = new ProjectPermissionKey(permissionKeyStr);
            if (this.permissionExists(permissionKey, permissionType, parameter)) continue;
            SchemeEntity schemeEntity = new SchemeEntity(permissionType, parameter, (Object)permissionKey);
            this.permissionSchemeManager.createSchemeEntity(this.getScheme(), schemeEntity);
        }
        return this.getRedirect(this.getRedirectURL() + this.getSchemeId());
    }

    private boolean permissionExists(ProjectPermissionKey permissionKey, String type, String parameter) throws GenericEntityException {
        for (PermissionSchemeEntry permissionSchemeEntry : this.permissionSchemeManager.getPermissionSchemeEntries(this.getSchemeObject(), permissionKey)) {
            if (!permissionSchemeEntry.getType().equals(type) || !Objects.equal((Object)parameter, (Object)permissionSchemeEntry.getParameter())) continue;
            return true;
        }
        return false;
    }

    public Map getTypes() {
        return Maps.newLinkedHashMap(this.permissionTypeManager.getTypes());
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Map getParameters() {
        return ActionContext.getSingleValueParameters();
    }

    public String getParameter(String key) {
        String param = (String)this.getParameters().get(key);
        if (key.equals("user")) {
            param = this.userKeyService.getKeyForUsername(param);
        }
        return TextUtils.stringSet((String)param) ? param : null;
    }

    @Override
    public String getRedirectURL() {
        return "EditPermissions!default.jspa?schemeId=";
    }

    public Collection<ProjectPermission> getAllPermissions() {
        return this.permissionManager.getAllProjectPermissions();
    }

    public String[] getPermissions() {
        return this.permissions;
    }

    public void setPermissions(String[] permissions) {
        this.permissions = permissions;
    }
}

