/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuetypes.pro;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.bulkedit.operation.BulkMoveOperation;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.entity.WithFunctions;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.option.IssueConstantOption;
import com.atlassian.jira.issue.fields.option.OptionSetManager;
import com.atlassian.jira.issue.fields.option.ProjectOption;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.ExceptionUtil;
import com.atlassian.jira.web.action.admin.issuetypes.AbstractManageIssueTypeOptionsAction;
import com.atlassian.jira.web.action.admin.issuetypes.IssueTypeManageableOption;
import com.atlassian.jira.web.action.admin.issuetypes.pro.AssociateIssueTypeSchemes;
import com.atlassian.query.Query;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.map.ListOrderedMap;

@WebSudoRequired
public class SelectIssueTypeSchemeForProject
extends AssociateIssueTypeSchemes {
    private static final String CREATE_SCHEME = "createScheme";
    private static final String CHOOSE_SCHEME = "chooseScheme";
    private static final String CHOOSE_PROJECT = "chooseProject";
    private Long projectId;
    private String createType;
    private Long sameAsProjectId;
    private String[] selectedOptions;
    private long subTaskCount = -1L;
    private long standardIssuesCount = -1L;

    public SelectIssueTypeSchemeForProject(FieldConfigSchemeManager configSchemeManager, IssueTypeSchemeManager issueTypeSchemeManager, FieldManager fieldManager, OptionSetManager optionSetManager, IssueTypeManageableOption manageableOptionType, BulkMoveOperation bulkMoveOperation, SearchProvider searchProvider, ProjectManager projectManager, IssueManager issueManager) {
        super(configSchemeManager, issueTypeSchemeManager, fieldManager, optionSetManager, manageableOptionType, bulkMoveOperation, searchProvider, projectManager, issueManager);
    }

    @Override
    public String doDefault() throws Exception {
        FieldConfigScheme currentScheme = this.getCurrentIssueTypeScheme();
        if (currentScheme != null) {
            this.setSchemeId(currentScheme.getId());
        }
        this.setCreateType(CHOOSE_SCHEME);
        return "input";
    }

    protected void doValidation() {
        if (CREATE_SCHEME.equals(this.getCreateType())) {
            FieldConfigScheme existingAutoCreatedScheme = this.getExistingAutoCreatedScheme();
            if (existingAutoCreatedScheme != null) {
                this.addErrorMessage(this.getText("admin.errors.already.an.issue.type.scheme.with.that.name"));
            }
            if (this.getSelectedOptions() != null) {
                boolean hasNormalIssueType = false;
                boolean hasSubTaskIssueType = false;
                for (int i = 0; i < this.getSelectedOptions().length; ++i) {
                    String id = this.getSelectedOptions()[i];
                    IssueType issueType = ComponentAccessor.getConstantsManager().getIssueTypeObject(id);
                    if (!issueType.isSubTask()) {
                        hasNormalIssueType = true;
                        continue;
                    }
                    hasSubTaskIssueType = true;
                }
                if (!hasNormalIssueType) {
                    this.addError("selectedOptions", this.getText("admin.errors.must.select.at.least.one.standard.issue.type"));
                }
                try {
                    if (!hasSubTaskIssueType && this.getSubTaskIssues() > 0L) {
                        this.addError("selectedOptions", this.getText("admin.errors.project.has.subtasks", "" + this.getSubTaskIssues()));
                    }
                }
                catch (SearchException e) {
                    this.addErrorMessage(this.getText("admin.projects.issuetypescheme.error.sever", ExceptionUtil.getExceptionAsHtml(e)));
                }
            } else {
                this.addError("selectedOptions", this.getText("admin.errors.must.select.at.least.one.standard.issue.type"));
            }
        } else if (CHOOSE_PROJECT.equals(this.getCreateType()) && this.sameAsProjectId == null) {
            this.addError("sameAsProjectId", this.getText("admin.projects.issuetypescheme.error.must.select.project"));
        }
    }

    @Override
    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        FieldConfigScheme configScheme;
        if (CREATE_SCHEME.equals(this.getCreateType())) {
            FieldConfigScheme createdScheme = this.issueTypeSchemeManager.create(this.getDefaultNameForNewScheme(), "", EasyList.build((Object[])this.getSelectedOptions()));
            this.setConfigScheme(createdScheme);
        } else if (CHOOSE_PROJECT.equals(this.getCreateType())) {
            FieldConfigScheme schemeOfSelectedProject = this.configSchemeManager.getFieldConfigScheme(this.sameAsProjectId);
            this.setConfigScheme(schemeOfSelectedProject);
        }
        if (this.getCurrentIssueTypeScheme().equals(this.getConfigScheme())) {
            return this.getRedirect("/plugins/servlet/project-config/" + this.getProject().getKey() + "/issuetypes");
        }
        if (this.getConfigScheme().isGlobal()) {
            this.setConfigScheme(this.getCurrentIssueTypeScheme());
            configScheme = this.getConfigScheme();
            ArrayList projectsList = Lists.newArrayList((Iterable)configScheme.getAssociatedProjectObjects());
            projectsList.remove(this.getProject());
            this.setProjects(projectsList);
            String result = super.doExecute(false);
            ((Object)((Object)this)).getClass();
            if (result.equals("NO_REDIRECT")) {
                return this.getRedirect("/plugins/servlet/project-config/" + this.getProject().getKey() + "/issuetypes");
            }
            return result;
        }
        configScheme = this.getConfigScheme();
        List associatedProjects = configScheme.getAssociatedProjectObjects();
        ArrayList<Object> projectsList = associatedProjects != null && !associatedProjects.isEmpty() ? new ArrayList(associatedProjects) : new ArrayList<Project>(1);
        projectsList.add(this.getProject());
        Long[] projectIds = Lists.newArrayList((Iterable)Iterables.transform(projectsList, (Function)WithFunctions.getId())).toArray(new Long[projectsList.size()]);
        this.setProjects(projectIds);
        String result = super.doExecute(false);
        ((Object)((Object)this)).getClass();
        if (result.equals("NO_REDIRECT")) {
            return this.getRedirect("/plugins/servlet/project-config/" + this.getProject().getKey() + "/issuetypes");
        }
        return result;
    }

    public Project getProject() {
        return this.projectManager.getProjectObj(this.getProjectId());
    }

    public FieldConfigScheme getCurrentIssueTypeScheme() {
        return this.issueTypeSchemeManager.getConfigScheme(this.getProject());
    }

    public Collection getAllProjects() {
        return CollectionUtils.select(super.getAllProjects(), (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                ProjectOption projectOption = (ProjectOption)((Object)object);
                return !SelectIssueTypeSchemeForProject.this.getProjectId().toString().equals(projectOption.getId());
            }
        });
    }

    public List getAllSchemes() {
        return this.issueTypeSchemeManager.getAllSchemes();
    }

    public FieldConfigScheme getConfigSchemeForProject(String project) {
        return this.issueTypeSchemeManager.getConfigScheme(this.projectManager.getProjectObjByName(project));
    }

    public Map getTypeOptions() throws Exception {
        ListOrderedMap typeOptions = new ListOrderedMap();
        typeOptions.put((Object)CHOOSE_SCHEME, (Object)this.getText("admin.projects.issuetypescheme.radio1"));
        if (!this.getAllProjects().isEmpty()) {
            typeOptions.put((Object)CHOOSE_PROJECT, (Object)this.getText("admin.projects.issuetypescheme.radio2"));
        }
        typeOptions.put((Object)CREATE_SCHEME, (Object)this.getText("admin.projects.issuetypescheme.radio4"));
        return typeOptions;
    }

    public String getDefaultNameForNewScheme() {
        return this.getText("admin.projects.issuetypescheme.new.issue.type", this.getProject().getName());
    }

    public Collection<IssueConstantOption> getAllOptions() {
        String fieldId = this.getManageableOption().getFieldId();
        Collection constants = ComponentAccessor.getConstantsManager().getConstantObjects(fieldId);
        if (constants == null) {
            return new ArrayList<IssueConstantOption>();
        }
        return (Collection)constants.stream().map(IssueConstantOption::new).collect(CollectorsUtil.toNewArrayListWithSizeOf((Collection)constants));
    }

    public long getSubTaskIssues() throws SearchException {
        if (this.subTaskCount == -1L) {
            Query query = this.getQuery(EasyList.build((Object)this.getProjectId()), EasyList.build((Object)"-3"));
            this.subTaskCount = this.searchProvider.searchCount(query, this.getLoggedInUser());
        }
        return this.subTaskCount;
    }

    public long getStandardIssues() throws SearchException {
        if (this.standardIssuesCount == -1L) {
            Query query = this.getQuery(EasyList.build((Object)this.getProjectId()), EasyList.build((Object)"-2"));
            this.standardIssuesCount = this.searchProvider.searchCount(query, this.getLoggedInUser());
        }
        return this.standardIssuesCount;
    }

    public FieldConfigScheme getExistingAutoCreatedScheme() {
        Collection c = CollectionUtils.select((Collection)this.issueTypeSchemeManager.getAllSchemes(), (Predicate)new AbstractManageIssueTypeOptionsAction.FieldConfigPredicate(null, this.getDefaultNameForNewScheme()));
        if (c != null && !c.isEmpty()) {
            return (FieldConfigScheme)c.iterator().next();
        }
        return null;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getCreateType() {
        return this.createType;
    }

    public void setCreateType(String createType) {
        this.createType = createType;
    }

    public Long getSameAsProjectId() {
        return this.sameAsProjectId;
    }

    public void setSameAsProjectId(Long sameAsProjectId) {
        this.sameAsProjectId = sameAsProjectId;
    }

    public String[] getSelectedOptions() {
        return this.selectedOptions;
    }

    public void setSelectedOptions(String[] selectedOptions) {
        this.selectedOptions = selectedOptions;
    }
}

