/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuetypes.pro;

import com.atlassian.jira.bulkedit.operation.BulkMoveOperation;
import com.atlassian.jira.entity.WithFunctions;
import com.atlassian.jira.entity.WithId;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.IssueContextImpl;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.IssueTypeField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.option.OptionSet;
import com.atlassian.jira.issue.fields.option.OptionSetManager;
import com.atlassian.jira.issue.fields.option.ProjectOption;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.issuetypes.AbstractManageIssueTypeOptionsAction;
import com.atlassian.jira.web.action.admin.issuetypes.ExecutableAction;
import com.atlassian.jira.web.action.admin.issuetypes.IssueTypeManageableOption;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.query.Query;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

@WebSudoRequired
public class AssociateIssueTypeSchemes
extends AbstractManageIssueTypeOptionsAction
implements ExecutableAction {
    protected final String NO_REDIRECT = "NO_REDIRECT";
    private Long[] projects;
    protected final ProjectManager projectManager;

    public AssociateIssueTypeSchemes(FieldConfigSchemeManager configSchemeManager, IssueTypeSchemeManager issueTypeSchemeManager, FieldManager fieldManager, OptionSetManager optionSetManager, IssueTypeManageableOption manageableOptionType, BulkMoveOperation bulkMoveOperation, SearchProvider searchProvider, ProjectManager projectManager, IssueManager issueManager) {
        super(configSchemeManager, issueTypeSchemeManager, fieldManager, optionSetManager, manageableOptionType, bulkMoveOperation, searchProvider, issueManager);
        this.projectManager = projectManager;
    }

    public String doDefault() throws Exception {
        FieldConfigScheme configScheme = this.getConfigScheme();
        List projectsList = configScheme.getAssociatedProjectObjects();
        this.setProjects(Lists.newArrayList((Iterable)Iterables.transform((Iterable)projectsList, (Function)WithFunctions.getId())).toArray(new Long[projectsList.size()]));
        return super.doDefault();
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        return this.doExecute(true);
    }

    protected String doExecute(boolean useRedirect) throws Exception {
        if (this.getProjects() != null && this.getProjects().length > 0) {
            Query query;
            SearchResults searchResults;
            List affectedIssues;
            OptionSet targetOptionSet = this.optionSetManager.getOptionsForConfig(this.getConfigScheme().getOneAndOnlyConfig());
            Collection<Long> affectedProjectIds = this.getChangedProjectIds();
            HashSet<String> obseleteOptionIds = new HashSet<String>();
            IssueTypeField issueTypeField = this.fieldManager.getIssueTypeField();
            for (Long projectId : affectedProjectIds) {
                FieldConfig relevantConfig = issueTypeField.getRelevantConfig((IssueContext)new IssueContextImpl(projectId, null));
                OptionSet existingOptionSet = this.optionSetManager.getOptionsForConfig(relevantConfig);
                obseleteOptionIds.addAll(CollectionUtils.subtract((Collection)existingOptionSet.getOptionIds(), (Collection)targetOptionSet.getOptionIds()));
            }
            if (!obseleteOptionIds.isEmpty() && (affectedIssues = (searchResults = this.searchProvider.search(query = this.getQuery(affectedProjectIds, obseleteOptionIds), this.getLoggedInUser(), PagerFilter.getUnlimitedFilter())).getIssues()) != null && !affectedIssues.isEmpty()) {
                return this.migrateIssues(this, affectedIssues, targetOptionSet.getOptionIds());
            }
        }
        this.run();
        if (useRedirect) {
            return this.getRedirect(this.getConfigScheme());
        }
        return "NO_REDIRECT";
    }

    public void run() {
        FieldConfigScheme configScheme = this.getConfigScheme();
        List contexts = CustomFieldUtils.buildJiraIssueContexts((boolean)false, (Long[])this.getProjects(), (ProjectManager)this.projectManager);
        configScheme = this.configSchemeManager.updateFieldConfigScheme(configScheme, contexts, this.getConfigurableField());
        this.fieldManager.refresh();
    }

    public Collection<ProjectOption> getAllProjects() {
        return ProjectOption.transform(this.projectManager.getProjectObjects());
    }

    public Collection getOptions(FieldConfigScheme configScheme) {
        if (configScheme != null) {
            FieldConfig config = configScheme.getOneAndOnlyConfig();
            return this.optionSetManager.getOptionsForConfig(config).getOptions();
        }
        return Collections.emptyList();
    }

    public Long[] getProjects() {
        return this.projects;
    }

    public void setProjects(Long[] projects) {
        this.projects = projects;
    }

    public void setProjects(Collection<? extends WithId> projects) {
        this.projects = Lists.newArrayList((Iterable)WithFunctions.getIds(projects)).toArray(new Long[projects.size()]);
    }

    private Collection<Long> getChangedProjectIds() {
        List previousProjects = this.getConfigScheme().getAssociatedProjectObjects();
        ArrayList previousProjectIds = previousProjects != null && !previousProjects.isEmpty() ? Lists.newArrayList((Iterable)Iterables.transform((Iterable)previousProjects, (Function)WithFunctions.getId())) : Collections.emptyList();
        List<Object> newProjectIds = this.getProjects() != null && this.getProjects().length > 0 ? Arrays.asList(this.getProjects()) : Collections.emptyList();
        Collection affectedProjectIds = CollectionUtils.disjunction((Collection)previousProjectIds, newProjectIds);
        return affectedProjectIds;
    }
}

