/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuetypes;

import com.atlassian.jira.config.IssueTypeService;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.fields.option.IssueConstantOption;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.JiraArrayUtils;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.admin.issuetypes.AddIssueTypeAction;
import com.atlassian.jira.web.action.admin.issuetypes.ManageableOptionType;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;

@WebSudoRequired
public class AddNewIssueTypeToScheme
extends JiraWebActionSupport
implements AddIssueTypeAction {
    private static final String PARAM_SCHEME_NAME = "schemeName";
    private static final String PARAM_SCHEME_ID = "schemeId";
    private static final String PARAM_FIELD_ID = "fieldId";
    private static final String PARAM_PROJECT_ID = "projectId";
    private static final String PARAM_SCHEME_DESCRIPTION = "schemeDescription";
    private static final String PARAM_SELECTED_OPTIONS = "selectedOptions";
    private static final String PARAM_DEFAULT_OPTION = "defaultOption";
    private static final String PARAM_NAME = "name";
    private static final String PARAM_DESCRIPTION = "description";
    private final ManageableOptionType manageableOptionType;
    private final IssueTypeService issueTypeService;
    private String iconurl = "/images/icons/issuetypes/genericissue.png";
    private String style;
    private String name;
    private String description;
    private String fieldId;
    private Long schemeId;
    private Long projectId;
    private String schemeName;
    private String schemeDescription;
    private String[] selectedOptions;
    private String defaultOption;
    private IssueType newIssueType;

    public AddNewIssueTypeToScheme(ManageableOptionType manageableOptionType, IssueTypeService issueTypeService) {
        this.manageableOptionType = manageableOptionType;
        this.issueTypeService = issueTypeService;
    }

    @Override
    public String getIconurl() {
        return this.iconurl;
    }

    @Override
    public void setIconurl(String iconUrl) {
        this.iconurl = iconUrl;
    }

    @Override
    public String getStyle() {
        return this.style;
    }

    @Override
    public void setStyle(String style) {
        this.style = style;
    }

    @Override
    public String getSubmitUrl() {
        return "AddNewIssueTypeToScheme.jspa";
    }

    @Override
    public String getCancelUrl() {
        return this.createViewUrl(null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public String getFieldId() {
        return this.fieldId;
    }

    public void setFieldId(String fieldId) {
        this.fieldId = fieldId;
    }

    public Long getSchemeId() {
        return this.schemeId;
    }

    public void setSchemeId(Long schemeId) {
        this.schemeId = schemeId;
    }

    public String getDefaultOption() {
        return this.defaultOption;
    }

    public void setDefaultOption(String defaultOption) {
        this.defaultOption = defaultOption;
    }

    public String[] getSelectedOptions() {
        return this.selectedOptions;
    }

    public void setSelectedOptions(String[] selectedOptions) {
        this.selectedOptions = JiraArrayUtils.isContainsOneBlank(selectedOptions) ? new String[0] : selectedOptions;
    }

    public String getSchemeName() {
        return this.schemeName;
    }

    public void setSchemeName(String schemeName) {
        this.schemeName = schemeName;
    }

    public String getSchemeDescription() {
        return this.schemeDescription;
    }

    public void setSchemeDescription(String schemeDescription) {
        this.schemeDescription = schemeDescription;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public IssueConstantOption getNewIssueType() {
        return this.newIssueType == null ? null : new IssueConstantOption((IssueConstant)this.newIssueType);
    }

    @Override
    public List<Pair<String, Object>> getHiddenFields() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)Pair.nicePairOf((Object)PARAM_SCHEME_NAME, (Object)this.getSchemeName()));
        builder.add((Object)Pair.nicePairOf((Object)PARAM_SCHEME_DESCRIPTION, (Object)this.getSchemeDescription()));
        builder.add((Object)Pair.nicePairOf((Object)PARAM_SCHEME_ID, (Object)this.getSchemeId()));
        builder.add((Object)Pair.nicePairOf((Object)PARAM_PROJECT_ID, (Object)this.getProjectId()));
        builder.add((Object)Pair.nicePairOf((Object)PARAM_FIELD_ID, (Object)this.getFieldId()));
        builder.add((Object)Pair.nicePairOf((Object)PARAM_DEFAULT_OPTION, (Object)this.getDefaultOption()));
        String[] options = this.getSelectedOptions();
        if (options != null) {
            for (String s : options) {
                builder.add((Object)Pair.nicePairOf((Object)PARAM_SELECTED_OPTIONS, (Object)s));
            }
        }
        return builder.build();
    }

    @Override
    public ManageableOptionType getManageableOption() {
        return this.manageableOptionType;
    }

    public Collection<IssueConstantOption> getAllOptions() {
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)this.issueTypeService.getIssueTypes(this.getLoggedInUser()), (Function)new Function<IssueType, IssueConstantOption>(){

            public IssueConstantOption apply(IssueType issueType) {
                return new IssueConstantOption((IssueConstant)issueType);
            }
        }));
    }

    public String doInput() {
        return "input";
    }

    protected void doValidation() {
        IssueTypeService.IssueTypeCreateInput typeInput = this.getIssueTypeInput();
        IssueTypeService.CreateValidationResult validationResult = this.issueTypeService.validateCreateIssueType(this.getLoggedInUser(), typeInput);
        if (!validationResult.isValid()) {
            this.addErrorMessages(validationResult.getErrorCollection().getErrorMessages());
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws CreateException {
        IssueTypeService.IssueTypeCreateInput typeInput = this.getIssueTypeInput();
        IssueTypeService.CreateValidationResult validationResult = this.issueTypeService.validateCreateIssueType(this.getLoggedInUser(), typeInput);
        if (!validationResult.isValid()) {
            this.addErrors(validationResult.getErrorCollection().getErrors());
            return "error";
        }
        IssueTypeService.IssueTypeResult issueType = this.issueTypeService.createIssueType(this.getLoggedInUser(), validationResult);
        this.newIssueType = issueType.getIssueType();
        if (this.isInlineDialogMode()) {
            this.returnComplete();
            return "success";
        }
        return this.getRedirect(this.createViewUrl(issueType.getIssueType().getId()));
    }

    private String createViewUrl(String createdId) {
        UrlBuilder builder = new UrlBuilder("ConfigureOptionSchemes!input.jspa");
        builder.addParameter(PARAM_NAME, this.getSchemeName()).addParameter(PARAM_DESCRIPTION, this.getSchemeDescription());
        builder.addParameter(PARAM_SCHEME_ID, (Object)this.getSchemeId()).addParameter(PARAM_FIELD_ID, this.getFieldId());
        builder.addParameter(PARAM_PROJECT_ID, (Object)this.getProjectId());
        builder.addParameter(PARAM_DEFAULT_OPTION, this.getDefaultOption());
        String[] options = this.getSelectedOptions();
        if (options != null) {
            for (String selectedOption : options) {
                builder.addParameter(PARAM_SELECTED_OPTIONS, selectedOption);
            }
        }
        if (createdId != null) {
            builder.addParameter(PARAM_SELECTED_OPTIONS, createdId);
        }
        return builder.asUrlString();
    }

    private IssueTypeService.IssueTypeCreateInput getIssueTypeInput() {
        IssueTypeService.IssueTypeCreateInput.Type type = "jira_subtask".equals(this.style) ? IssueTypeService.IssueTypeCreateInput.Type.SUBTASK : IssueTypeService.IssueTypeCreateInput.Type.STANDARD;
        return IssueTypeService.IssueTypeCreateInput.builder().setName(this.getName()).setDescription(this.getDescription()).setType(type).build();
    }
}

