/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields.enterprise;

import com.atlassian.jira.issue.fields.layout.field.EditableFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutScheme;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.action.admin.issuefields.enterprise.FieldLayoutSchemeHelper;
import com.atlassian.query.Query;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InjectableComponent
public class FieldLayoutSchemeHelperImpl
implements FieldLayoutSchemeHelper {
    private static final Logger log = LoggerFactory.getLogger(FieldLayoutSchemeHelperImpl.class);
    private static final Function<Project, Long> PROJECT_TO_ID_FUNCTION = new Function<Project, Long>(){

        public Long get(Project input) {
            return input.getId();
        }
    };
    private final FieldLayoutManager fieldLayoutManager;
    private final SearchProvider searchProvider;

    public FieldLayoutSchemeHelperImpl(FieldLayoutManager fieldLayoutManager, SearchProvider searchProvider) {
        this.fieldLayoutManager = (FieldLayoutManager)Assertions.notNull((String)"fieldLayoutManager", (Object)fieldLayoutManager);
        this.searchProvider = (SearchProvider)Assertions.notNull((String)"searchProvider", (Object)searchProvider);
    }

    @Override
    public boolean doesChangingFieldLayoutAssociationRequireMessage(ApplicationUser user, FieldLayoutScheme fieldLayoutScheme, Long oldFieldLayoutId, Long newFieldLayoutId) {
        boolean messageRequired = false;
        if (!this.fieldLayoutManager.isFieldLayoutsVisiblyEquivalent(oldFieldLayoutId, newFieldLayoutId)) {
            messageRequired = this.doProjectsHaveIssues(user, fieldLayoutScheme.getProjectsUsing());
        }
        return messageRequired;
    }

    @Override
    public boolean doesChangingFieldLayoutRequireMessage(ApplicationUser user, EditableFieldLayout fieldLayout) {
        return this.doProjectsHaveIssues(user, this.fieldLayoutManager.getProjectsUsing((FieldLayout)fieldLayout));
    }

    @Override
    public boolean doesChangingFieldLayoutSchemeForProjectRequireMessage(ApplicationUser user, Long projectId, Long oldFieldLayoutSchemeId, Long newFieldLayoutSchemeId) {
        boolean messageRequired = false;
        if (!this.fieldLayoutManager.isFieldLayoutSchemesVisiblyEquivalent(oldFieldLayoutSchemeId, newFieldLayoutSchemeId)) {
            messageRequired = this.doProjectIdsHaveIssues(user, Collections.singletonList(projectId));
        }
        return messageRequired;
    }

    private boolean doProjectsHaveIssues(ApplicationUser user, Collection<Project> projects) {
        List projectIds = CollectionUtil.transform(projects, PROJECT_TO_ID_FUNCTION);
        return this.doProjectIdsHaveIssues(user, projectIds);
    }

    private boolean doProjectIdsHaveIssues(ApplicationUser user, Collection<Long> projectIds) {
        if (projectIds.isEmpty()) {
            return false;
        }
        JqlClauseBuilder builder = JqlQueryBuilder.newClauseBuilder().project().inNumbers(projectIds);
        return this.doesQueryHaveIssues(user, builder.buildQuery());
    }

    private boolean doesQueryHaveIssues(ApplicationUser user, Query query) {
        try {
            long issueCount = this.searchProvider.searchCountOverrideSecurity(query, user);
            return issueCount > 0L;
        }
        catch (SearchException e) {
            log.warn(e.getMessage(), (Throwable)e);
            return true;
        }
    }
}

