/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.config.ReindexMessageManager;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItemService;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.EditableDefaultFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.EditableFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.renderer.HackyFieldRendererRegistry;
import com.atlassian.jira.issue.fields.renderer.HackyRendererType;
import com.atlassian.jira.issue.fields.renderer.JiraRendererPlugin;
import com.atlassian.jira.issue.fields.renderer.RenderableField;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.web.action.admin.issuefields.AbstractConfigureFieldLayout;
import com.atlassian.jira.web.action.admin.issuefields.enterprise.FieldLayoutSchemeHelper;
import com.atlassian.query.Query;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@WebSudoRequired
public class EditFieldLayoutItemRenderer
extends AbstractConfigureFieldLayout {
    private EditableFieldLayout editableFieldLayout;
    private String selectedRendererType;
    private Integer rendererEdit;
    private Query query;
    private static final String FIELD_LAYOUT_SCHEME_ASSOCIATION = "FieldLayoutScheme";
    private SearchProvider searchProvider;
    private final SearchService searchService;

    public EditFieldLayoutItemRenderer(FieldScreenManager fieldScreenManager, RendererManager rendererManager, SearchProvider searchProvider, SearchService searchService, ReindexMessageManager reindexMessageManager, FieldManager fieldManager, FieldLayoutManager fieldLayoutManager, FieldLayoutSchemeHelper fieldLayoutSchemeHelper, HackyFieldRendererRegistry hackyFieldRendererRegistry, ManagedConfigurationItemService managedConfigurationItemService) {
        super(fieldScreenManager, rendererManager, reindexMessageManager, fieldLayoutSchemeHelper, fieldManager, fieldLayoutManager, hackyFieldRendererRegistry, managedConfigurationItemService);
        this.searchProvider = searchProvider;
        this.searchService = searchService;
    }

    protected void doValidation() {
        OrderableField field = this.getSelectedLayoutItem().getOrderableField();
        if (this.isFieldLocked((Field)this.getSelectedLayoutItem().getOrderableField())) {
            this.addErrorMessage(this.getText("admin.managed.configuration.items.customfield.error.cannot.alter.renderer.locked", field.getName()), ErrorCollection.Reason.FORBIDDEN);
            return;
        }
        if (this.hackyFieldRendererRegistry.shouldOverrideDefaultRenderers(field)) {
            if (HackyRendererType.fromKey((String)this.getSelectedRendererType()) == null) {
                this.addErrorMessage(this.getText("admin.errors.fieldlayout.cannot.add.renderer.type", this.getSelectedRendererType()));
            }
        } else {
            if (!(field instanceof RenderableField) || !((RenderableField)field).isRenderable()) {
                this.addErrorMessage(this.getText("admin.errors.fieldlayout.cannot.set.renderer", "'" + this.getText(field.getNameKey()) + "'"));
            }
            if (!this.getRendererManager().getRendererForType(this.getSelectedRendererType()).getRendererType().equals(this.getSelectedRendererType())) {
                this.addErrorMessage(this.getText("admin.errors.fieldlayout.cannot.add.renderer.type", this.getSelectedRendererType()));
            }
        }
    }

    public String doDefault() throws Exception {
        OrderableField orderableField = this.getSelectedLayoutItem().getOrderableField();
        if (this.isFieldLocked((Field)orderableField)) {
            this.addErrorMessage(this.getText("admin.managed.configuration.items.customfield.error.cannot.alter.renderer.locked", orderableField.getName()), ErrorCollection.Reason.FORBIDDEN);
            return "error";
        }
        return super.doDefault();
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        this.getFieldLayout().setRendererType(this.getSelectedLayoutItem(), this.getSelectedRendererType());
        this.store();
        return this.getFieldRedirect();
    }

    public boolean isSelectedFieldLocked() {
        return this.isFieldLocked((Field)this.getSelectedLayoutItem().getOrderableField());
    }

    public List<String> getAllActiveRenderers() {
        OrderableField field = this.getSelectedLayoutItem().getOrderableField();
        ArrayList<String> ret = new ArrayList<String>();
        if (this.hackyFieldRendererRegistry.shouldOverrideDefaultRenderers(field)) {
            Set rendererTypeSet = this.hackyFieldRendererRegistry.getRendererTypes(field);
            for (HackyRendererType rendererType : rendererTypeSet) {
                ret.add(rendererType.getKey());
            }
        } else {
            List rendererPlugins = this.getRendererManager().getAllActiveRenderers();
            for (JiraRendererPlugin rendererPlugin : rendererPlugins) {
                ret.add(rendererPlugin.getRendererType());
            }
        }
        return ret;
    }

    public String getFieldName() {
        return this.getSelectedLayoutItem().getOrderableField().getName();
    }

    public String getCancelUrl() {
        if (this.getId() != null) {
            return "ConfigureFieldLayout!default.jspa?id=" + this.getId();
        }
        return "ViewIssueFields.jspa";
    }

    public String getCurrentRendererType() {
        return this.getSelectedLayoutItem().getRendererType();
    }

    public String getSelectedRendererType() {
        return this.selectedRendererType;
    }

    public void setSelectedRendererType(String selectedRendererType) {
        this.selectedRendererType = selectedRendererType;
    }

    public Integer getRendererEdit() {
        return this.rendererEdit;
    }

    public void setRendererEdit(Integer rendererEdit) {
        this.rendererEdit = rendererEdit;
    }

    protected FieldLayoutItem getSelectedLayoutItem() {
        List fieldLayoutItems = this.getOrderedList();
        return (FieldLayoutItem)fieldLayoutItems.get(this.getRendererEdit());
    }

    @Override
    public EditableFieldLayout getFieldLayout() {
        if (this.editableFieldLayout == null) {
            try {
                this.editableFieldLayout = this.getId() == null ? this.getFieldLayoutManager().getEditableDefaultFieldLayout() : this.getFieldLayoutManager().getEditableFieldLayout(this.getId());
            }
            catch (DataAccessException e) {
                this.log.error((Object)"Error while retrieving field layout.", (Throwable)e);
                this.addErrorMessage(this.getText("view.issue.error.retrieving.field.layout"));
            }
        }
        return this.editableFieldLayout;
    }

    public long getEffectedIssuesCount() throws SearchException {
        long result = 0L;
        if (this.getEffectedIssuesQuery() != null) {
            result = this.searchProvider.searchCountOverrideSecurity(this.getEffectedIssuesQuery(), this.getLoggedInUser());
        }
        return result;
    }

    public String getEffectedIssuesQueryString() {
        Query effectedIssuesQuery = this.getEffectedIssuesQuery();
        if (effectedIssuesQuery != null) {
            return this.searchService.getIssueSearchPath(this.getLoggedInUser(), SearchService.IssueSearchParameters.builder().query(effectedIssuesQuery).build());
        }
        return "";
    }

    protected Query getEffectedIssuesQuery() {
        if (this.query == null) {
            ArrayList<Long> projectsIds = new ArrayList<Long>();
            for (Project project : this.getFieldLayoutManager().getProjectsUsing((FieldLayout)this.getFieldLayout())) {
                projectsIds.add(project.getId());
            }
            if (!projectsIds.isEmpty()) {
                this.query = JqlQueryBuilder.newBuilder().where().project().inNumbers(projectsIds).buildQuery();
            }
        }
        return this.query;
    }

    @Override
    protected String getFieldRedirect() throws Exception {
        return this.getRedirect(this.getCancelUrl());
    }

    @Override
    protected void store() {
        try {
            this.getFieldLayoutManager().storeEditableDefaultFieldLayout((EditableDefaultFieldLayout)this.getFieldLayout());
        }
        catch (DataAccessException e) {
            this.addErrorMessage(this.getText("admin.errors.fieldlayout.error.storing"));
        }
    }
}

