/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields;

import com.atlassian.jira.config.ReindexMessageManager;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItem;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItemService;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItemType;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.EditableFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.renderer.HackyFieldRendererRegistry;
import com.atlassian.jira.issue.fields.renderer.HackyRendererType;
import com.atlassian.jira.issue.fields.renderer.RenderableField;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.admin.issuefields.enterprise.FieldLayoutSchemeHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractConfigureFieldLayout
extends JiraWebActionSupport {
    private Long id;
    Integer hide;
    Integer require;
    private FieldScreenManager fieldScreenManager;
    private final FieldManager fieldManager;
    private final FieldLayoutManager fieldLayoutManager;
    protected final HackyFieldRendererRegistry hackyFieldRendererRegistry;
    private Map fieldScreenTabMap;
    private List orderedList;
    private RendererManager rendererManager;
    private final ReindexMessageManager reindexMessageManager;
    private final FieldLayoutSchemeHelper fieldLayoutSchemeHelper;
    private final ManagedConfigurationItemService managedConfigurationItemService;
    private Map<String, ManagedConfigurationItem> managedCustomFieldsMap;

    protected AbstractConfigureFieldLayout(FieldScreenManager fieldScreenManager, RendererManager rendererManager, ReindexMessageManager reindexMessageManager, FieldLayoutSchemeHelper fieldLayoutSchemeHelper, FieldManager fieldManager, FieldLayoutManager fieldLayoutManager, HackyFieldRendererRegistry hackyFieldRendererRegistry, ManagedConfigurationItemService managedConfigurationItemService) {
        this.fieldScreenManager = fieldScreenManager;
        this.fieldManager = fieldManager;
        this.fieldLayoutManager = fieldLayoutManager;
        this.hackyFieldRendererRegistry = hackyFieldRendererRegistry;
        this.managedConfigurationItemService = managedConfigurationItemService;
        this.fieldScreenTabMap = new HashMap();
        this.rendererManager = rendererManager;
        this.reindexMessageManager = (ReindexMessageManager)Assertions.notNull((String)"reindexMessageManager", (Object)reindexMessageManager);
        this.fieldLayoutSchemeHelper = (FieldLayoutSchemeHelper)Assertions.notNull((String)"fieldLayoutSchemeHelper", (Object)fieldLayoutSchemeHelper);
    }

    public abstract EditableFieldLayout getFieldLayout();

    public List getOrderedList() {
        if (this.orderedList == null) {
            this.orderedList = new ArrayList(this.getFieldLayout().getFieldLayoutItems());
            Collections.sort(this.orderedList);
        }
        return this.orderedList;
    }

    protected abstract String getFieldRedirect() throws Exception;

    @RequiresXsrfCheck
    public String doHide() throws Exception {
        this.doValidation();
        if (!this.invalidInput()) {
            List fieldLayoutItems = this.getOrderedList();
            FieldLayoutItem fieldLayoutItem = (FieldLayoutItem)fieldLayoutItems.get(this.getHide());
            if (this.isFieldLocked((Field)fieldLayoutItem.getOrderableField())) {
                this.addErrorMessage(this.getText("admin.managed.configuration.items.customfield.error.cannot.alter.configuration.locked", fieldLayoutItem.getOrderableField().getName()));
            } else if (fieldLayoutItem.isHidden()) {
                this.getFieldLayout().show(fieldLayoutItem);
                this.store();
            } else if (this.getFieldManager().isHideableField((Field)fieldLayoutItem.getOrderableField())) {
                this.getFieldLayout().hide(fieldLayoutItem);
                this.store();
            } else {
                this.addErrorMessage(this.getText("admin.errors.fieldlayout.cannot.hide.this.field", "'" + fieldLayoutItem.getOrderableField().getId() + "'"));
            }
            if (this.fieldLayoutSchemeHelper.doesChangingFieldLayoutRequireMessage(this.getLoggedInUser(), this.getFieldLayout())) {
                this.reindexMessageManager.pushMessage(this.getLoggedInUser(), "admin.notifications.task.field.configuration");
            }
        }
        return this.getFieldRedirect();
    }

    @RequiresXsrfCheck
    public String doRequire() throws Exception {
        this.doValidation();
        if (!this.invalidInput()) {
            List fieldLayoutItems = this.getOrderedList();
            FieldLayoutItem fieldLayoutItem = (FieldLayoutItem)fieldLayoutItems.get(this.getRequire());
            if (this.getFieldManager().isRequirableField((Field)fieldLayoutItem.getOrderableField())) {
                if (this.isFieldLocked((Field)fieldLayoutItem.getOrderableField())) {
                    this.addErrorMessage(this.getText("admin.managed.configuration.items.customfield.error.cannot.alter.configuration.locked", fieldLayoutItem.getOrderableField().getName()));
                } else {
                    if (fieldLayoutItem.isRequired()) {
                        this.getFieldLayout().makeOptional(fieldLayoutItem);
                    } else {
                        this.getFieldLayout().makeRequired(fieldLayoutItem);
                    }
                    this.store();
                }
            } else {
                this.addErrorMessage(this.getText("admin.errors.fieldlayout.cannot.make.this.field.optional", "'" + this.getText(fieldLayoutItem.getOrderableField().getNameKey()) + "'"));
            }
        }
        return this.getFieldRedirect();
    }

    protected abstract void store();

    public boolean isHideable(FieldLayoutItem fieldLayoutItem) {
        return this.fieldManager.isHideableField((Field)fieldLayoutItem.getOrderableField());
    }

    public boolean isRequirable(FieldLayoutItem fieldLayoutItem) {
        if (this.fieldManager.isRequirableField((Field)fieldLayoutItem.getOrderableField())) {
            return !fieldLayoutItem.isHidden();
        }
        return false;
    }

    public boolean isMandatory(FieldLayoutItem fieldLayoutItem) {
        return this.fieldManager.isMandatoryField((Field)fieldLayoutItem.getOrderableField());
    }

    public boolean isUnscreenable(FieldLayoutItem fieldLayoutItem) {
        return this.fieldManager.isUnscreenableField((Field)fieldLayoutItem.getOrderableField());
    }

    public Collection getFieldScreenTabs(OrderableField orderableField) {
        String fieldId = orderableField.getId();
        if (!this.fieldScreenTabMap.containsKey(fieldId)) {
            this.fieldScreenTabMap.put(fieldId, this.fieldScreenManager.getFieldScreenTabs(orderableField.getId()));
        }
        return (Collection)this.fieldScreenTabMap.get(fieldId);
    }

    public boolean isCustomField(FieldLayoutItem fieldLayoutItem) {
        return this.fieldManager.isCustomField((Field)fieldLayoutItem.getOrderableField());
    }

    public boolean isHasDefaultFieldLayout() {
        try {
            return this.getFieldLayoutManager().hasDefaultFieldLayout();
        }
        catch (DataAccessException e) {
            this.log.error((Object)"Error determining whether the default layout is used.", (Throwable)e);
            this.addErrorMessage(this.getText("admin.errors.fieldlayout.error.determining.if.default.used"));
            return false;
        }
    }

    public String doRestoreDefaults() throws Exception {
        try {
            this.getFieldLayoutManager().restoreDefaultFieldLayout();
        }
        catch (DataAccessException e) {
            this.log.error((Object)"Error while restroring default field layout.", (Throwable)e);
            this.addErrorMessage(this.getText("admin.errors.fieldlayout.error.restoring.default"));
        }
        return this.getFieldRedirect();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getHide() {
        return this.hide;
    }

    public void setHide(Integer hide) {
        this.hide = hide;
    }

    public Integer getRequire() {
        return this.require;
    }

    public void setRequire(Integer require) {
        this.require = require;
    }

    public String getFieldName(Field field) {
        if (this.getFieldManager().isCustomField(field)) {
            CustomField customField = this.fieldManager.getCustomField(field.getId());
            return customField.getName();
        }
        return this.getText(field.getNameKey());
    }

    public RendererManager getRendererManager() {
        return this.rendererManager;
    }

    public String getRendererDisplayName(String rendererType) {
        HackyRendererType hackyRendererType = HackyRendererType.fromKey((String)rendererType);
        if (hackyRendererType != null) {
            return this.getText(hackyRendererType.getDisplayNameI18nKey());
        }
        return this.rendererManager.getRendererForType(rendererType).getDescriptor().getName();
    }

    protected FieldManager getFieldManager() {
        return this.fieldManager;
    }

    protected FieldLayoutManager getFieldLayoutManager() {
        return this.fieldLayoutManager;
    }

    public boolean isRenderable(OrderableField field) {
        if (field instanceof RenderableField) {
            RenderableField renderableField = (RenderableField)field;
            boolean isRenderable = renderableField.isRenderable();
            if (!isRenderable && field instanceof CustomField) {
                return this.hackyFieldRendererRegistry.shouldOverrideDefaultRenderers(field);
            }
            return isRenderable;
        }
        return this.hackyFieldRendererRegistry.shouldOverrideDefaultRenderers(field);
    }

    public boolean isFieldManaged(Field field) {
        ManagedConfigurationItem managedConfigurationItem = this.getManagedCustomFieldsMap().get(field.getId());
        if (managedConfigurationItem == null) {
            return false;
        }
        return managedConfigurationItem.isManaged();
    }

    public boolean isFieldLocked(Field field) {
        ManagedConfigurationItem managedConfigurationItem = this.getManagedCustomFieldsMap().get(field.getId());
        if (managedConfigurationItem == null) {
            return false;
        }
        return !this.managedConfigurationItemService.doesUserHavePermission(this.getLoggedInUser(), managedConfigurationItem);
    }

    public String getManagedFieldDescriptionKey(Field field) {
        ManagedConfigurationItem managedConfigurationItem = this.getManagedCustomFieldsMap().get(field.getId());
        if (managedConfigurationItem != null) {
            return managedConfigurationItem.getDescriptionI18nKey();
        }
        return "";
    }

    private Map<String, ManagedConfigurationItem> getManagedCustomFieldsMap() {
        if (this.managedCustomFieldsMap == null) {
            this.managedCustomFieldsMap = new LinkedHashMap<String, ManagedConfigurationItem>();
            Collection managedConfigurationItems = this.managedConfigurationItemService.getManagedConfigurationItems(ManagedConfigurationItemType.CUSTOM_FIELD);
            for (ManagedConfigurationItem managedConfigurationItem : managedConfigurationItems) {
                this.managedCustomFieldsMap.put(managedConfigurationItem.getItemId(), managedConfigurationItem);
            }
        }
        return this.managedCustomFieldsMap;
    }
}

