/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.index;

import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.BackgroundIndexTaskContext;
import com.atlassian.jira.config.ForegroundIndexTaskContext;
import com.atlassian.jira.config.IndexTask;
import com.atlassian.jira.config.IndexTaskContext;
import com.atlassian.jira.config.util.IndexPathManager;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.index.ha.IndexRecoveryService;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.task.AlreadyExecutingException;
import com.atlassian.jira.task.TaskContext;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.task.TaskMatcher;
import com.atlassian.jira.util.FileFactory;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.PathUtils;
import com.atlassian.jira.util.index.IndexLifecycleManager;
import com.atlassian.jira.util.johnson.JohnsonProvider;
import com.atlassian.jira.web.action.ProjectActionSupport;
import com.atlassian.jira.web.action.admin.index.ActivateAsyncIndexerCommand;
import com.atlassian.jira.web.action.admin.index.IndexAdmin;
import com.atlassian.jira.web.action.admin.index.IndexCommandResult;
import com.atlassian.jira.web.action.admin.index.IndexRecoveryCommand;
import com.atlassian.jira.web.action.admin.index.ReIndexAsyncIndexerCommand;
import com.atlassian.jira.web.action.admin.index.ReIndexBackgroundIndexerCommand;
import com.atlassian.jira.web.bean.TaskDescriptorBean;
import com.atlassian.jira.web.component.cron.CronEditorBean;
import com.atlassian.jira.web.component.cron.generator.CronExpressionDescriptor;
import com.atlassian.jira.web.component.cron.parser.CronExpressionParser;
import com.atlassian.jira.web.util.OutlookDateManager;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import org.apache.commons.lang.StringUtils;

@WebSudoRequired
public class IndexAdminImpl
extends ProjectActionSupport
implements IndexAdmin {
    private static final String PROGRESS = "progress";
    private final IndexLifecycleManager indexLifecycleManager;
    private final GlobalPermissionManager globalPermissionManager;
    private final TaskManager taskManager;
    private final JiraAuthenticationContext authenticationContext;
    private final FileFactory fileFactory;
    private final IndexRecoveryService indexRecoveryService;
    private final ClusterManager clusterManager;
    private final JiraHome jiraHome;
    private final I18nHelper.BeanFactory i18nBeanFactory;
    private final TaskDescriptorBean.Factory taskBeanFactory;
    private final IndexPathManager indexPathManager;
    private final JohnsonProvider johnsonProvider;
    private Long taskId;
    private TaskDescriptorBean<IndexCommandResult> currentTask;
    private long reindexTime;
    private String indexPath;
    private TaskDescriptor<IndexCommandResult> currentTaskDescriptor;
    private IndexPathManager.Mode indexMode;
    private String indexingStrategy;
    private Boolean indexConsistent;
    private TaskDescriptor<?> taskInProgress;
    private String recoveryFilename;
    private String copyFromNodeId;
    private boolean copyRequested;

    @Deprecated
    public IndexAdminImpl(IndexLifecycleManager indexLifecycleManager, GlobalPermissionManager globalPermissionManager, TaskManager taskManager, JiraAuthenticationContext authenticationContext, OutlookDateManager outlookDateManager, IndexPathManager indexPathManager, FileFactory fileFactory) {
        this(ComponentAccessor.getProjectManager(), ComponentAccessor.getPermissionManager(), indexLifecycleManager, globalPermissionManager, taskManager, authenticationContext, (TaskDescriptorBean.Factory)ComponentAccessor.getComponent(TaskDescriptorBean.Factory.class), indexPathManager, fileFactory, (IndexRecoveryService)ComponentAccessor.getComponent(IndexRecoveryService.class), (ClusterManager)ComponentAccessor.getComponent(ClusterManager.class), (JiraHome)ComponentAccessor.getComponent(JiraHome.class), ComponentAccessor.getI18nHelperFactory(), (JohnsonProvider)ComponentAccessor.getComponent(JohnsonProvider.class));
    }

    public IndexAdminImpl(ProjectManager projectManager, PermissionManager permissionManager, IndexLifecycleManager indexLifecycleManager, GlobalPermissionManager globalPermissionManager, TaskManager taskManager, JiraAuthenticationContext authenticationContext, TaskDescriptorBean.Factory factory, IndexPathManager indexPathManager, FileFactory fileFactory, IndexRecoveryService indexRecoveryService, ClusterManager clusterManager, JiraHome jiraHome, I18nHelper.BeanFactory i18nBeanFactory, JohnsonProvider johnsonProvider) {
        super(projectManager, permissionManager);
        this.indexLifecycleManager = indexLifecycleManager;
        this.globalPermissionManager = globalPermissionManager;
        this.taskManager = taskManager;
        this.authenticationContext = authenticationContext;
        this.taskBeanFactory = factory;
        this.indexPathManager = indexPathManager;
        this.fileFactory = fileFactory;
        this.clusterManager = clusterManager;
        this.jiraHome = jiraHome;
        this.i18nBeanFactory = i18nBeanFactory;
        this.johnsonProvider = johnsonProvider;
        this.indexMode = indexPathManager.getMode();
        this.indexPath = indexPathManager.getIndexRootPath();
        this.indexRecoveryService = indexRecoveryService;
    }

    public String getIndexPathOption() {
        return this.indexMode.toString();
    }

    public void setIndexPathOption(String indexPathOption) {
        this.indexMode = IndexPathManager.Mode.valueOf((String)indexPathOption);
    }

    public String getDefaultIndexPath() {
        return this.indexPathManager.getDefaultIndexRootPath();
    }

    public boolean getShowCustom() {
        return this.indexMode == IndexPathManager.Mode.CUSTOM || this.indexMode == IndexPathManager.Mode.DISABLED && this.indexPath != null;
    }

    @Override
    public String getIndexPath() {
        return this.indexPath;
    }

    private void validateIndexPath(String path) {
        if (StringUtils.isBlank((String)path)) {
            this.addError("indexPath", this.getText("admin.errors.you.must.specify.a.path"));
        } else {
            File actualPath = this.fileFactory.getFile(path);
            if (!actualPath.isAbsolute()) {
                this.addError("indexPath", this.getText("setup.error.filepath.notabsolute"));
            } else {
                if (!actualPath.exists()) {
                    actualPath.mkdirs();
                }
                if (!actualPath.exists() || !actualPath.isDirectory()) {
                    this.addError("indexPath", this.getText("admin.errors.path.entered.does.not.exist"));
                } else if (!actualPath.canRead() || !actualPath.canWrite()) {
                    this.addError("indexPath", this.getText("admin.errors.path.entered.is.not.readable"));
                }
            }
        }
    }

    protected String doExecute() throws Exception {
        TaskDescriptor<IndexCommandResult> taskDescriptor = this.getCurrentTaskDescriptor();
        if (taskDescriptor != null) {
            return this.getRedirect(taskDescriptor.getProgressURL());
        }
        return "success";
    }

    @Override
    @RequiresXsrfCheck
    public String doActivate() throws Exception {
        if (!this.isHasSystemAdminPermission()) {
            this.addErrorMessage(this.getText("admin.errors.no.perm.to.activate"));
            return "error";
        }
        if (this.indexMode == IndexPathManager.Mode.DISABLED) {
            this.addErrorMessage(this.getText("admin.errors.you.must.specify.a.path"));
            return "error";
        }
        JohnsonEventContainer eventCont = null;
        eventCont = this.johnsonProvider.getContainer();
        if (!this.isIndexing()) {
            if (this.indexMode == IndexPathManager.Mode.CUSTOM) {
                this.validateIndexPath(this.indexPath);
            }
            if (!this.invalidInput()) {
                this.updateIndexPathManager();
                ActivateAsyncIndexerCommand activateCommand = new ActivateAsyncIndexerCommand(false, eventCont, this.indexLifecycleManager, this.log, this.authenticationContext.getI18nHelper(), this.i18nBeanFactory);
                String taskName = this.getText("admin.indexing.jira.indexing");
                try {
                    TaskDescriptor<IndexCommandResult> taskDescriptor = this.taskManager.submitTask(activateCommand, taskName, new ForegroundIndexTaskContext());
                    return this.getRedirect(taskDescriptor.getProgressURL());
                }
                catch (AlreadyExecutingException e) {
                    return this.getRedirect(e.getTaskDescriptor().getProgressURL());
                }
                catch (RejectedExecutionException e) {
                    this.addErrorMessage(this.getText("common.tasks.rejected.execution.exception", e.getMessage()));
                    return "error";
                }
            }
            return "error";
        }
        return this.getRedirect(this.getRedirectUrl());
    }

    private boolean isCustomPathChanged() {
        return this.indexMode == IndexPathManager.Mode.CUSTOM && !this.indexPath.equals(this.indexPathManager.getIndexRootPath());
    }

    private boolean isModeChanged() {
        return this.indexMode != this.indexPathManager.getMode();
    }

    @Override
    @RequiresXsrfCheck
    public String doReindex() throws Exception {
        JohnsonEventContainer eventCont = null;
        if (this.isIndexing()) {
            eventCont = this.johnsonProvider.getContainer();
            if (!this.runInBackground() && this.isTaskInProgress()) {
                this.addErrorMessage(this.getCannotReindexInForegroundMessage());
                return "error";
            }
            ActivateAsyncIndexerCommand indexCallable = this.createDefaultReindexCommand(eventCont);
            if (this.isHasSystemAdminPermission()) {
                if (this.isCustomPathChanged()) {
                    this.validateIndexPath(this.indexPath);
                    if (this.invalidInput()) {
                        return "error";
                    }
                }
                if (this.isCustomPathChanged() || this.isModeChanged()) {
                    this.updateIndexPathManager();
                    indexCallable = new ActivateAsyncIndexerCommand(true, eventCont, this.indexLifecycleManager, this.log, this.authenticationContext.getI18nHelper(), this.i18nBeanFactory);
                }
            }
            String taskName = this.getText("admin.indexing.jira.indexing");
            try {
                if (this.runInBackground() && !this.indexLifecycleManager.isIndexConsistent()) {
                    return "error";
                }
                IndexTaskContext context = this.runInBackground() ? new BackgroundIndexTaskContext() : new ForegroundIndexTaskContext();
                return this.getRedirect(this.taskManager.submitTask(indexCallable, taskName, context, this.runInBackground()).getProgressURL());
            }
            catch (AlreadyExecutingException e) {
                return this.getRedirect(e.getTaskDescriptor().getProgressURL());
            }
            catch (RejectedExecutionException e) {
                this.addErrorMessage(this.getText("common.tasks.rejected.execution.exception", e.getMessage()));
                return "error";
            }
        }
        return this.getRedirect(this.getRedirectUrl());
    }

    private Callable<IndexCommandResult> createDefaultReindexCommand(JohnsonEventContainer eventCont) {
        if (this.runInBackground()) {
            return new ReIndexBackgroundIndexerCommand(this.indexLifecycleManager, this.log, this.authenticationContext.getI18nHelper(), this.i18nBeanFactory);
        }
        return new ReIndexAsyncIndexerCommand(eventCont, this.indexLifecycleManager, this.log, this.authenticationContext.getI18nHelper(), this.i18nBeanFactory);
    }

    private Callable<IndexCommandResult> createIndexRecoveryCommand(String fileName) {
        return new IndexRecoveryCommand(this.getLoggedInUser(), this.indexRecoveryService, this.log, this.authenticationContext.getI18nHelper(), fileName);
    }

    private boolean runInBackground() {
        return "background".equals(this.indexingStrategy);
    }

    private void updateIndexPathManager() {
        if (this.indexMode == IndexPathManager.Mode.DEFAULT) {
            this.indexPathManager.setUseDefaultDirectory();
        } else if (this.indexMode == IndexPathManager.Mode.CUSTOM) {
            this.indexPathManager.setIndexRootPath(this.indexPath);
        }
    }

    public String doProgress() throws ExecutionException, InterruptedException {
        if (this.taskId == null) {
            this.addErrorMessage(this.getText("admin.indexing.no.task.id"));
            return "error";
        }
        this.currentTaskDescriptor = this.taskManager.getTask(this.taskId);
        if (this.currentTaskDescriptor == null) {
            this.addErrorMessage(this.getText("admin.indexing.no.task.found"));
            return "error";
        }
        TaskContext context = this.currentTaskDescriptor.getTaskContext();
        if (!(context instanceof IndexTaskContext)) {
            this.addErrorMessage(this.getText("common.tasks.wrong.task.context", IndexTaskContext.class.getName(), context.getClass().getName()));
            return "error";
        }
        this.currentTask = this.taskBeanFactory.create(this.currentTaskDescriptor);
        if (this.currentTaskDescriptor.isFinished() && !this.taskManager.isCancelled(this.taskId)) {
            IndexCommandResult result = this.currentTaskDescriptor.getResult();
            if (result != null) {
                if (result.isSuccessful()) {
                    this.reindexTime = result.getReindexTime();
                } else {
                    this.addErrorCollection(result.getErrorCollection());
                }
            } else {
                this.addErrorMessage(this.getText("admin.indexing.failed"));
            }
        }
        return PROGRESS;
    }

    @RequiresXsrfCheck
    public String doCancel() throws ExecutionException, InterruptedException {
        if (this.taskId == null) {
            this.addErrorMessage(this.getText("admin.indexing.no.task.id"));
            return "error";
        }
        this.currentTaskDescriptor = this.taskManager.getTask(this.taskId);
        if (this.currentTaskDescriptor == null) {
            this.addErrorMessage(this.getText("admin.indexing.no.task.found"));
            return "error";
        }
        TaskContext context = this.currentTaskDescriptor.getTaskContext();
        if (!(context instanceof IndexTaskContext)) {
            this.addErrorMessage(this.getText("common.tasks.wrong.task.context", IndexTaskContext.class.getName(), context.getClass().getName()));
            return "error";
        }
        this.taskManager.cancelTask(this.taskId);
        this.currentTaskDescriptor = this.taskManager.getTask(this.taskId);
        this.currentTask = this.taskBeanFactory.create(this.currentTaskDescriptor);
        return "success";
    }

    @RequiresXsrfCheck
    public String doRecover() throws Exception {
        if (this.isIndexing()) {
            if (!this.isHasSystemAdminPermission()) {
                this.addErrorMessage(this.getText("admin.errors.index.recovery.unauthorised"));
                return "error";
            }
            if (this.isTaskInProgress()) {
                this.addErrorMessage(this.getCannotReindexInForegroundMessage());
                return "error";
            }
            String filePath = this.getRecoveryFilePath();
            this.validateRecoveryFile(filePath);
            if (this.invalidInput()) {
                return "error";
            }
            Callable<IndexCommandResult> indexCallable = this.createIndexRecoveryCommand(filePath);
            String taskName = this.getText("admin.indexing.jira.indexing");
            try {
                ForegroundIndexTaskContext context = new ForegroundIndexTaskContext();
                return this.getRedirect(this.taskManager.submitTask(indexCallable, taskName, context, this.runInBackground()).getProgressURL());
            }
            catch (AlreadyExecutingException e) {
                return this.getRedirect(e.getTaskDescriptor().getProgressURL());
            }
            catch (RejectedExecutionException e) {
                this.addErrorMessage(this.getText("common.tasks.rejected.execution.exception", e.getMessage()));
                return "error";
            }
        }
        return this.getRedirect(this.getRedirectUrl());
    }

    private void validateRecoveryFile(String path) {
        if (StringUtils.isBlank((String)path)) {
            this.addError("recoveryFilename", this.getText("admin.index.recovery.file.error.not.specified"));
        } else {
            File actualFile = this.fileFactory.getFile(path);
            if (!actualFile.exists()) {
                this.addError("recoveryFilename", this.getText("admin.index.recovery.file.error.not.found"));
            }
            if (actualFile.exists() && actualFile.isDirectory()) {
                this.addError("recoveryFilename", this.getText("admin.index.recovery.file.error.not.zip"));
            } else if (!actualFile.canRead()) {
                this.addError("indexPath", this.getText("admin.errors.path.entered.is.not.readable"));
            } else if (!this.indexRecoveryService.validIndexZipFile(this.getLoggedInUser(), actualFile)) {
                this.addError("recoveryFilename", this.getText("admin.index.recovery.file.error.not.zip"));
            }
        }
    }

    @RequiresXsrfCheck
    public String doCopy() throws Exception {
        if (this.isIndexing()) {
            if (!this.isHasSystemAdminPermission()) {
                this.addErrorMessage(this.getText("admin.errors.index.copy.unauthorised"));
                return "error";
            }
            if (this.isTaskInProgress()) {
                this.addErrorMessage(this.getCannotReindexInForegroundMessage());
                return "error";
            }
            this.validateCopyParams();
            if (this.invalidInput()) {
                return "error";
            }
            this.clusterManager.requestCurrentIndexFromNode(this.copyFromNodeId);
            this.copyRequested = true;
        }
        return "success";
    }

    private void validateCopyParams() {
        if (StringUtils.isBlank((String)this.copyFromNodeId)) {
            this.addError("copyFromNodeId", this.getText("admin.errors.index.copy.from.not.specified"));
        }
        if (this.invalidInput()) {
            return;
        }
        if (this.copyFromNodeId.equals(this.clusterManager.getNodeId())) {
            this.addError("copyFromNodeId", this.getText("admin.errors.index.copy.to.from.same"));
        }
    }

    private String getRedirectUrl() {
        return "IndexAdmin.jspa";
    }

    @Override
    public long getReindexTime() {
        return this.reindexTime;
    }

    public void setReindexTime(long reindexTime) {
        this.reindexTime = reindexTime;
    }

    public boolean isAnyLiveTasks() {
        return !this.taskManager.getLiveTasks().isEmpty();
    }

    public boolean isHasSystemAdminPermission() {
        return this.globalPermissionManager.hasPermission(44, this.getLoggedInUser());
    }

    public Long getTaskId() {
        return this.taskId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public TaskDescriptorBean<IndexCommandResult> getOurTask() {
        return this.currentTask;
    }

    public TaskDescriptorBean<IndexCommandResult> getCurrentTask() {
        TaskDescriptor<IndexCommandResult> taskDescriptor;
        if (this.currentTask == null && (taskDescriptor = this.getCurrentTaskDescriptor()) != null) {
            this.currentTask = this.taskBeanFactory.create(taskDescriptor);
        }
        return this.currentTask;
    }

    public String getIndexingStrategy() {
        return this.indexingStrategy;
    }

    public void setIndexingStrategy(String indexingStrategy) {
        this.indexingStrategy = indexingStrategy;
    }

    public boolean isIndexConsistent() {
        if (this.indexConsistent == null) {
            this.indexConsistent = this.indexLifecycleManager.isIndexConsistent();
        }
        return this.indexConsistent;
    }

    private boolean isReindexInProgress() {
        return false;
    }

    private TaskDescriptor<IndexCommandResult> getCurrentTaskDescriptor() {
        if (this.currentTaskDescriptor == null) {
            this.currentTaskDescriptor = this.taskManager.getLiveTask(new IndexTaskContext());
        }
        return this.currentTaskDescriptor;
    }

    public String getDestinationURL() {
        return "/secure/admin/jira/IndexAdmin.jspa?reindexTime=" + this.reindexTime;
    }

    public boolean isTaskInProgress() {
        if (this.taskInProgress == null) {
            this.taskInProgress = this.taskManager.findFirstTask(new TaskMatcher(){

                @Override
                public boolean match(TaskDescriptor<?> descriptor) {
                    return !descriptor.isFinished() && descriptor.getTaskContext() instanceof IndexTask;
                }
            });
        }
        return this.taskInProgress != null;
    }

    public String getCannotReindexInForegroundMessage() {
        return this.getText("admin.indexing.strategy.foreground.other.task.in.progress");
    }

    public String getRecoveryFilename() {
        return this.recoveryFilename;
    }

    public void setRecoveryFilename(String recoveryFilename) {
        this.recoveryFilename = recoveryFilename;
    }

    public String getRecoveryFilePath() {
        if (StringUtils.isEmpty((String)this.recoveryFilename) || new File(this.recoveryFilename).isAbsolute()) {
            return this.recoveryFilename;
        }
        return PathUtils.appendFileSeparator((String)this.getSnapshotDirectory()) + this.recoveryFilename;
    }

    public String getSnapshotCronExpression() {
        String cronExpression = this.indexRecoveryService.getSnapshotCronExpression(this.getLoggedInUser());
        if (cronExpression != null) {
            return this.getPrettyCron(cronExpression);
        }
        return "";
    }

    public String getPrettyCron(String cronExpression) {
        CronExpressionParser cronExpresionParser = new CronExpressionParser(cronExpression);
        if (cronExpresionParser.isValidForEditor()) {
            CronEditorBean cronEditorBean = cronExpresionParser.getCronEditorBean();
            return new CronExpressionDescriptor(this.getI18nHelper()).getPrettySchedule(cronEditorBean);
        }
        return cronExpression;
    }

    public String getSnapshotDirectory() {
        return new File(this.jiraHome.getExportDirectory(), "indexsnapshots").getAbsolutePath();
    }

    public boolean recoveryEnabled() {
        return this.indexRecoveryService.isRecoveryEnabled(this.getLoggedInUser());
    }

    public String getCopyFromNodeId() {
        return this.copyFromNodeId;
    }

    public void setCopyFromNodeId(String copyFromNodeId) {
        this.copyFromNodeId = copyFromNodeId;
    }

    public Collection<Node> getNodeList() {
        return Lists.newArrayList((Iterable)Iterables.filter(this.clusterManager.findLiveNodes(), (Predicate)new Predicate<Node>(){
            String nodeId;
            {
                this.nodeId = IndexAdminImpl.this.clusterManager.getNodeId();
            }

            public boolean apply(Node input) {
                return !input.getNodeId().equals(this.nodeId);
            }
        }));
    }

    public boolean isClustered() {
        return this.clusterManager.isClustered();
    }

    public String getCurrentNodeId() {
        return this.clusterManager.getNodeId();
    }

    public boolean isCopyRequested() {
        return this.copyRequested;
    }
}

