/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.customfields;

import com.atlassian.jira.entity.WithFunctions;
import com.atlassian.jira.issue.IssueConstants;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.action.admin.customfields.CustomFieldContextConfigHelper;
import com.atlassian.query.Query;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InjectableComponent
public class CustomFieldContextConfigHelperImpl
implements CustomFieldContextConfigHelper {
    private static final Logger log = LoggerFactory.getLogger(CustomFieldContextConfigHelperImpl.class);
    private final SearchProvider searchProvider;
    private final FieldConfigSchemeManager fieldConfigSchemeManager;

    public CustomFieldContextConfigHelperImpl(SearchProvider searchProvider, FieldConfigSchemeManager fieldConfigSchemeManager) {
        this.searchProvider = (SearchProvider)Assertions.notNull((String)"searchProvider", (Object)searchProvider);
        this.fieldConfigSchemeManager = (FieldConfigSchemeManager)Assertions.notNull((String)"fieldConfigSchemeManager", (Object)fieldConfigSchemeManager);
    }

    @Override
    public boolean doesAddingContextToCustomFieldAffectIssues(ApplicationUser user, CustomField customField, List<JiraContextNode> projectContexts, List<IssueType> issueTypes, boolean isNewCustomField) {
        if (!isNewCustomField && this.doesCustomFieldHaveGlobalScheme(customField)) {
            return false;
        }
        return this.doesContextHaveIssues(user, projectContexts, issueTypes);
    }

    @Override
    public boolean doesChangingContextAffectIssues(ApplicationUser user, CustomField customField, FieldConfigScheme oldFieldConfigScheme, boolean isNewSchemeGlobal, List<JiraContextNode> projectContexts, List<IssueType> issueTypes) {
        boolean isOldSchemeGlobal = oldFieldConfigScheme.isGlobal();
        if (!isOldSchemeGlobal && !isNewSchemeGlobal) {
            if (this.doesCustomFieldHaveGlobalScheme(customField)) {
                return false;
            }
            if (this.doesContextHaveIssues(user, projectContexts, issueTypes)) {
                return true;
            }
            return this.doesFieldConfigSchemeHaveIssues(user, oldFieldConfigScheme);
        }
        return this.doesGlobalContextHaveIssues(user);
    }

    @Override
    public boolean doesRemovingSchemeFromCustomFieldAffectIssues(ApplicationUser user, CustomField customField, FieldConfigScheme fieldConfigScheme) {
        if (fieldConfigScheme.isGlobal()) {
            List<FieldConfigScheme> nonGlobalSchemes = this.getNonGlobalSchemesForCustomField(customField);
            if (nonGlobalSchemes.isEmpty()) {
                return this.doesGlobalContextHaveIssues(user);
            }
            JqlClauseBuilder clauseBuilder = JqlQueryBuilder.newClauseBuilder().defaultAnd();
            for (FieldConfigScheme scheme : nonGlobalSchemes) {
                List projects = scheme.getAssociatedProjectObjects();
                projects = projects == null ? Collections.emptyList() : Collections.unmodifiableList(projects);
                Collection issueTypes = scheme.getAssociatedIssueTypes();
                ArrayList projectIds = Lists.newArrayList((Iterable)Iterables.filter((Iterable)WithFunctions.getIds(projects), (Predicate)Predicates.notNull()));
                List<Long> issueTypeIds = this.filterAndTransformIssueTypes(issueTypes == null ? Collections.emptySet() : Sets.newHashSet((Iterable)issueTypes));
                clauseBuilder.not().addClause(this.buildClause(projectIds, issueTypeIds).buildClause());
            }
            return this.doesQueryHaveIssues(user, clauseBuilder.buildQuery());
        }
        if (this.doesCustomFieldHaveGlobalScheme(customField)) {
            return false;
        }
        return this.doesFieldConfigSchemeHaveIssues(user, fieldConfigScheme);
    }

    boolean doesContextHaveIssues(ApplicationUser user, List<JiraContextNode> projectContexts, List<IssueType> issueTypes) {
        ArrayList projectIds = Lists.newArrayList();
        for (JiraContextNode context : projectContexts) {
            if (context == null || context.getProjectId() == null) continue;
            projectIds.add(context.getProjectId());
        }
        ArrayList<Long> issueTypeIds = new ArrayList();
        if (issueTypes != null) {
            issueTypeIds = this.filterAndTransformIssueTypes(issueTypes);
        }
        return this._doesContextHaveIssues(user, projectIds, issueTypeIds);
    }

    boolean doesContextHaveIssues(ApplicationUser user, List<Project> projects, Set<IssueType> issueTypes) {
        List<Object> projectIds = projects == null ? Collections.emptyList() : projects;
        ArrayList<Long> issueTypeIds = new ArrayList();
        if (issueTypes != null) {
            issueTypeIds = this.filterAndTransformIssueTypes(issueTypes);
        }
        return this._doesContextHaveIssues(user, (List<Long>)ImmutableList.copyOf((Iterable)WithFunctions.getIds(projectIds)), issueTypeIds);
    }

    boolean doesGlobalContextHaveIssues(ApplicationUser user) {
        return this._doesContextHaveIssues(user, Collections.emptyList(), Collections.emptyList());
    }

    boolean _doesContextHaveIssues(ApplicationUser user, List<Long> projectIds, List<Long> issueTypeIds) {
        JqlClauseBuilder clauseBuilder = this.buildClause(projectIds, issueTypeIds);
        return this.doesQueryHaveIssues(user, clauseBuilder.buildQuery());
    }

    boolean doesFieldConfigSchemeHaveIssues(ApplicationUser user, FieldConfigScheme fieldConfigScheme) {
        List<Project> projects = fieldConfigScheme.getAssociatedProjectObjects();
        projects = projects == null ? Collections.emptyList() : Collections.unmodifiableList(projects);
        Collection issueTypes = fieldConfigScheme.getAssociatedIssueTypes();
        return this.doesContextHaveIssues(user, projects, issueTypes == null ? Collections.emptySet() : Sets.newHashSet((Iterable)issueTypes));
    }

    private boolean doesCustomFieldHaveGlobalScheme(CustomField customField) {
        List schemes = this.fieldConfigSchemeManager.getConfigSchemesForField((ConfigurableField)customField);
        for (FieldConfigScheme scheme : schemes) {
            if (!scheme.isGlobal()) continue;
            return true;
        }
        return false;
    }

    private List<FieldConfigScheme> getNonGlobalSchemesForCustomField(CustomField customField) {
        List schemes = this.fieldConfigSchemeManager.getConfigSchemesForField((ConfigurableField)customField);
        ArrayList<FieldConfigScheme> result = new ArrayList<FieldConfigScheme>();
        for (FieldConfigScheme scheme : schemes) {
            if (scheme.isGlobal()) continue;
            result.add(scheme);
        }
        return result;
    }

    private JqlClauseBuilder buildClause(List<Long> projectIds, List<Long> issueTypeIds) {
        JqlClauseBuilder clauseBuilder = JqlQueryBuilder.newClauseBuilder().defaultAnd();
        if (!projectIds.isEmpty()) {
            clauseBuilder.project().inNumbers(projectIds);
        }
        if (!issueTypeIds.isEmpty()) {
            clauseBuilder.issueType().inNumbers(issueTypeIds);
        }
        return clauseBuilder;
    }

    private List<Long> filterAndTransformIssueTypes(Collection<IssueType> issueTypes) {
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)Iterables.filter(issueTypes, (Predicate)Predicates.notNull()), (Function)IssueConstants.getIdAsLong()));
    }

    private boolean doesQueryHaveIssues(ApplicationUser user, Query query) {
        try {
            long issueCount = this.searchProvider.searchCountOverrideSecurity(query, user);
            return issueCount > 0L;
        }
        catch (SearchException e) {
            log.warn(e.getMessage(), (Throwable)e);
            return true;
        }
    }
}

