/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.system;

import com.atlassian.core.util.DateUtils;
import com.atlassian.jdk.utilities.runtimeinformation.MemoryInformation;
import com.atlassian.jdk.utilities.runtimeinformation.RuntimeInformation;
import com.atlassian.jira.JiraException;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.database.DatabaseConfig;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.database.DatabaseCollationReader;
import com.atlassian.jira.ofbiz.DefaultOfBizConnectionFactory;
import com.atlassian.jira.ofbiz.OfBizConnectionFactory;
import com.atlassian.jira.util.system.JiraRuntimeInformationFactory;
import com.atlassian.jira.util.system.ReleaseInfo;
import com.atlassian.jira.util.system.SystemInfoUtils;
import com.google.common.collect.Lists;
import com.opensymphony.module.sitemesh.util.Container;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import org.ofbiz.core.entity.GenericEntityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import webwork.action.ServletActionContext;

public class SystemInfoUtilsImpl
implements SystemInfoUtils {
    private static final String UNKNOWN = "Unknown";
    private static final Logger log = LoggerFactory.getLogger(SystemInfoUtilsImpl.class);
    private final Runtime rt = Runtime.getRuntime();
    private final RuntimeInformation runtimeInformation = JiraRuntimeInformationFactory.getRuntimeInformation();
    private final OfBizConnectionFactory connectionFactory = DefaultOfBizConnectionFactory.getInstance();

    @Override
    public String getDatabaseType() {
        DatabaseConfig config = this.getDbConfig();
        return config == null ? null : config.getDatabaseType();
    }

    @Override
    public String getDbDescriptorValue() {
        DatabaseConfig dbConfig = this.getDbConfig();
        if (dbConfig == null) {
            return null;
        }
        String desc = dbConfig.getDescriptorValue();
        return desc != null ? desc : "Unknown configuration";
    }

    @Override
    public String getDbDescriptorLabel() {
        DatabaseConfig dbConfig = this.getDbConfig();
        if (dbConfig == null) {
            return null;
        }
        return dbConfig.getDescriptorLabel();
    }

    @Override
    public String getAppServer() {
        switch (Container.get()) {
            case 1: {
                return "Apache Tomcat";
            }
            case 3: {
                return "Orion";
            }
            case 4: {
                return "IBM WebLogic";
            }
            case 6: {
                return "JRUN";
            }
            case 2: {
                return "RESIN" + Container.get();
            }
            case 5: {
                return "HPAS";
            }
        }
        return UNKNOWN;
    }

    @Override
    public String getUptime(ResourceBundle resourceBundle) {
        ServletContext servletContext = ServletActionContext.getServletContext();
        if (servletContext == null) {
            return "N/A";
        }
        Long startupTime = (Long)servletContext.getAttribute("jira_startup_time");
        if (startupTime == null) {
            return "N/A";
        }
        long currentTime = System.currentTimeMillis();
        return DateUtils.dateDifference((long)startupTime, (long)currentTime, (long)4L, (ResourceBundle)resourceBundle);
    }

    @Override
    public long getTotalMemory() {
        long totalMemory = this.rt.maxMemory();
        return totalMemory / 0x100000L;
    }

    @Override
    public long getFreeMemory() {
        long freeMemory = this.rt.maxMemory() - this.rt.totalMemory() + this.rt.freeMemory();
        return freeMemory / 0x100000L;
    }

    @Override
    public long getFreeAllocatedMemory() {
        return this.rt.freeMemory() / 0x100000L;
    }

    @Override
    public long getUnAllocatedMemory() {
        return (this.rt.maxMemory() - this.rt.totalMemory()) / 0x100000L;
    }

    @Override
    public long getAllocatedMemory() {
        return this.rt.maxMemory() / 0x100000L;
    }

    @Override
    public long getUsedMemory() {
        return this.getTotalMemory() - this.getFreeMemory();
    }

    @Override
    public List<MemoryInformation> getMemoryPoolInformation() {
        List list = this.runtimeInformation.getMemoryPoolInformation();
        ArrayList validList = Lists.newArrayListWithCapacity((int)list.size());
        for (MemoryInformation memoryInfo : list) {
            try {
                log.debug("Checking memory pool info is ok for: " + memoryInfo.getName());
                memoryInfo.toString();
                validList.add(memoryInfo);
            }
            catch (RuntimeException e) {
                log.warn("Memory pool info returned by the java runtime is invalid for pool - " + memoryInfo.getName());
                log.debug(e.getMessage(), (Throwable)e);
            }
        }
        return validList;
    }

    @Override
    public long getTotalPermGenMemory() {
        return this.runtimeInformation.getTotalPermGenMemory() / 0x100000L;
    }

    @Override
    public long getFreePermGenMemory() {
        long freeMemory = this.runtimeInformation.getTotalPermGenMemory() - this.runtimeInformation.getTotalPermGenMemoryUsed();
        return freeMemory / 0x100000L;
    }

    @Override
    public long getUsedPermGenMemory() {
        return this.runtimeInformation.getTotalPermGenMemoryUsed() / 0x100000L;
    }

    @Override
    public long getTotalNonHeapMemory() {
        return this.runtimeInformation.getTotalNonHeapMemory() / 0x100000L;
    }

    @Override
    public long getFreeNonHeapMemory() {
        long freeMemory = this.runtimeInformation.getTotalNonHeapMemory() - this.runtimeInformation.getTotalNonHeapMemoryUsed();
        return freeMemory / 0x100000L;
    }

    @Override
    public long getUsedNonHeapMemory() {
        return this.runtimeInformation.getTotalNonHeapMemoryUsed() / 0x100000L;
    }

    @Override
    public String getJvmInputArguments() {
        return this.runtimeInformation.getJvmInputArguments();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SystemInfoUtils.DatabaseMetaData getDatabaseMetaData() throws GenericEntityException, JiraException, SQLException {
        Connection connection = this.connectionFactory.getConnection();
        if (connection == null) {
            throw new JiraException("Could not get database connection");
        }
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            MaskedUrlDatabaseMetaData maskedUrlDatabaseMetaData = new MaskedUrlDatabaseMetaData(metaData.getDatabaseProductVersion(), metaData.getDriverName(), metaData.getDriverVersion(), this.getCollation(connection), metaData.getURL());
            return maskedUrlDatabaseMetaData;
        }
        finally {
            SystemInfoUtilsImpl.silentlyClose(connection);
        }
    }

    private String getCollation(Connection connection) {
        try {
            String collation = DatabaseCollationReader.findCollation(connection, this.getDbConfig());
            return collation != null ? collation : UNKNOWN;
        }
        catch (Exception e) {
            return UNKNOWN;
        }
    }

    private static void silentlyClose(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.warn("Something went wrong when closing the DB connection", (Throwable)e);
            }
        }
    }

    @Override
    public String getInstallationType() {
        ReleaseInfo releaseInfo = ReleaseInfo.getReleaseInfo(this.getClass());
        return releaseInfo.getInfo();
    }

    DatabaseConfig getDbConfig() {
        return ((DatabaseConfigurationManager)ComponentAccessor.getComponent(DatabaseConfigurationManager.class)).getDatabaseConfiguration();
    }

    protected static final class MaskedUrlDatabaseMetaData
    implements SystemInfoUtils.DatabaseMetaData {
        private final String productVersion;
        private final String driverName;
        private final String driverVersion;
        private final String collation;
        private final String maskedUrl;

        public static String maskDatabaseUrl(String url) {
            if (url == null) {
                return null;
            }
            Pattern passwordRegex = Pattern.compile("password=[^&;]*", 2);
            return passwordRegex.matcher(url).replaceAll("password=****");
        }

        public MaskedUrlDatabaseMetaData(String productVersion, String driverName, String driverVersion, String collation, String url) {
            this.productVersion = productVersion;
            this.driverName = driverName;
            this.driverVersion = driverVersion;
            this.collation = collation;
            this.maskedUrl = MaskedUrlDatabaseMetaData.maskDatabaseUrl(url);
        }

        @Override
        public String getDatabaseProductVersion() {
            return this.productVersion;
        }

        @Override
        public String getDriverName() {
            return this.driverName;
        }

        @Override
        public String getDriverVersion() {
            return this.driverVersion;
        }

        @Override
        public String getCollation() {
            return this.collation;
        }

        @Override
        public String getMaskedURL() {
            return this.maskedUrl;
        }
    }
}

