/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.log;

import com.atlassian.core.util.Clock;
import com.atlassian.jira.util.RealClock;
import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RateLimitingLogger {
    private static final int MAX_STACK_TRACES = 25;
    private static final int MAX_IDLE_TIME = 5;
    private final AtomicBoolean warningSuppressedMessageWritten = new AtomicBoolean(false);
    private final AtomicLong lastWarning = new AtomicLong(0L);
    private final AtomicInteger warningsLogged = new AtomicInteger(0);
    private final int maxStackTraces;
    private final long resetAfterMinutes;
    private final Clock clock;
    private final Logger delegate;
    private final String name;

    public RateLimitingLogger(Class clazz) {
        this(clazz, 25, 5);
    }

    public RateLimitingLogger(Class clazz, int maxStackTraces, int resetAfterMinutes) {
        this(LoggerFactory.getLogger((Class)clazz), maxStackTraces, resetAfterMinutes, RealClock.getInstance());
    }

    @VisibleForTesting
    RateLimitingLogger(Logger delegate, int maxStackTraces, int resetAfterMinutes, Clock clock) {
        this.delegate = delegate;
        this.name = delegate.getName();
        this.maxStackTraces = maxStackTraces;
        this.resetAfterMinutes = TimeUnit.MINUTES.toMillis(resetAfterMinutes);
        this.clock = clock;
    }

    public void debug(String message) {
        this.delegate.debug(message);
    }

    public void debug(String message, Throwable t) {
        this.delegate.debug(message, t);
    }

    public void error(String message) {
        this.delegate.error(message);
    }

    public void error(String message, Throwable t) {
        if (this.wantFullStackTrace()) {
            this.delegate.error(message, t);
        } else {
            this.delegate.error(message);
        }
    }

    public boolean isDebugEnabled() {
        return this.delegate.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.delegate.isInfoEnabled();
    }

    public void info(String message) {
        this.delegate.info(message);
    }

    public void info(String message, Throwable t) {
        this.delegate.info(message, t);
    }

    public void warn(String message) {
        this.delegate.warn(message);
    }

    public void warnWithTrace(String message) {
        if (this.wantFullStackTrace()) {
            this.delegate.warn(message, (Throwable)((Object)new AssertionError((Object)"Explicit stack trace requested")));
        } else {
            this.delegate.warn(message);
        }
    }

    public void errorWithTrace(String message) {
        if (this.wantFullStackTrace()) {
            this.delegate.error(message, (Throwable)((Object)new AssertionError((Object)"Explicit stack trace requested")));
        } else {
            this.delegate.error(message);
        }
    }

    public void warn(String message, Throwable t) {
        if (this.wantFullStackTrace()) {
            this.delegate.warn(message, t);
        } else {
            this.delegate.warn(message);
        }
    }

    protected boolean wantFullStackTrace() {
        if (this.isDebugEnabled()) {
            return true;
        }
        long systemTime = this.clock.getCurrentDate().getTime();
        if (systemTime - this.lastWarning.get() > this.resetAfterMinutes) {
            this.warningsLogged.set(0);
            this.warningSuppressedMessageWritten.set(false);
        }
        this.lastWarning.set(systemTime);
        if (this.warningsLogged.incrementAndGet() <= this.maxStackTraces) {
            return true;
        }
        if (this.warningSuppressedMessageWritten.compareAndSet(false, true)) {
            this.delegate.warn("*******************************************************************************************************************");
            this.delegate.warn("Further stacktraces of this type are temporarily suppressed.");
            this.delegate.warn("To enable full stacktraces set logger level for '" + this.name + "' to 'DEBUG' ");
            this.delegate.warn("*******************************************************************************************************************");
        }
        return false;
    }

    @VisibleForTesting
    void reset() {
        this.lastWarning.set(0L);
    }
}

