/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.util.BuildUtilsInfoImpl;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DowngradeUtilsImpl {
    private static final String PROPERTIES_FILENAME = "jira-downgrade.properties";
    private static final Logger logger = LoggerFactory.getLogger(DowngradeUtilsImpl.class);
    private final Properties downgradeProperties = this.loadProperties();

    public String getDowngradeAllowedVersion() {
        return this.downgradeProperties.getProperty("downgrade.minimum.build.version");
    }

    private Properties loadProperties() throws RuntimeException {
        InputStream propsFile = BuildUtilsInfoImpl.class.getResourceAsStream("/jira-downgrade.properties");
        if (propsFile == null) {
            throw new IllegalStateException("File not found: jira-downgrade.properties");
        }
        Properties result = new Properties();
        try {
            result.load(propsFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                propsFile.close();
            }
            catch (IOException e) {
                logger.warn("Error closing {}", (Object)propsFile);
            }
        }
        return result;
    }
}

