/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.bc.issue.worklog.TimeTrackingConfiguration;
import com.atlassian.jira.cache.SingleValueLocalCache;
import com.atlassian.jira.cache.SwitchingCacheFactory;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.DurationFormatChanged;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.tenancy.TenantAware;
import com.atlassian.jira.tenancy.TenantInfo;
import com.atlassian.jira.util.DurationFormatterProvider;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraDurationUtils;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TenantInfo(value=TenantAware.UNRESOLVED, comment="This class is tenanted, but cannot be marked as such until only vcache is used.")
@EventComponent
public class DefaultDurationFormatterProvider
implements DurationFormatterProvider {
    private static final Logger log = LoggerFactory.getLogger(DefaultDurationFormatterProvider.class);
    private static final String DARK_FEATURE_NAME = "jira.jvc.DefaultDurationFormatterFactory.caches.request";
    @TenantInfo(value=TenantAware.TENANTED)
    private SingleValueLocalCache<JiraDurationUtils.DurationFormatter> formatter;
    private ApplicationProperties applicationProperties;
    private TimeTrackingConfiguration timeTrackingConfiguration;
    private I18nHelper.BeanFactory i18nFactory;
    private JiraAuthenticationContext authenticationContext;

    public DefaultDurationFormatterProvider(SwitchingCacheFactory cacheFactory, ApplicationProperties applicationProperties, TimeTrackingConfiguration timeTrackingConfiguration, I18nHelper.BeanFactory i18nFactory, JiraAuthenticationContext authenticationContext) {
        this.applicationProperties = applicationProperties;
        this.timeTrackingConfiguration = timeTrackingConfiguration;
        this.i18nFactory = i18nFactory;
        this.authenticationContext = authenticationContext;
        this.formatter = cacheFactory.buildSwitchingRequestCache(this.getClass().getName() + ".formatter", this::load, DARK_FEATURE_NAME);
    }

    public JiraDurationUtils.DurationFormatter getFormatter() {
        return this.formatter.get();
    }

    @EventListener
    public void onDurationFormatChanged(DurationFormatChanged event) {
        this.reset();
    }

    @EventListener
    public void onClearCacheEvent(ClearCacheEvent event) {
        this.reset();
    }

    private void reset() {
        this.formatter.reset();
    }

    private JiraDurationUtils.DurationFormatter load() {
        BigDecimal hoursPerDay = this.timeTrackingConfiguration.getHoursPerDay();
        BigDecimal daysPerWeek = this.timeTrackingConfiguration.getDaysPerWeek();
        String format = this.applicationProperties.getDefaultBackedString("jira.timetracking.format");
        JiraDurationUtils.AuthContextI18nLocator i18nLocator = new JiraDurationUtils.AuthContextI18nLocator(this.i18nFactory, this.authenticationContext);
        if ("hours".equals(format)) {
            return new JiraDurationUtils.HoursDurationFormatter((JiraDurationUtils.I18nLocator)i18nLocator);
        }
        if ("days".equals(format)) {
            return new JiraDurationUtils.DaysDurationFormatter(hoursPerDay, (JiraDurationUtils.I18nLocator)i18nLocator);
        }
        if ("pretty".equals(format)) {
            return new JiraDurationUtils.PrettyDurationFormatter(hoursPerDay, daysPerWeek, (JiraDurationUtils.I18nLocator)i18nLocator);
        }
        log.warn("Duration format not configured! Please set the jira.timetracking.format property");
        return new JiraDurationUtils.PrettyDurationFormatter(hoursPerDay, daysPerWeek, (JiraDurationUtils.I18nLocator)i18nLocator);
    }
}

