/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.util;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.bc.EntityNotFoundException;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.bc.portal.PortalPageService;
import com.atlassian.jira.bc.project.component.MutableProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.bc.projectroles.ProjectRoleService;
import com.atlassian.jira.bc.user.UserService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.entity.property.JsonEntityPropertyManager;
import com.atlassian.jira.exception.AddException;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.comparator.UserCachingComparator;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.subscription.SubscriptionManager;
import com.atlassian.jira.issue.vote.VoteManager;
import com.atlassian.jira.issue.watchers.WatcherManager;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.license.LicenseCountService;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.login.LoginManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.UserDetails;
import com.atlassian.jira.user.UserHistoryManager;
import com.atlassian.jira.user.util.PasswordResetTokenBuilder;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.seraph.spi.rememberme.RememberMeTokenDao;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserUtilImpl
implements UserUtil {
    public static final String USERNAME = "username";
    public static final String EMAIL = "email";
    public static final String DISPLAY_NAME = "fullname";
    public static final String DIRECTORY_NAME = "directoryName";
    public static final String DIRECTORY_ID = "directoryId";
    public static final String PASSWORD_TOKEN = "password.token";
    public static final String PASSWORD_HOURS = "password.hours";
    public static final String SEND_EMAIL = "sendEmail";
    private static final Logger log = LoggerFactory.getLogger(UserUtilImpl.class);
    private final IssueSecurityLevelManager issueSecurityLevelManager;
    private final GlobalPermissionManager globalPermissionManager;
    private final CrowdService crowdService;
    private final PermissionManager permissionManager;
    private final ApplicationProperties applicationProperties;
    private final SearchProvider searchProvider;
    private final ProjectManager projectManager;
    private final ProjectRoleService projectRoleService;
    private final ProjectComponentManager componentManager;
    private final SubscriptionManager subscriptionManager;
    private final NotificationSchemeManager notificationSchemeManager;
    private final UserHistoryManager userHistoryManager;
    private final UserManager userManager;
    private final ApplicationRoleManager applicationRoleManager;
    private final JsonEntityPropertyManager jsonEntityPropertyManager;
    private final LicenseCountService licenseCountService;

    public UserUtilImpl(IssueSecurityLevelManager issueSecurityLevelManager, GlobalPermissionManager globalPermissionManager, CrowdService crowdService, PermissionManager permissionManager, ApplicationProperties applicationProperties, SearchProvider searchProvider, ProjectManager projectManager, ProjectRoleService projectRoleService, ProjectComponentManager componentManager, SubscriptionManager subscriptionManager, NotificationSchemeManager notificationSchemeManager, UserHistoryManager userHistoryManager, UserManager userManager, LicenseCountService licenseCountService, ApplicationRoleManager applicationRoleManager, JsonEntityPropertyManager jsonEntityPropertyManager) {
        this.issueSecurityLevelManager = issueSecurityLevelManager;
        this.globalPermissionManager = globalPermissionManager;
        this.permissionManager = permissionManager;
        this.applicationProperties = applicationProperties;
        this.searchProvider = searchProvider;
        this.projectManager = projectManager;
        this.projectRoleService = projectRoleService;
        this.componentManager = componentManager;
        this.subscriptionManager = subscriptionManager;
        this.notificationSchemeManager = notificationSchemeManager;
        this.userHistoryManager = userHistoryManager;
        this.userManager = userManager;
        this.crowdService = crowdService;
        this.licenseCountService = licenseCountService;
        this.applicationRoleManager = applicationRoleManager;
        this.jsonEntityPropertyManager = jsonEntityPropertyManager;
    }

    protected SearchRequestService getSearchRequestService() {
        return (SearchRequestService)ComponentAccessor.getComponent(SearchRequestService.class);
    }

    protected PortalPageService getPortalPageService() {
        return (PortalPageService)ComponentAccessor.getComponent(PortalPageService.class);
    }

    protected JiraServiceContext getServiceContext(ApplicationUser user) {
        return new JiraServiceContextImpl(user);
    }

    public ApplicationUser createUserNoNotification(String username, String password, String emailAddress, String displayName) throws PermissionException, CreateException {
        return this.createUser(new UserDetails(username, displayName).withPassword(password).withEmail(emailAddress), false, 1, null);
    }

    public ApplicationUser createUserNoNotification(String username, String password, String emailAddress, String displayName, Long directoryId) throws PermissionException, CreateException {
        return this.createUser(new UserDetails(username, displayName).withPassword(password).withEmail(emailAddress).withDirectory(directoryId), false, 1, null);
    }

    public ApplicationUser createUserWithNotification(String username, String password, String email, String fullname, int userEventType) throws PermissionException, CreateException {
        return this.createUser(new UserDetails(username, fullname).withPassword(password).withEmail(email).withDirectory(null), true, userEventType, null);
    }

    public ApplicationUser createUserWithNotification(String username, String password, String email, String fullname, Long directoryId, int userEventType) throws PermissionException, CreateException {
        return this.createUser(new UserDetails(username, fullname).withPassword(password).withEmail(email).withDirectory(directoryId), true, userEventType, null);
    }

    @Nonnull
    public ApplicationUser createUser(@Nonnull UserDetails userData, boolean sendEmailNotification, int eventType, @Nullable Set<ApplicationKey> applicationKeys) throws PermissionException, CreateException {
        UserService.CreateUserRequest createUserRequest = UserService.CreateUserRequest.withUserDetails(null, (String)userData.getUsername(), (String)userData.getPassword(), (String)userData.getEmailAddress(), (String)userData.getDisplayName()).inDirectory((Long)userData.getDirectoryId().orElse(null)).sendNotification(sendEmailNotification).withApplicationAccess(applicationKeys).withEventUserEvent(eventType).skipValidation();
        UserService userService = (UserService)ComponentAccessor.getComponent(UserService.class);
        return userService.createUser(userService.validateCreateUser(createUserRequest));
    }

    public void removeUser(ApplicationUser loggedInUser, ApplicationUser user) {
        if (user == null) {
            return;
        }
        SimpleErrorCollection errors = new SimpleErrorCollection();
        UserManager.UserState state = this.userManager.getUserState(user);
        try {
            if (!state.isInMultipleDirectories()) {
                this.removeUserReferences(loggedInUser, user, errors);
            }
            try {
                Iterable userGroups = this.crowdService.search(this.getGroupMembershipQuery(user));
                for (String groupName : userGroups) {
                    this.crowdService.removeUserFromGroup(user.getDirectoryUser(), this.crowdService.getGroup(groupName));
                }
                this.crowdService.removeUser(user.getDirectoryUser());
            }
            catch (OperationNotPermittedException e) {
                throw new PermissionException((Exception)((Object)e));
            }
        }
        catch (Exception e) {
            log.error("There was an error trying to remove user: " + user.getDisplayName(), (Throwable)e);
            throw new RuntimeException(e);
        }
        this.clearCache();
    }

    private void removeUserReferences(ApplicationUser loggedInUser, ApplicationUser user, SimpleErrorCollection errors) throws RemoveException, GenericEntityException {
        this.projectRoleService.removeAllRoleActorsByNameAndType(user.getKey(), "atlassian-user-role-actor", (ErrorCollection)errors);
        this.permissionManager.removeUserPermissions(user);
        this.removeWatchesForUser(user);
        this.removeVotesForUser(user);
        this.subscriptionManager.deleteSubscriptionsForUser(user);
        this.notificationSchemeManager.removeEntities("Single_User", user.getName());
        this.removeComponentLeadsForUser(user);
        this.getSearchRequestService().deleteAllFiltersForUser(this.getServiceContext(loggedInUser), user);
        this.getPortalPageService().deleteAllPortalPagesForUser(user);
        this.userHistoryManager.removeHistoryForUser(user);
        this.jsonEntityPropertyManager.deleteByEntity(EntityPropertyType.USER_PROPERTY.getDbEntityName(), user.getId());
    }

    public long getNumberOfReportedIssuesIgnoreSecurity(ApplicationUser loggedInUser, ApplicationUser user) throws SearchException {
        com.atlassian.query.Query query = JqlQueryBuilder.newBuilder().where().reporterUser(user.getUsername()).buildQuery();
        return this.searchProvider.searchCountOverrideSecurity(query, loggedInUser);
    }

    public long getNumberOfAssignedIssuesIgnoreSecurity(ApplicationUser loggedInUser, ApplicationUser user) throws SearchException {
        com.atlassian.query.Query query = JqlQueryBuilder.newBuilder().where().assigneeUser(user.getUsername()).buildQuery();
        return this.searchProvider.searchCountOverrideSecurity(query, loggedInUser);
    }

    public Collection<ProjectComponent> getComponentsUserLeads(ApplicationUser user) {
        return this.componentManager.findComponentsByLead(user.getUsername());
    }

    public Collection<Project> getProjectsLeadBy(ApplicationUser user) {
        return this.projectManager.getProjectsLeadBy(user);
    }

    public boolean isNonSysAdminAttemptingToDeleteSysAdmin(ApplicationUser loggedInUser, ApplicationUser user) {
        return this.permissionManager.hasPermission(44, user) && !this.permissionManager.hasPermission(44, loggedInUser);
    }

    private void removeVotesForUser(ApplicationUser userForDelete) {
        VoteManager voteManager = ComponentAccessor.getVoteManager();
        if (this.applicationProperties.getOption("jira.option.voting")) {
            voteManager.removeVotesForUser(userForDelete);
        }
    }

    private void removeWatchesForUser(ApplicationUser userForDelete) {
        WatcherManager watcherManager = ComponentAccessor.getWatcherManager();
        if (this.applicationProperties.getOption("jira.option.watching")) {
            watcherManager.removeAllWatchesForUser(userForDelete);
        }
    }

    private void removeComponentLeadsForUser(ApplicationUser user) {
        for (ProjectComponent component : this.getComponentsUserLeads(user)) {
            MutableProjectComponent newProjectComponent = MutableProjectComponent.copy((ProjectComponent)component);
            newProjectComponent.setLead(null);
            if (component.getAssigneeType() == 1L) {
                newProjectComponent.setAssigneeType(0L);
            }
            try {
                this.componentManager.update(newProjectComponent);
            }
            catch (EntityNotFoundException entityNotFoundException) {}
        }
    }

    public void addUserToGroup(Group group, ApplicationUser userToAdd) throws PermissionException, AddException {
        this.doAddUserToGroup(group, userToAdd);
        this.clearCache();
    }

    private void clearCache() {
        try {
            if (this.issueSecurityLevelManager != null) {
                this.issueSecurityLevelManager.clearUsersLevels();
            }
        }
        catch (UnsupportedOperationException uoe) {
            log.debug("Unsupported operation was thrown when trying to clear the issue security level manager cache", (Throwable)uoe);
        }
    }

    void doAddUserToGroup(Group group, ApplicationUser userToAdd) throws PermissionException, AddException {
        this.validateParameters(group, userToAdd);
        if (!this.crowdService.isUserMemberOfGroup(userToAdd.getDirectoryUser(), group)) {
            try {
                this.crowdService.addUserToGroup(userToAdd.getDirectoryUser(), group);
            }
            catch (OperationNotPermittedException e) {
                throw new PermissionException((Exception)((Object)e));
            }
            catch (OperationFailedException e) {
                throw new AddException((Exception)((Object)e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserToGroups(Collection<Group> groups, ApplicationUser userToAdd) throws PermissionException, AddException {
        try {
            for (Group group : groups) {
                this.doAddUserToGroup(group, userToAdd);
            }
        }
        finally {
            this.clearCache();
        }
    }

    public void removeUserFromGroup(Group group, ApplicationUser userToRemove) throws PermissionException, RemoveException {
        this.validateParameters(group, userToRemove);
        if (this.crowdService.isUserDirectGroupMember(userToRemove.getDirectoryUser(), group)) {
            try {
                this.crowdService.removeUserFromGroup(userToRemove.getDirectoryUser(), group);
            }
            catch (OperationNotPermittedException e) {
                throw new PermissionException((Exception)((Object)e));
            }
            catch (OperationFailedException e) {
                throw new RemoveException((Exception)((Object)e));
            }
        }
        this.clearCache();
    }

    public void removeUserFromGroups(Collection<Group> groups, ApplicationUser userToRemove) throws PermissionException, RemoveException {
        for (Group group : groups) {
            this.removeUserFromGroup(group, userToRemove);
        }
        this.clearCache();
    }

    public UserUtil.PasswordResetToken generatePasswordResetToken(ApplicationUser user) {
        return new PasswordResetTokenBuilder(this.crowdService).generateToken(user);
    }

    public UserUtil.PasswordResetTokenValidation validatePasswordResetToken(ApplicationUser user, String token) {
        Assertions.notNull((String)"user", (Object)user);
        UserUtil.PasswordResetTokenValidation.Status status = new PasswordResetTokenBuilder(this.crowdService).validateToken(user, token);
        return () -> status;
    }

    public void changePassword(ApplicationUser user, String newPassword) throws PermissionException, InvalidCredentialException {
        Assertions.notNull((String)"user", (Object)user);
        new PasswordResetTokenBuilder(this.crowdService).resetToken(user);
        ((RememberMeTokenDao)ComponentAccessor.getComponent(RememberMeTokenDao.class)).removeAllForUser(user.getName());
        ((LoginManager)ComponentAccessor.getComponent(LoginManager.class)).resetFailedLoginCount(user);
        try {
            this.crowdService.updateUserCredential(user.getDirectoryUser(), newPassword);
        }
        catch (OperationNotPermittedException e) {
            throw new PermissionException((Exception)((Object)e));
        }
        catch (InvalidCredentialException e) {
            throw new RuntimeException(e);
        }
    }

    public int getActiveUserCount() {
        return this.licenseCountService.totalBillableUsers();
    }

    public int getTotalUserCount() {
        return this.userManager.getTotalUserCount();
    }

    public void clearActiveUserCount() {
        this.licenseCountService.flush();
    }

    public boolean canActivateNumberOfUsers(int numUsers) {
        Assertions.notNull((String)"numUsers is null.", (Object)numUsers);
        if (numUsers < 0) {
            throw new IllegalArgumentException("numUsers must be non-negative");
        }
        if (numUsers == 0) {
            return true;
        }
        Set defaultApps = this.applicationRoleManager.getDefaultApplicationKeys();
        if (defaultApps.isEmpty()) {
            log.warn("No default Applications configured for JIRA. User won't be added to any groups.");
        }
        return defaultApps.stream().allMatch(appKey -> this.applicationRoleManager.hasSeatsAvailable(appKey, numUsers));
    }

    @Nonnull
    public Collection<ApplicationUser> getUsers() {
        return this.userManager.getUsers();
    }

    @Nonnull
    public Collection<ApplicationUser> getAllApplicationUsers() {
        return this.userManager.getAllApplicationUsers();
    }

    private User getUserCwd(String userName) {
        return this.crowdService.getUser(userName);
    }

    public ApplicationUser getUser(String userName) {
        if (StringUtils.isNotEmpty((String)userName)) {
            return this.getUserByName(userName);
        }
        return null;
    }

    public ApplicationUser getUserByKey(String key) {
        if (key == null) {
            return null;
        }
        return this.userManager.getUserByKey(key);
    }

    public ApplicationUser getUserByName(String username) {
        return this.userManager.getUserByName(username);
    }

    public ApplicationUser getUserObject(String userName) {
        return this.getUser(userName);
    }

    public boolean userExists(String userName) {
        return StringUtils.isNotEmpty((String)userName) && this.getUserCwd(userName) != null;
    }

    public Collection<ApplicationUser> getAdministrators() {
        return this.getJiraAdministrators();
    }

    public Collection<ApplicationUser> getJiraAdministrators() {
        return this.getAllUsersInGroups(this.globalPermissionManager.getGroupsWithPermission(GlobalPermissionKey.ADMINISTER));
    }

    public Collection<ApplicationUser> getSystemAdministrators() {
        return this.getJiraSystemAdministrators();
    }

    public Collection<ApplicationUser> getJiraSystemAdministrators() {
        return this.getAllUsersInGroups(this.globalPermissionManager.getGroupsWithPermission(GlobalPermissionKey.SYSTEM_ADMIN));
    }

    public void addToJiraUsePermission(ApplicationUser user) {
        if (this.canActivateNumberOfUsers(1)) {
            Collection groups = (Collection)this.applicationRoleManager.getDefaultApplicationKeys().stream().flatMap(appKey -> this.applicationRoleManager.getDefaultGroups(appKey).stream()).collect(CollectorsUtil.toImmutableSet());
            for (Group group : groups) {
                try {
                    this.doAddUserToGroup(group, user);
                }
                catch (AddException | PermissionException throwable) {}
            }
            this.clearCache();
        }
    }

    public String getDisplayableNameSafely(ApplicationUser user) {
        if (user == null) {
            return null;
        }
        String fullName = user.getDisplayName();
        if (StringUtils.isNotBlank((String)fullName)) {
            return fullName;
        }
        return user.getUsername();
    }

    public SortedSet<ApplicationUser> getAllUsersInGroups(Collection<Group> groups) {
        return this.getUsersInGroups(groups);
    }

    public SortedSet<ApplicationUser> getUsersInGroups(Collection<Group> groups) {
        Assertions.notNull((String)"groups", groups);
        ArrayList groupNames = Lists.newArrayListWithCapacity((int)groups.size());
        for (Group group : groups) {
            if (group == null) continue;
            groupNames.add(group.getName());
        }
        return this.getUsersInGroupNames(groupNames);
    }

    public SortedSet<ApplicationUser> getAllUsersInGroupNames(Collection<String> groupNames) {
        Set<ApplicationUser> allUsersUnsorted = this.getAllUsersInGroupNamesUnsorted(groupNames);
        TreeSet allUsersSorted = Sets.newTreeSet((Comparator)new UserCachingComparator());
        allUsersSorted.addAll(allUsersUnsorted);
        return allUsersSorted;
    }

    public Set<ApplicationUser> getAllUsersInGroupNamesUnsorted(Collection<String> groupNames) {
        Assertions.notNull((String)"groupNames", groupNames);
        HashSet setOfUsers = Sets.newHashSet();
        for (String groupName : groupNames) {
            if (groupName == null) continue;
            Iterable<User> users = this.getGroupMembers(groupName);
            setOfUsers.addAll(ApplicationUsers.from(users));
        }
        return Collections.unmodifiableSet(setOfUsers);
    }

    public SortedSet<ApplicationUser> getUsersInGroupNames(Collection<String> groupNames) {
        return this.getAllUsersInGroupNames(groupNames);
    }

    public SortedSet<Group> getGroupsForUser(String userName) {
        Assertions.notNull((String)"userName", (Object)userName);
        TreeSet<Group> setOfGroups = new TreeSet<Group>();
        Iterable<Group> groups = this.getGroupsForUserFromCrowd(userName);
        for (Group group : groups) {
            setOfGroups.add(group);
        }
        return Collections.unmodifiableSortedSet(setOfGroups);
    }

    public SortedSet<String> getGroupNamesForUser(String userName) {
        Assertions.notNull((String)"userName", (Object)userName);
        TreeSet<String> setOfGroups = new TreeSet<String>();
        Iterable<String> groups = this.getGroupNamesForUserFromCrowd(userName);
        for (String groupName : groups) {
            setOfGroups.add(groupName);
        }
        return Collections.unmodifiableSortedSet(setOfGroups);
    }

    private Group getGroupCwd(String groupName) {
        return this.crowdService.getGroup(groupName);
    }

    public Group getGroup(String groupName) {
        if (StringUtils.isNotEmpty((String)groupName)) {
            return this.getGroupCwd(groupName);
        }
        return null;
    }

    public Group getGroupObject(@Nullable String groupName) {
        return this.getGroup(groupName);
    }

    private void validateParameters(Group group, ApplicationUser userParam) {
        if (group == null) {
            throw new IllegalArgumentException("Group must not be null if trying to add or delete a user from it.");
        }
        if (userParam == null) {
            throw new IllegalArgumentException("User must not be null if trying to add or delete them from a group.");
        }
    }

    JiraLicenseService getLicenseService() {
        return (JiraLicenseService)ComponentAccessor.getComponent(JiraLicenseService.class);
    }

    private Iterable<User> getGroupMembers(String groupName) {
        MembershipQuery membershipQuery = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(groupName).returningAtMost(-1);
        return this.crowdService.search((Query)membershipQuery);
    }

    private Iterable<Group> getGroupsForUserFromCrowd(String userName) {
        MembershipQuery membershipQuery = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(userName).returningAtMost(-1);
        return this.crowdService.search((Query)membershipQuery);
    }

    private Iterable<String> getGroupNamesForUserFromCrowd(String userName) {
        MembershipQuery membershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(userName).returningAtMost(-1);
        return this.crowdService.search((Query)membershipQuery);
    }

    private MembershipQuery<String> getGroupMembershipQuery(ApplicationUser user) {
        return QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(user.getName()).returningAtMost(-1);
    }
}

