/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.util;

import com.atlassian.applinks.api.auth.oauth.ConsumerTokenService;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.embedded.impl.ImmutableUser;
import com.atlassian.crowd.exception.CrowdException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.search.query.entity.GroupQuery;
import com.atlassian.crowd.search.query.entity.UserQuery;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.crowd.util.SecureRandomStringUtils;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.crowd.embedded.ofbiz.ExtendedUserDao;
import com.atlassian.jira.crowd.embedded.ofbiz.UserOrGroupStub;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.license.LicenseCountService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUserEntity;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.DelegatingApplicationUser;
import com.atlassian.jira.user.UserDetails;
import com.atlassian.jira.user.util.UserIdentity;
import com.atlassian.jira.user.util.UserKeyStore;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUserManager
implements UserManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultUserManager.class);
    private static final UserQuery<User> QUERY_ALL_USERS = new UserQuery(User.class, (SearchRestriction)NullRestrictionImpl.INSTANCE, 0, -1);
    private final CrowdService crowdService;
    private final CrowdDirectoryService crowdDirectoryService;
    private final DirectoryManager directoryManager;
    private final UserKeyStore userKeyStore;
    private final ApplicationManager applicationManager;
    private final ApplicationProperties applicationProperties;
    private final ExtendedUserDao userDao;

    public DefaultUserManager(CrowdService crowdService, CrowdDirectoryService crowdDirectoryService, DirectoryManager directoryManager, UserKeyStore userKeyStore, ApplicationManager applicationManager, ApplicationProperties applicationProperties, ExtendedUserDao userDao) {
        this.crowdService = crowdService;
        this.crowdDirectoryService = crowdDirectoryService;
        this.directoryManager = directoryManager;
        this.userKeyStore = userKeyStore;
        this.applicationManager = applicationManager;
        this.applicationProperties = applicationProperties;
        this.userDao = userDao;
    }

    public int getTotalUserCount() {
        if (this.userDao.useFullCache()) {
            return this.getAllUsersFromCrowd().size();
        }
        List directories = this.crowdDirectoryService.findAllDirectories();
        HashSet<Long> directoryIds = new HashSet<Long>();
        for (Directory directory : directories) {
            directoryIds.add(directory.getId());
        }
        try {
            return (int)this.userDao.getUniqueUserCount(directoryIds);
        }
        catch (DirectoryNotFoundException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    @Nonnull
    public Collection<ApplicationUser> getUsers() {
        return this.getAllApplicationUsers();
    }

    @Nonnull
    public Collection<ApplicationUser> getAllApplicationUsers() {
        Collection<User> crowdUsers = this.getAllUsersFromCrowd();
        ArrayList<ApplicationUser> users = new ArrayList<ApplicationUser>(crowdUsers.size());
        for (User user : crowdUsers) {
            this.toApplicationUser(user).ifPresent(users::add);
        }
        return users;
    }

    private Optional<DelegatingApplicationUser> toApplicationUser(User user) {
        return Optional.ofNullable(user).flatMap(u -> this.userKeyStore.getUserForUsername(u.getName())).map(userData -> new DelegatingApplicationUser(userData.getId(), userData.getKey(), user));
    }

    @Nonnull
    private List<User> getAllUsersFromDirectory(@Nonnull Directory directory, boolean reportDirectoryNotFound) {
        try {
            return this.directoryManager.searchUsers(directory.getId().longValue(), QUERY_ALL_USERS);
        }
        catch (DirectoryNotFoundException e) {
            if (reportDirectoryNotFound) {
                throw new OperationFailedException((Throwable)e);
            }
            return ImmutableList.of();
        }
        catch (com.atlassian.crowd.exception.OperationFailedException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    @Nonnull
    private Collection<User> getAllUsersFromCrowd() {
        Collection<Object> allUsers;
        long startTime = System.currentTimeMillis();
        ArrayList userDirectories = Lists.newArrayList((Iterable)this.crowdDirectoryService.findAllDirectories());
        if (userDirectories.size() > 1) {
            HashMap<String, User> uniqueSetOfUsers = new HashMap<String, User>();
            Collections.reverse(userDirectories);
            for (Directory directory : userDirectories) {
                if (!directory.isActive()) continue;
                for (User user : this.getAllUsersFromDirectory(directory, false)) {
                    String lowercaseUsername = user instanceof UserOrGroupStub ? ((UserOrGroupStub)user).getLowerName() : IdentifierUtils.toLowerCase((String)user.getName());
                    uniqueSetOfUsers.put(lowercaseUsername, user);
                }
            }
            allUsers = uniqueSetOfUsers.values();
        } else {
            allUsers = userDirectories.size() == 1 ? this.getAllUsersFromDirectory((Directory)userDirectories.get(0), true) : Collections.emptyList();
        }
        if (log.isDebugEnabled()) {
            log.info("Found " + allUsers.size() + " users in " + (System.currentTimeMillis() - startTime) + "ms.");
        }
        return allUsers;
    }

    @Nonnull
    public Set<ApplicationUser> getAllUsers() {
        return Sets.newHashSet(this.getAllApplicationUsers());
    }

    private User getCrowdUser(String userName) {
        if (userName == null) {
            return null;
        }
        return this.crowdService.getUser(userName);
    }

    public ApplicationUser getUser(String userName) {
        return this.getUserObject(userName);
    }

    public ApplicationUser getUserObject(@Nullable String userName) {
        return this.getUserByName(userName);
    }

    public ApplicationUser findUserInDirectory(String userName, Long directoryId) {
        try {
            com.atlassian.crowd.model.user.User user = this.directoryManager.findUserByName(directoryId.longValue(), userName);
            return this.toApplicationUser((User)user).orElse(null);
        }
        catch (DirectoryNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        catch (UserNotFoundException e) {
            return null;
        }
        catch (com.atlassian.crowd.exception.OperationFailedException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public ApplicationUser getUserEvenWhenUnknown(String userName) {
        if (userName == null) {
            return null;
        }
        User user = this.getCrowdUser(userName);
        return ApplicationUsers.from(user != null ? user : this.unknownUser(userName));
    }

    public Optional<ApplicationUser> getUserById(Long id) {
        return this.userKeyStore.getUserForId(id).flatMap(this::toApplicationUser);
    }

    public ApplicationUser getUserByKey(String key) {
        return this.userKeyStore.getUserForKey(key).flatMap(this::toApplicationUser).orElse(null);
    }

    public ApplicationUser getUserByName(String username) {
        return this.userKeyStore.getUserForUsername(username).flatMap(this::toApplicationUser).orElse(null);
    }

    public ApplicationUser getUserByKeyEvenWhenUnknown(@Nullable String userKey) {
        return this.getApplicationUserEvenWhenUnknown(userKey, this.userKeyStore::getUserForKey, () -> this.unknownApplicationUser(-1L, userKey, userKey));
    }

    public ApplicationUser getUserByNameEvenWhenUnknown(@Nullable String userName) {
        return this.getApplicationUserEvenWhenUnknown(userName, this.userKeyStore::getUserForUsername, () -> this.unknownApplicationUser(-1L, IdentifierUtils.toLowerCase((String)userName), userName));
    }

    private ApplicationUser getApplicationUserEvenWhenUnknown(String parameter, Function<String, Optional<ApplicationUserEntity>> userEntityLoader, Supplier<ApplicationUser> defaultIfNotFound) {
        if (parameter == null) {
            return null;
        }
        return userEntityLoader.apply(parameter).map(data -> {
            ApplicationUser user = this.getUser(data.getUsername());
            if (user == null) {
                return this.unknownApplicationUser(data.getId(), data.getKey(), data.getUsername());
            }
            return user;
        }).orElseGet(defaultIfNotFound);
    }

    private Optional<ApplicationUser> toApplicationUser(ApplicationUserEntity userData) {
        User user = this.getCrowdUser(userData.getUsername());
        return user != null ? Optional.ofNullable(new DelegatingApplicationUser(userData.getId(), userData.getKey(), user)) : Optional.empty();
    }

    public boolean canUpdateUser(ApplicationUser user) {
        if (user == null) {
            return false;
        }
        return this.userDirectoryAllowsUpdateUser(user);
    }

    public boolean userCanUpdateOwnDetails(@Nonnull ApplicationUser user) {
        return this.canUpdateUser(user) && !this.applicationProperties.getOption("jira.option.user.externalmanagement");
    }

    public boolean canRenameUser(ApplicationUser user) {
        return this.userDirectoryAllowsRenameUser(user) && this.isJaacsUnusedOrRenameAllowedAnyway();
    }

    @VisibleForTesting
    boolean isJaacsUnusedOrRenameAllowedAnyway() {
        return this.applicationProperties.getOption("jira.option.user.crowd.allow.rename") || !Iterables.any((Iterable)this.applicationManager.findAll(), (Predicate)new IsExternalApplication());
    }

    private void handleDeletedUserEviction(String fromUsername) {
        if (this.userKeyStore.getKeyForUsername(fromUsername) == null) {
            return;
        }
        int count = 1;
        String toUsername = fromUsername + "#1";
        while (this.userKeyStore.getKeyForUsername(toUsername) != null) {
            if (count == Integer.MAX_VALUE) {
                throw new IllegalStateException("Deleted user eviction namespace exhausted");
            }
            toUsername = fromUsername + '#' + ++count;
        }
        this.userKeyStore.renameUser(fromUsername, toUsername);
    }

    private void handleRenamedUser(ApplicationUser user) {
        String oldUsername;
        String newUsername = IdentifierUtils.toLowerCase((String)user.getUsername());
        if (newUsername.equals(oldUsername = this.userKeyStore.getUsernameForKey(user.getKey()))) {
            return;
        }
        if (this.getCrowdUser(newUsername) != null) {
            throw new IllegalArgumentException("Cannot rename: user with username '" + newUsername + "' already exists.");
        }
        this.handleDeletedUserEviction(newUsername);
        try {
            this.directoryManager.renameUser(user.getDirectoryId(), oldUsername, user.getUsername());
            if (this.crowdService.getUser(oldUsername) != null) {
                this.userKeyStore.ensureUniqueKeyForNewUser(oldUsername);
            }
            this.clearConsumerTokens(oldUsername);
        }
        catch (CrowdException ex) {
            throw new OperationFailedException((Throwable)ex);
        }
        catch (DirectoryPermissionException ex) {
            throw new OperationFailedException((Throwable)ex);
        }
    }

    private void clearConsumerTokens(String username) {
        ConsumerTokenService consumerTokenService = (ConsumerTokenService)ComponentAccessor.getOSGiComponentInstanceOfType(ConsumerTokenService.class);
        if (consumerTokenService != null) {
            consumerTokenService.removeAllTokensForUsername(username);
        } else if (log.isDebugEnabled()) {
            log.debug("Unable to clear consumer tokens for '" + username + "' because the service could not be located.  Maybe applinks is offline?");
        }
    }

    public void updateUser(ApplicationUser user) {
        this.handleRenamedUser(user);
        try {
            User updatedUser = ImmutableUser.newUser((User)user.getDirectoryUser()).emailAddress(StringUtils.trim((String)user.getEmailAddress())).name(user.getUsername()).toUser();
            this.crowdService.updateUser(updatedUser);
            ((LicenseCountService)ComponentAccessor.getComponent(LicenseCountService.class)).flush();
        }
        catch (InvalidUserException | OperationNotPermittedException ex) {
            throw new OperationFailedException(ex);
        }
    }

    public boolean canUpdateUserPassword(ApplicationUser user) {
        if (!this.userDirectoryAllowsUpdateUser(user)) {
            return false;
        }
        Directory directory = this.crowdDirectoryService.findDirectoryById(user.getDirectoryId());
        return this.canDirectoryUpdateUserPassword(directory);
    }

    private boolean userDirectoryAllowsUpdateUser(ApplicationUser user) {
        if (user == null) {
            return false;
        }
        Directory directory = this.crowdDirectoryService.findDirectoryById(user.getDirectoryId());
        if (directory == null) {
            return false;
        }
        return directory.getAllowedOperations().contains(OperationType.UPDATE_USER);
    }

    private boolean userDirectoryAllowsRenameUser(ApplicationUser user) {
        if (user == null) {
            return false;
        }
        Directory directory = this.crowdDirectoryService.findDirectoryById(user.getDirectoryId());
        if (directory == null) {
            return false;
        }
        if (!directory.getAllowedOperations().contains(OperationType.UPDATE_USER)) {
            return false;
        }
        DirectoryType directoryType = directory.getType();
        return directoryType == DirectoryType.INTERNAL || directoryType == DirectoryType.DELEGATING;
    }

    public boolean canUpdateGroupMembershipForUser(ApplicationUser user) {
        if (user == null) {
            return false;
        }
        Directory directory = this.crowdDirectoryService.findDirectoryById(user.getDirectoryId());
        if (directory == null) {
            return false;
        }
        return directory.getAllowedOperations().contains(OperationType.UPDATE_GROUP);
    }

    public Collection<Group> getGroups() {
        GroupQuery query = new GroupQuery(Group.class, GroupType.GROUP, (SearchRestriction)NullRestrictionImpl.INSTANCE, 0, -1);
        Iterable crowdGroups = this.crowdService.search((Query)query);
        if (crowdGroups instanceof Collection) {
            return (Collection)crowdGroups;
        }
        LinkedHashSet<Group> groups = new LinkedHashSet<Group>();
        for (Group group : crowdGroups) {
            groups.add(group);
        }
        return groups;
    }

    public Set<Group> getAllGroups() {
        Collection<Group> groups = this.getGroups();
        if (groups instanceof Set) {
            return (Set)groups;
        }
        return new LinkedHashSet<Group>(groups);
    }

    private Group getCrowdGroup(String groupName) {
        if (groupName == null) {
            return null;
        }
        return this.crowdService.getGroup(groupName);
    }

    public Group getGroup(String groupName) {
        return this.getCrowdGroup(groupName);
    }

    public Group getGroupObject(@Nullable String groupName) {
        return this.getCrowdGroup(groupName);
    }

    @Nonnull
    public List<Directory> getWritableDirectories() {
        List allDirectories = this.crowdDirectoryService.findAllDirectories();
        ArrayList<Directory> writableDirectories = new ArrayList<Directory>(allDirectories.size());
        for (Directory directory : allDirectories) {
            if (!directory.getAllowedOperations().contains(OperationType.CREATE_USER) || !directory.isActive()) continue;
            writableDirectories.add(directory);
        }
        return writableDirectories;
    }

    @Nonnull
    public Optional<Directory> getDefaultCreateDirectory() {
        return this.getWritableDirectories().stream().findFirst();
    }

    public boolean hasWritableDirectory() {
        return this.getWritableDirectories().size() > 0;
    }

    public boolean hasPasswordWritableDirectory() {
        List<Directory> writableDirectories = this.getWritableDirectories();
        for (Directory directory : writableDirectories) {
            if (!this.canDirectoryUpdateUserPassword(directory)) continue;
            return true;
        }
        return false;
    }

    public boolean hasGroupWritableDirectory() {
        List allDirectories = this.crowdDirectoryService.findAllDirectories();
        for (Directory directory : allDirectories) {
            if (!directory.isActive() || !directory.getAllowedOperations().contains(OperationType.CREATE_GROUP)) continue;
            return true;
        }
        return false;
    }

    public Directory getDirectory(Long directoryId) {
        return this.crowdDirectoryService.findDirectoryById(directoryId.longValue());
    }

    public boolean isUserExisting(ApplicationUser user) {
        return user != null && user.getDirectoryId() != -1L;
    }

    @Nonnull
    public String generateRandomPassword() {
        return SecureRandomStringUtils.getInstance().randomAlphanumericString(26) + "ABab23";
    }

    public boolean canDirectoryUpdateUserPassword(Directory directory) {
        if (directory == null) {
            return false;
        }
        if (directory.getType() == DirectoryType.DELEGATING) {
            return false;
        }
        return directory.getAllowedOperations().contains(OperationType.UPDATE_USER);
    }

    @Nonnull
    public UserManager.UserState getUserState(@Nullable ApplicationUser user) {
        if (user == null) {
            return UserManager.UserState.INVALID_USER;
        }
        return this.getUserState(((ApplicationUser)Assertions.notNull((String)"user", (Object)user)).getUsername(), user.getDirectoryId());
    }

    @Nonnull
    public UserManager.UserState getUserState(@Nonnull String username, long queryDirectoryId) {
        Assertions.notNull((String)"username", (Object)username);
        if (queryDirectoryId == -1L) {
            return UserManager.UserState.INVALID_USER;
        }
        boolean foundQuery = false;
        boolean foundOther = false;
        for (Directory directory : this.crowdDirectoryService.findAllDirectories()) {
            if (queryDirectoryId == directory.getId()) {
                if (!this.isUserInDirectory(username, directory)) {
                    return UserManager.UserState.INVALID_USER;
                }
                if (foundOther) {
                    return UserManager.UserState.SHADOW_USER;
                }
                foundQuery = true;
                continue;
            }
            if (foundOther || !this.isUserInDirectory(username, directory)) continue;
            if (foundQuery) {
                return UserManager.UserState.NORMAL_USER_WITH_SHADOW;
            }
            foundOther = true;
        }
        return foundQuery ? UserManager.UserState.NORMAL_USER : UserManager.UserState.INVALID_USER;
    }

    private boolean isUserInDirectory(String userName, Directory directory) {
        return directory.isActive() && this.findUserInDirectory(userName, directory.getId()) != null;
    }

    private User unknownUser(String userNameOrKey) {
        return new ImmutableUser(-1L, userNameOrKey, userNameOrKey, "?", false);
    }

    private ApplicationUser unknownApplicationUser(Long id, String userKey, String userName) {
        return new DelegatingApplicationUser(id, userKey, this.unknownUser(userName));
    }

    @Nonnull
    @VisibleForTesting
    String generatePasswordIfEmpty(@Nullable String providedPassword) {
        if (StringUtils.isEmpty((String)providedPassword)) {
            return this.generateRandomPassword();
        }
        return providedPassword;
    }

    @Nonnull
    @VisibleForTesting
    UserTemplate from(@Nonnull UserDetails userRequest) {
        Assertions.notNull((String)"userData", (Object)userRequest);
        UserTemplate userTemplate = new UserTemplate(userRequest.getUsername());
        userTemplate.setDisplayName(userRequest.getDisplayName());
        userTemplate.setActive(true);
        userTemplate.setEmailAddress(StringUtils.trim((String)userRequest.getEmailAddress()));
        return userTemplate;
    }

    @Nonnull
    public ApplicationUser createUser(@Nonnull UserDetails userData) throws CreateException, PermissionException {
        Assertions.notNull((String)"userData", (Object)userData);
        try {
            UserTemplate userTemplate = this.from(userData);
            String password = this.generatePasswordIfEmpty(userData.getPassword());
            if (!userData.getDirectoryId().isPresent()) {
                return ApplicationUsers.from(this.crowdService.addUser((User)userTemplate, password));
            }
            Long directoryId = (Long)userData.getDirectoryId().get();
            userTemplate.setDirectoryId(directoryId.longValue());
            return ApplicationUsers.from((User)this.directoryManager.addUser(directoryId.longValue(), userTemplate, new PasswordCredential(password)));
        }
        catch (DirectoryNotFoundException | InvalidCredentialException | InvalidUserException | UserAlreadyExistsException e) {
            throw new CreateException((Exception)e);
        }
        catch (OperationNotPermittedException | DirectoryPermissionException e) {
            throw new PermissionException((Exception)e);
        }
        catch (com.atlassian.crowd.exception.OperationFailedException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public Optional<UserIdentity> getUserIdentityById(Long id) {
        return this.userKeyStore.getUserForId(id).map(this::userEntityToIdentity);
    }

    public Optional<UserIdentity> getUserIdentityByKey(String key) {
        return this.userKeyStore.getUserForKey(key).map(this::userEntityToIdentity);
    }

    public Optional<UserIdentity> getUserIdentityByUsername(String username) {
        return this.userKeyStore.getUserForUsername(username).map(this::userEntityToIdentity);
    }

    private UserIdentity userEntityToIdentity(ApplicationUserEntity user) {
        return UserIdentity.withId((Long)user.getId()).key(user.getKey()).andUsername(user.getUsername());
    }

    static class IsExternalApplication
    implements Predicate<Application> {
        IsExternalApplication() {
        }

        public boolean apply(Application input) {
            return !input.isPermanent();
        }
    }
}

