/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserHistoryManager;
import com.atlassian.jira.user.UserIssueHistoryManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUserIssueHistoryManager
implements UserIssueHistoryManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultUserIssueHistoryManager.class);
    private final PermissionManager permissionManager;
    private final IssueManager issueManager;
    private final UserHistoryManager userHistoryManager;
    private final ApplicationProperties applicationProperties;

    public DefaultUserIssueHistoryManager(UserHistoryManager userHistoryManager, PermissionManager permissionManager, IssueManager issueManager, ApplicationProperties applicationProperties) {
        this.userHistoryManager = userHistoryManager;
        this.permissionManager = permissionManager;
        this.issueManager = issueManager;
        this.applicationProperties = applicationProperties;
    }

    public void addIssueToHistory(@Nonnull ApplicationUser user, @Nonnull Issue issue) {
        Assertions.notNull((String)"issue", (Object)issue);
        this.userHistoryManager.addItemToHistory(UserHistoryItem.ISSUE, user, issue.getId().toString());
    }

    public boolean hasIssueHistory(ApplicationUser user) {
        List history = this.userHistoryManager.getHistory(UserHistoryItem.ISSUE, user);
        if (history != null) {
            for (UserHistoryItem historyItem : history) {
                MutableIssue issue = this.issueManager.getIssueObject(Long.valueOf(historyItem.getEntityId()));
                if (issue == null || !this.permissionManager.hasPermission(10, (Issue)issue, user)) continue;
                return true;
            }
        }
        return false;
    }

    @Nonnull
    public List<UserHistoryItem> getFullIssueHistoryWithoutPermissionChecks(ApplicationUser user) {
        return this.userHistoryManager.getHistory(UserHistoryItem.ISSUE, user);
    }

    @Nonnull
    public List<UserHistoryItem> getFullIssueHistoryWithPermissionChecks(ApplicationUser user) {
        return this.getViewableIssueHistory(user, Integer.MAX_VALUE);
    }

    @Nonnull
    public List<Issue> getShortIssueHistory(ApplicationUser user) {
        int maxItems = 6;
        try {
            maxItems = Integer.parseInt(this.applicationProperties.getDefaultBackedString("jira.max.issue.history.dropdown.items"));
        }
        catch (NumberFormatException e) {
            log.warn("Incorrect format of property 'jira.max.history.dropdown.items'.  Should be a number.");
        }
        return this.getViewableIssuesFromHistory(user, maxItems);
    }

    private List<Issue> getViewableIssuesFromHistory(ApplicationUser user, int maxItems) {
        List<UserHistoryItem> history = this.getFullIssueHistoryWithoutPermissionChecks(user);
        if (history == null) {
            return Lists.newArrayList();
        }
        ArrayList<Issue> returnList = new ArrayList<Issue>(maxItems < Integer.MAX_VALUE ? maxItems : history.size());
        List userHistoryPartitions = maxItems < Integer.MAX_VALUE ? Lists.partition(history, (int)maxItems) : ImmutableList.of(history);
        Iterator iterator = userHistoryPartitions.iterator();
        while (iterator.hasNext()) {
            List userHistoryItem = (List)iterator.next();
            List issues = this.issueManager.getIssueObjects((Collection)userHistoryItem.stream().map(uhi -> Long.valueOf(uhi.getEntityId())).collect(CollectorsUtil.toImmutableListWithSizeOf((Collection)userHistoryItem)));
            for (Issue issue : issues) {
                if (issue == null || !this.permissionManager.hasPermission(10, issue, user)) continue;
                returnList.add(issue);
                if (returnList.size() < maxItems) continue;
                return returnList;
            }
        }
        return returnList;
    }

    private List<UserHistoryItem> getViewableIssueHistory(ApplicationUser user, int maxItems) {
        List<UserHistoryItem> history = this.getFullIssueHistoryWithoutPermissionChecks(user);
        if (history == null) {
            return Lists.newArrayList();
        }
        ArrayList<UserHistoryItem> returnList = new ArrayList<UserHistoryItem>(history.size());
        for (UserHistoryItem userHistoryItem : history) {
            MutableIssue issue = this.issueManager.getIssueObject(Long.valueOf(userHistoryItem.getEntityId()));
            if (issue == null || !this.permissionManager.hasPermission(10, (Issue)issue, user)) continue;
            returnList.add(userHistoryItem);
            if (returnList.size() < maxItems) continue;
            return returnList;
        }
        return returnList;
    }
}

