/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.entity.Update;
import com.atlassian.jira.service.ServiceManager;
import com.atlassian.jira.upgrade.AbstractImmediateUpgradeTask;
import com.atlassian.jira.upgrade.tasks.util.CronExpressionFixer;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build70009
extends AbstractImmediateUpgradeTask {
    private static final Logger LOG = LoggerFactory.getLogger(UpgradeTask_Build70009.class);
    private static final String SERVICE_CONFIG = "ServiceConfig";
    private static final String ID = "id";
    private static final String CRON_EXPRESSION = "cronExpression";
    private final EntityEngine entityEngine;
    private final ServiceManager serviceManager;

    public UpgradeTask_Build70009(EntityEngine entityEngine, ServiceManager serviceManager) {
        this.entityEngine = entityEngine;
        this.serviceManager = serviceManager;
    }

    @Override
    public int getBuildNumber() {
        return 70009;
    }

    @Override
    public String getShortDescription() {
        return "Repair any malformed cron expressions in the 'serviceconfig' table";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        this.repairServiceConfigs();
    }

    @Override
    public boolean isDowngradeTaskRequired() {
        return false;
    }

    private void repairServiceConfigs() {
        Map<Long, String> repairs = this.getRepairs();
        if (repairs.isEmpty()) {
            return;
        }
        repairs.forEach((id, cronExpression) -> Update.into(SERVICE_CONFIG).set(CRON_EXPRESSION, (String)cronExpression).whereIdEquals((Long)id).execute(this.entityEngine));
        this.serviceManager.refreshAll();
    }

    private Map<Long, String> getRepairs() {
        Map<Long, String> existing = this.findServiceConfigs();
        HashMap repairs = Maps.newHashMap();
        existing.forEach((id, oldCron) -> UpgradeTask_Build70009.repairCronExpression(id, oldCron, repairs::put));
        return repairs;
    }

    private static void repairCronExpression(Long id, String oldCron, BiConsumer<Long, String> put) {
        CronExpressionFixer.Result result = CronExpressionFixer.repairCronExpression(oldCron);
        result.getNewCronExpression().ifPresent(newCron -> {
            LOG.warn("Repairing cron expression for service {}: '{}' => '{}'", new Object[]{id, oldCron, newCron});
            put.accept(id, (String)newCron);
        });
        result.getCronSyntaxException().ifPresent(exception -> LOG.error("Unable to repair cron expression for service id {}: '{}': {}", new Object[]{id, oldCron, exception.toString()}));
    }

    private Map<Long, String> findServiceConfigs() {
        return Select.columns(ID, CRON_EXPRESSION).from(SERVICE_CONFIG).whereCondition((EntityCondition)new EntityExpr(CRON_EXPRESSION, EntityOperator.NOT_EQUAL, null)).runWith(this.entityEngine).asMap(gv -> gv.getLong(ID), gv -> gv.getString(CRON_EXPRESSION));
    }
}

