/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.config.properties.PropertiesManager;
import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.upgrade.AbstractDelayableUpgradeTask;
import com.atlassian.jira.user.ApplicationUserEntity;
import com.opensymphony.module.propertyset.PropertySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build65001
extends AbstractDelayableUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask_Build65001.class);
    private final EntityEngine entityEngine;
    private final PropertiesManager propertiesManager;

    public UpgradeTask_Build65001(EntityEngine entityEngine, PropertiesManager propertiesManager) {
        this.entityEngine = entityEngine;
        this.propertiesManager = propertiesManager;
    }

    @Override
    public int getBuildNumber() {
        return 65001;
    }

    @Override
    public String getShortDescription() {
        return "Storing max(app_user) to enable onboarding for new users";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        PropertySet propertySet = this.propertiesManager.getPropertySet();
        if (propertySet.exists("jira.onboarding.app_user.id.threshold")) {
            log.info("{} application property already stored with value {} - nothing to do here", (Object)"jira.onboarding.app_user.id.threshold", (Object)propertySet.getString("jira.onboarding.app_user.id.threshold"));
            return;
        }
        ApplicationUserEntity maxAppUser = (ApplicationUserEntity)Select.from(Entity.APPLICATION_USER).orderBy("id desc").limit(1).runWith(this.entityEngine).singleValue();
        if (maxAppUser != null) {
            propertySet.setString("jira.onboarding.app_user.id.threshold", maxAppUser.getId().toString());
            log.info("Adding new application property {} with value {}", (Object)"jira.onboarding.app_user.id.threshold", (Object)maxAppUser.getId());
        } else {
            propertySet.setString("jira.onboarding.app_user.id.threshold", "0");
            log.info("No users found during the execution of this upgrade task. Setting 0 as the value for {}", (Object)"jira.onboarding.app_user.id.threshold");
        }
    }

    @Override
    public boolean isDowngradeTaskRequired() {
        return false;
    }
}

