/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.config.feature.DefaultFeatureManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.upgrade.LegacyImmediateUpgradeTask;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;

public class UpgradeTask_Build64014
extends LegacyImmediateUpgradeTask {
    private static final String FEATURE_TYPE_SITE = "site";
    private static final String SWITCH_FEATURE_KEY = "com.atlassian.jira.projects.ProjectCentricNavigation.Switch";
    private static final String ISSUENAV_FEATURE_KEY = "com.atlassian.jira.projects.issuenavigator";
    private final OfBizDelegator ofBizDelegator;
    private final DefaultFeatureManager defaultFeatureManager;

    public UpgradeTask_Build64014(OfBizDelegator ofBizDelegator, DefaultFeatureManager defaultFeatureManager) {
        this.ofBizDelegator = ofBizDelegator;
        this.defaultFeatureManager = defaultFeatureManager;
    }

    @Override
    public int getBuildNumber() {
        return 64014;
    }

    @Override
    public String getShortDescription() {
        return "Enabling Project Centric Navigation Switch and new Project Issue Navigator by default";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        try {
            List existingSwitchFeature = this.ofBizDelegator.findByField("Feature", "featureName", (Object)SWITCH_FEATURE_KEY);
            if (existingSwitchFeature.isEmpty()) {
                this.ofBizDelegator.createValue("Feature", (Map)ImmutableMap.of((Object)"featureName", (Object)SWITCH_FEATURE_KEY, (Object)"featureType", (Object)FEATURE_TYPE_SITE, (Object)"userKey", (Object)""));
            }
        }
        finally {
            this.defaultFeatureManager.onClearCache(null);
        }
    }

    private static final class Field {
        private static final String FEATURE_NAME = "featureName";
        private static final String FEATURE_TYPE = "featureType";
        private static final String USERKEY = "userKey";

        private Field() {
        }
    }
}

