/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.upgrade.tasks.DropIndexTask;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build64005
extends DropIndexTask {
    private static final Logger LOG = LoggerFactory.getLogger(UpgradeTask_Build64005.class);

    @Override
    public int getBuildNumber() {
        return 64005;
    }

    @Override
    public boolean isDowngradeTaskRequired() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropIndex(Connection connection, String tableName, String indexName) {
        try {
            String sql = this.buildDropIndexSql(tableName, indexName);
            try (Statement update = connection.createStatement();){
                update.execute(sql);
            }
        }
        catch (SQLException sqle) {
            LOG.debug("Ignoring error dropping old index", (Throwable)sqle);
        }
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        if (setupMode) {
            return;
        }
        try (Connection connection = this.getDatabaseConnection();){
            this.dropIndex(connection, "jiraaction", "action_authorcreated");
            this.dropIndex(connection, "jiraaction", "action_authorupdated");
        }
    }

    @Override
    public String getShortDescription() {
        return "Remove old indexes from jiraaction table";
    }
}

