/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.upgrade.LegacyImmediateUpgradeTask;
import com.atlassian.jira.util.collect.MapBuilder;
import com.google.common.collect.Lists;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build638
extends LegacyImmediateUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask_Build638.class);
    public static final String ISSUE_ENTITY = "Issue";
    public static final String VOTE_HISTORY_ENTITY = "VoteHistory";
    OfBizDelegator ofBizDelegator;

    public UpgradeTask_Build638(OfBizDelegator ofBizDelegator) {
        this.ofBizDelegator = ofBizDelegator;
    }

    @Override
    public int getBuildNumber() {
        return 638;
    }

    @Override
    public String getShortDescription() {
        return "Initialising the vote history.";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        Timestamp now = new Timestamp(new Date().getTime());
        List issues = this.ofBizDelegator.findByCondition(ISSUE_ENTITY, (EntityCondition)new EntityExpr("votes", EntityOperator.GREATER_THAN, (Object)0L), (Collection)Lists.newArrayList((Object[])new String[]{"id", "votes"}));
        for (GenericValue issue : issues) {
            this.ofBizDelegator.createValue(VOTE_HISTORY_ENTITY, MapBuilder.build((Object)"issue", (Object)issue.getLong("id"), (Object)"votes", (Object)issue.getLong("votes"), (Object)"timestamp", (Object)now));
        }
    }

    @Override
    @Nullable
    public Integer dependsUpon() {
        return 637;
    }
}

