/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.bc.admin.ApplicationPropertiesService;
import com.atlassian.jira.bc.admin.ApplicationProperty;
import com.atlassian.jira.config.properties.ApplicationPropertiesStore;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.upgrade.LegacyImmediateUpgradeTask;
import com.atlassian.jira.util.IOUtil;
import com.atlassian.plugin.util.ClassLoaderUtils;
import com.atlassian.validation.Validated;
import com.atlassian.validation.Validator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build637
extends LegacyImmediateUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask_Build637.class);
    private static final String LEGACY_PROPERTIES_FILE = "jira-application.properties";
    private List<String> MIGRATABLE_KEYS = Arrays.asList("jira.view.issue.links.sort.order", "jira.table.cols.subtasks", "jira.projectkey.pattern", "jira.issue.actions.order", "jira.date.picker.java.format", "jira.clone.prefix", "jira.attachment.number.of.zip.entries");
    private final ApplicationPropertiesService applicationPropertiesService;
    private final ApplicationPropertiesStore propertiesStore;
    private final JiraHome jiraHome;

    public UpgradeTask_Build637(ApplicationPropertiesService applicationPropertiesService, ApplicationPropertiesStore propertiesStore, JiraHome jiraHome) {
        this.applicationPropertiesService = applicationPropertiesService;
        this.propertiesStore = propertiesStore;
        this.jiraHome = jiraHome;
    }

    @Override
    public final int getBuildNumber() {
        return 637;
    }

    @Override
    public String getShortDescription() {
        return "Migrates custom defaults to the database for selected ApplicationProperties";
    }

    @Override
    public final void doUpgrade(boolean setupMode) throws Exception {
        File homeDirConfigFile = new File(this.jiraHome.getLocalHomePath(), "jira-config.properties");
        if (homeDirConfigFile.exists()) {
            log.warn(homeDirConfigFile.getPath() + " already exists. Migration of '" + LEGACY_PROPERTIES_FILE + "' will be skipped.");
            return;
        }
        Properties properties = this.loadPropertiesFromLegacyFile(this.getLegacyPropertiesStream());
        Properties overlayProps = new Properties();
        for (Object o : properties.keySet()) {
            String value;
            String key = (String)o;
            if (!this.isModified(key, value = properties.getProperty(key))) continue;
            if (this.MIGRATABLE_KEYS.contains(key)) {
                this.storeInDatabase(key, value);
                continue;
            }
            if ("jira.home".equals(key)) continue;
            overlayProps.setProperty(key, value);
        }
        if (!overlayProps.isEmpty()) {
            this.writeOverlayFile(overlayProps);
        }
        this.propertiesStore.refresh();
    }

    private boolean isModified(String key, String value) {
        try {
            ApplicationProperty prop = this.applicationPropertiesService.getApplicationProperty(key);
            if (prop != null) {
                return !prop.getMetadata().getDefaultValue().equals(value);
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    void writeOverlayFile(Properties overlayProps) throws IOException {
        File homeDirConfigFile = new File(this.jiraHome.getLocalHomePath(), "jira-config.properties");
        String homeDirPath = homeDirConfigFile.getCanonicalPath();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(homeDirConfigFile);
            overlayProps.store(fileOutputStream, "Generated by JIRA upgrade task " + this.getBuildNumber() + " migrating custom properties out of legacy " + LEGACY_PROPERTIES_FILE);
            log.warn("Custom properties have been moved from the legacy file jira-application.properties to the new shiny " + homeDirPath);
            try {
                fileOutputStream.close();
            }
            catch (Exception e) {
                log.warn("Failed to peacfully complete migration from 'jira-application.properties'. Please confirm your custom properties from this have arrived safely in the " + homeDirPath + " file.", (Throwable)e);
            }
        }
        catch (IOException e) {
            log.error("Unable to write custom properties into " + homeDirPath, (Throwable)e);
        }
    }

    InputStream getLegacyPropertiesStream() {
        return ClassLoaderUtils.getResourceAsStream((String)LEGACY_PROPERTIES_FILE, this.getClass());
    }

    private void storeInDatabase(String key, String value) {
        try {
            Validated<ApplicationProperty> validated = this.applicationPropertiesService.setApplicationProperty(key, value);
            Validator.Result validatorResult = validated.getResult();
            if (!validatorResult.isValid()) {
                log.error("Cannot set application property '" + key + "' to value '" + value + "' due to validation failure: " + validatorResult.getErrorMessage());
                this.handleFailure(key, value, null);
            }
        }
        catch (Exception e) {
            this.handleFailure(key, value, e);
        }
    }

    private Properties loadPropertiesFromLegacyFile(InputStream propertiesStream) {
        Properties props = new Properties();
        if (propertiesStream != null) {
            try {
                props.load(propertiesStream);
                IOUtil.shutdownStream(propertiesStream);
            }
            catch (IOException e) {
                log.warn("Failed to migrate custom default properties from 'jira-application.properties' file. Please check the new admin configuration options added in JIRA 4.4 to ensure your configuration is correct.");
            }
        } else {
            log.debug("No jira-application.properties file found to migrate, doing nothing.");
        }
        return props;
    }

    void handleFailure(String key, String property, Exception e) {
        String mesg = "Failed to store the custom default application property '" + key + "' as value '" + property + "'. Please use the administration interface to configure the setting";
        if (e != null) {
            log.warn(mesg, (Throwable)e);
        } else {
            log.warn(mesg);
        }
    }

    @Override
    @Nullable
    public Integer dependsUpon() {
        return 634;
    }
}

