/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.entity.Delete;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.EntityListConsumer;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.upgrade.AbstractDelayableUpgradeTask;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeTask_Build6306
extends AbstractDelayableUpgradeTask {
    private static final String DRAFT_WORKFLOW_SCHEME_ENTITY = "DraftWorkflowSchemeEntity";
    private final EntityEngine entityEngine;
    private EntityListConsumer<GenericValue, Set<Long>> idCollector = new EntityListConsumer<GenericValue, Set<Long>>(){
        private Set<Long> result = new HashSet<Long>();

        @Override
        public void consume(GenericValue entity) {
            this.result.add(entity.getLong("id"));
        }

        @Override
        public Set<Long> result() {
            return this.result;
        }
    };

    public UpgradeTask_Build6306(EntityEngine entityEngine) {
        this.entityEngine = entityEngine;
    }

    @Override
    public int getBuildNumber() {
        return 6306;
    }

    @Override
    public String getShortDescription() {
        return "Removes orphaned mappings generated by upgrade task 6123";
    }

    @Override
    public boolean isDowngradeTaskRequired() {
        return true;
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        Set<Long> draftSchemeIds = Select.columns("id").from("DraftWorkflowScheme").runWith(this.entityEngine).consumeWith(this.idCollector);
        for (GenericValue entity : Select.columns("id", "scheme").from(DRAFT_WORKFLOW_SCHEME_ENTITY).runWith(this.entityEngine).asList()) {
            long entityId = entity.getLong("id");
            long schemeId = entity.getLong("scheme");
            if (draftSchemeIds.contains(schemeId)) continue;
            this.entityEngine.delete(Delete.from(DRAFT_WORKFLOW_SCHEME_ENTITY).whereIdEquals(entityId));
        }
    }

    @Override
    @Nullable
    public Integer dependsUpon() {
        return 6123;
    }
}

