/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.config.properties.PropertiesManager;
import com.atlassian.jira.database.DatabaseUtil;
import com.atlassian.jira.upgrade.AbstractDelayableUpgradeTask;
import com.google.common.base.Optional;
import com.google.common.base.Stopwatch;
import com.opensymphony.module.propertyset.PropertyException;
import com.opensymphony.module.propertyset.PropertySet;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build6305
extends AbstractDelayableUpgradeTask {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeTask_Build6305.class);
    private static final String GRAVATARS_PROPERTY = "jira.user.avatar.gravatar.enabled";
    private static final boolean GRAVATARS_PRE63_DEFAULT = false;
    private final PropertiesManager propertiesManager;

    public UpgradeTask_Build6305(PropertiesManager propertiesManager) {
        this.propertiesManager = propertiesManager;
    }

    @Override
    public int getBuildNumber() {
        return 6305;
    }

    @Override
    public String getShortDescription() {
        return "Migrate avatar settings";
    }

    @Override
    public boolean isDowngradeTaskRequired() {
        return true;
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        boolean allowGravatars = this.isAllowGravatars();
        if (allowGravatars) {
            this.resetAllUsersToDefaultAvatar();
        }
        this.setAllowGravatars(allowGravatars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetAllUsersToDefaultAvatar() throws SQLException {
        Stopwatch watch = Stopwatch.createStarted();
        Optional<Long> defaultAvatarId = this.getDefaultUserAvatarId();
        if (!defaultAvatarId.isPresent()) {
            logger.info("Unable to determine default avatar id. Skipping upgrade task...");
            return;
        }
        logger.info("Resetting all users to default avatar {}...", defaultAvatarId);
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.getDatabaseConnection();
            stmt = conn.prepareStatement("UPDATE " + this.convertToSchemaTableName("propertynumber") + "   SET propertyvalue=? WHERE id IN (SELECT id  FROM " + this.convertToSchemaTableName("propertyentry") + " WHERE entity_name='ApplicationUser'   AND property_key='user.avatar.id')");
            stmt.setLong(1, (Long)defaultAvatarId.get());
            int updated = stmt.executeUpdate();
            logger.info("Reset {} user avatars in {}ms", (Object)updated, (Object)watch.elapsed(TimeUnit.MILLISECONDS));
        }
        catch (Throwable throwable) {
            DatabaseUtil.closeQuietly(stmt);
            DatabaseUtil.closeQuietly(conn);
            throw throwable;
        }
        DatabaseUtil.closeQuietly(stmt);
        DatabaseUtil.closeQuietly(conn);
    }

    private boolean isAllowGravatars() throws SQLException {
        if (this.applicationProperties().exists(GRAVATARS_PROPERTY)) {
            return this.applicationProperties().getBoolean(GRAVATARS_PROPERTY);
        }
        return false;
    }

    private void setAllowGravatars(boolean allowGravatars) throws SQLException {
        logger.info("Setting application property {} to {}", (Object)GRAVATARS_PROPERTY, (Object)allowGravatars);
        this.applicationProperties().setBoolean(GRAVATARS_PROPERTY, allowGravatars);
    }

    private Optional<Long> getDefaultUserAvatarId() throws SQLException {
        try {
            return Optional.of((Object)Long.valueOf(this.applicationProperties().getString("jira.avatar.user.default.id")));
        }
        catch (NumberFormatException e) {
            return Optional.absent();
        }
        catch (PropertyException e) {
            return Optional.absent();
        }
    }

    private PropertySet applicationProperties() {
        return this.propertiesManager.getPropertySet();
    }
}

