/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.upgrade.LegacyImmediateUpgradeTask;
import java.sql.Connection;
import java.sql.Statement;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.model.ModelEntity;

public class UpgradeTask_Build6258
extends LegacyImmediateUpgradeTask {
    private static String ENTITY_NAME = "AuditLog";

    @Override
    public int getBuildNumber() {
        return 6258;
    }

    @Override
    public String getShortDescription() {
        return "Change AuditLog search field to CLOB on Oracle";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        if (!this.isORACLE()) {
            return;
        }
        ModelEntity auditLogTable = UpgradeTask_Build6258.getOfBizDelegator().getModelReader().getModelEntity(ENTITY_NAME);
        String searchFieldColumn = auditLogTable.getField("searchField").getColName();
        String tableName = this.convertToSchemaTableName(auditLogTable.getPlainTableName());
        try (Connection connection = this.getDatabaseConnection();){
            Statement statement = connection.createStatement();
            statement.execute(String.format("ALTER TABLE %s ADD (tmp_sf CLOB)", tableName));
            statement.execute(String.format("UPDATE %s SET tmp_sf = %s", tableName, searchFieldColumn));
            statement.execute(String.format("ALTER TABLE %s DROP COLUMN %s", tableName, searchFieldColumn));
            statement.execute(String.format("ALTER TABLE %s RENAME COLUMN tmp_sf TO %s", tableName, searchFieldColumn));
        }
    }

    @Override
    @Nullable
    public Integer dependsUpon() {
        return 6254;
    }
}

