/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.upgrade.LegacyImmediateUpgradeTask;
import com.google.common.collect.ImmutableMap;
import electric.util.file.FileUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build6209
extends LegacyImmediateUpgradeTask {
    private static final String AVATAR_ENTITY = "Avatar";
    private static final String FILE_NAME = "fileName";
    private static final String ID = "id";
    private static final String AVATAR_DIRECTORY = "data/avatars";
    private static final String OWNER = "owner";
    private static final String TAGGED_AVATAR_FILE_SUFFIX = "jrvtg.png";
    public static final String SYSTEM_AVATAR = "systemAvatar";
    public static final String PROJECT_AVATAR_TYPE = "project";
    private final OfBizDelegator ofBizDelegator;
    private final JiraHome jiraHome;
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask_Build6209.class);

    public UpgradeTask_Build6209(OfBizDelegator ofBizDelegator, JiraHome jirahome) {
        this.ofBizDelegator = ofBizDelegator;
        this.jiraHome = jirahome;
    }

    @Override
    public int getBuildNumber() {
        return 6209;
    }

    @Override
    public String getShortDescription() {
        return "JRA-25705 Ensure no avatar file names interfere with our existing tagged avatar naming convention";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        ImmutableMap condition = ImmutableMap.of((Object)FILE_NAME, (Object)"%jrvtg.png");
        for (GenericValue gv : this.ofBizDelegator.findByLike(AVATAR_ENTITY, (Map)condition)) {
            try {
                this.renameAllVersions(gv);
            }
            catch (IOException | GenericEntityException e) {
                log.warn("An error occurred while upgrading avatar for " + gv.getString(OWNER) + ". Please re-upload your avatar.");
            }
        }
    }

    private void renameAllVersions(GenericValue gv) throws IOException, GenericEntityException {
        int isSystem = gv.getInteger(SYSTEM_AVATAR);
        if (isSystem == 1) {
            return;
        }
        String avatarType = gv.getString("avatarType");
        if (PROJECT_AVATAR_TYPE.equals(avatarType)) {
            return;
        }
        long id = gv.getLong(ID);
        String baseFileName = gv.getString(FILE_NAME);
        String baseFileNameRegex = Pattern.quote(baseFileName) + "$";
        RegexFileFilter forThisAvatar = new RegexFileFilter(id + "_.*" + baseFileNameRegex, IOCase.INSENSITIVE);
        String newBaseFileName = FilenameUtils.removeExtension((String)baseFileName) + "0.png";
        File avatarBaseDirectory = this.getAvatarBaseDirectory();
        for (File file : FileUtil.listFiles((File)avatarBaseDirectory, (boolean)true, (FilenameFilter)forThisAvatar)) {
            String newFileName = file.getName().replaceFirst(baseFileNameRegex, newBaseFileName);
            File newFile = new File(avatarBaseDirectory, newFileName);
            if (newFile.exists()) continue;
            FileUtils.moveFile((File)file, (File)newFile);
        }
        gv.setString(FILE_NAME, newBaseFileName);
        gv.store();
    }

    public File getAvatarBaseDirectory() {
        return new File(this.jiraHome.getHome(), AVATAR_DIRECTORY);
    }

    @Override
    @Nullable
    public Integer dependsUpon() {
        return 6208;
    }
}

