/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.transaction.Transaction;
import com.atlassian.jira.transaction.TransactionSupport;
import com.atlassian.jira.upgrade.LegacyImmediateUpgradeTask;
import com.atlassian.jira.util.Visitor;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build6153
extends LegacyImmediateUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask_Build6153.class);
    private final ApplicationProperties applicationProperties;
    private final TransactionSupport transactionSupport;
    private final EntityEngine entityEngine;

    public UpgradeTask_Build6153(ApplicationProperties applicationProperties, TransactionSupport transactionSupport, EntityEngine entityEngine) {
        this.applicationProperties = applicationProperties;
        this.transactionSupport = transactionSupport;
        this.entityEngine = entityEngine;
    }

    @Override
    public int getBuildNumber() {
        return 6153;
    }

    @Override
    public String getShortDescription() {
        return "Corrects wording of Cloners link if legacy direction was used and disables support for legacy direction of links";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        boolean cloneLinkLegacyDirection = this.applicationProperties.getOption("jira.clone.link.legacy.direction");
        if (cloneLinkLegacyDirection) {
            this.swapDirectionNamesAndDisableFlag();
        }
    }

    private void swapDirectionNamesAndDisableFlag() throws GenericEntityException {
        log.info("Cloners link was using legacy directions. Swapping direction names.");
        Transaction transaction = this.transactionSupport.begin();
        try {
            this.swapDirectionNamesForClonersLink();
            this.disableCloneLinkLegacyDirectionFlag();
            transaction.commit();
        }
        finally {
            transaction.finallyRollbackIfNotCommitted();
        }
    }

    private void swapDirectionNamesForClonersLink() {
        this.entityEngine.run(Select.from("IssueLinkType").whereEqual("linkname", "Cloners")).visitWith(new Visitor<GenericValue>(){

            public void visit(GenericValue link) {
                try {
                    String tmp = link.getString("outward");
                    link.set("outward", (Object)link.getString("inward"));
                    link.set("inward", (Object)tmp);
                    link.store();
                }
                catch (GenericEntityException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private void disableCloneLinkLegacyDirectionFlag() throws GenericEntityException {
        GenericValue flag = this.entityEngine.run(Select.from("OSPropertyEntry").whereEqual("propertyKey", "jira.clone.link.legacy.direction")).singleValue();
        GenericValue value = this.entityEngine.run(Select.from("OSPropertyNumber").whereEqual("id", flag.getLong("id"))).singleValue();
        value.set("value", (Object)0);
        value.store();
    }

    @Override
    @Nullable
    public Integer dependsUpon() {
        return 6152;
    }
}

