/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.index.request.AffectedIndex;
import com.atlassian.jira.index.request.ReindexRequestType;
import com.atlassian.jira.index.request.SharedEntityType;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.customfields.impl.CascadingSelectCFType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.upgrade.tasks.AbstractReindexUpgradeTask;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build6142
extends AbstractReindexUpgradeTask {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CustomFieldManager customFieldManager;

    public UpgradeTask_Build6142(CustomFieldManager customFieldManager) {
        this.customFieldManager = customFieldManager;
    }

    @Override
    public int getBuildNumber() {
        return 6142;
    }

    @Override
    public String getShortDescription() {
        return "Run a reindex if the instance has Cascading Select fields since their values will now be added to the Lucene index.";
    }

    @Override
    public boolean isDowngradeTaskRequired() {
        return true;
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        List customFields = this.customFieldManager.getCustomFieldObjects();
        for (CustomField customField : customFields) {
            if (!(customField.getCustomFieldType() instanceof CascadingSelectCFType)) continue;
            this.log.info("A Reindex will be performed because at least 1 Cascade Select Custom Field is present");
            this.getReindexRequestService().requestReindex(ReindexRequestType.DELAYED, EnumSet.of(AffectedIndex.ISSUE), EnumSet.noneOf(SharedEntityType.class));
        }
        this.log.info("No reindex will be performed.");
    }

    @Override
    @Nullable
    public Integer dependsUpon() {
        return 6141;
    }
}

