/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.issue.security.IssueSecurityLevelPermission;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.upgrade.LegacyImmediateUpgradeTask;
import com.atlassian.jira.user.ApplicationUserEntity;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build6140
extends LegacyImmediateUpgradeTask {
    private static final String ENTITY_UPGRADE_HISTORY = "UpgradeHistory";
    private static final String FIELD_UPGRADECLASS = "upgradeclass";
    private static final String UPGRADE_6108 = "com.atlassian.jira.upgrade.tasks.UpgradeTask_Build6108";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final EntityEngine entityEngine;
    private final OfBizDelegator ofBizDelegator;
    private final LoadingCache<String, String> userKeyMapping = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, String>(){

        public String load(@Nonnull String username) {
            String lowerName = IdentifierUtils.toLowerCase((String)username);
            ApplicationUserEntity appUser = (ApplicationUserEntity)UpgradeTask_Build6140.this.entityEngine.selectFrom(Entity.APPLICATION_USER).whereEqual("userKey", lowerName).singleValue();
            return appUser == null ? username : appUser.getKey();
        }
    });

    public UpgradeTask_Build6140(EntityEngine entityEngine, OfBizDelegator ofBizDelegator) {
        this.entityEngine = entityEngine;
        this.ofBizDelegator = ofBizDelegator;
    }

    @Override
    public int getBuildNumber() {
        return 6140;
    }

    @Override
    public String getShortDescription() {
        return "Convert Issue Security username references to user keys";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        List upgradeHistoryList = this.ofBizDelegator.findByCondition(ENTITY_UPGRADE_HISTORY, (EntityCondition)new EntityExpr(FIELD_UPGRADECLASS, EntityOperator.EQUALS, (Object)UPGRADE_6108), null);
        if (upgradeHistoryList.size() > 0) {
            this.log.info("Update username references in scheme issue securities already done in upgrade 6108.");
            return;
        }
        this.log.info("Updating username references in scheme issue securities ...");
        List userPermissions = this.entityEngine.selectFrom(Entity.ISSUE_SECURITY_LEVEL_PERMISSION).whereEqual("type", "user").list();
        for (IssueSecurityLevelPermission userPermission : userPermissions) {
            String username = userPermission.getParameter();
            String key = (String)this.userKeyMapping.get((Object)username);
            if (key.equals(username)) continue;
            IssueSecurityLevelPermission newUserPermission = new IssueSecurityLevelPermission(userPermission.getId(), userPermission.getSchemeId(), userPermission.getSecurityLevelId(), userPermission.getType(), key);
            this.entityEngine.updateValue(Entity.ISSUE_SECURITY_LEVEL_PERMISSION, newUserPermission);
        }
    }

    @Override
    @Nullable
    public Integer dependsUpon() {
        return 6139;
    }
}

