/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.upgrade.LegacyImmediateUpgradeTask;
import com.atlassian.jira.user.ApplicationUserEntity;
import com.atlassian.jira.user.util.UserKeyStore;
import com.atlassian.jira.user.util.UserKeyStoreImpl;
import com.atlassian.jira.util.Visitor;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build6137
extends LegacyImmediateUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask_Build6137.class);
    final Set<String> unmappedKeys = new HashSet<String>();
    final Set<String> mappedKeys = new HashSet<String>();
    final Set<String> mappedNames = new HashSet<String>();
    final UnmappedKeyCollector unmappedKeyCollector = new UnmappedKeyCollector();
    private final EntityEngine entityEngine;
    private final UserKeyStore userKeyStore;
    private final boolean debug;

    public UpgradeTask_Build6137(EntityEngine entityEngine, UserKeyStore userKeyStore) {
        this.entityEngine = entityEngine;
        this.userKeyStore = userKeyStore;
        this.debug = log.isDebugEnabled();
    }

    @Override
    public int getBuildNumber() {
        return 6137;
    }

    @Override
    public String getShortDescription() {
        return "Ensure that every assignee and reporter has a userkey mapping";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        this.findUnmappedUserKeys();
        this.mappedKeys.clear();
        log.info("Found " + this.unmappedKeys.size() + " unmapped user" + (this.unmappedKeys.size() == 1 ? "" : "s"));
        if (this.unmappedKeys.isEmpty()) {
            return;
        }
        for (String userKey : this.unmappedKeys) {
            String lowerUserName = this.findAvailableUserName(userKey);
            if (this.debug) {
                log.debug("Creating mapping for deleted user: userKey=[" + userKey + "] -> lowerUserName=[" + lowerUserName + ']');
            }
            try {
                this.entityEngine.createValue(Entity.APPLICATION_USER, new ApplicationUserEntity(null, userKey, lowerUserName));
            }
            catch (DataAccessException dae) {
                log.error("Unable to creating mapping for deleted user: userKey=[" + userKey + "] -> lowerUserName=[" + lowerUserName + "]: " + (Object)((Object)dae));
            }
        }
        ((UserKeyStoreImpl)this.userKeyStore).onClearCache(null);
    }

    private void findUnmappedUserKeys() {
        this.loadExistingApplicationUsers();
        this.findUnmappedKeysInField("Issue", "assignee");
        this.findUnmappedKeysInField("Issue", "reporter");
    }

    private String findAvailableUserName(String userKey) {
        if (this.mappedNames.add(userKey)) {
            return userKey;
        }
        int count = 1;
        String lowerUserKey = IdentifierUtils.toLowerCase((String)userKey);
        String lowerUserName = lowerUserKey + "#1";
        while (!this.mappedNames.add(lowerUserName)) {
            if (count == Integer.MAX_VALUE) {
                throw new IllegalStateException("Deleted user eviction namespace exhausted");
            }
            lowerUserName = lowerUserKey + '#' + ++count;
        }
        return lowerUserName;
    }

    private void loadExistingApplicationUsers() {
        Select.columns("userKey", "lowerUserName").from(Entity.APPLICATION_USER.getEntityName()).runWith(this.entityEngine).visitWith(genericValue -> {
            this.mappedKeys.add(genericValue.getString("userKey"));
            this.mappedNames.add(genericValue.getString("lowerUserName"));
        });
    }

    private void findUnmappedKeysInField(String entityName, String fieldName) {
        Select.distinctString(fieldName).from(entityName).runWith(this.entityEngine).visitWith(this.unmappedKeyCollector);
    }

    @Override
    @Nullable
    public Integer dependsUpon() {
        return 6136;
    }

    class UnmappedKeyCollector
    implements Visitor<String> {
        UnmappedKeyCollector() {
        }

        public void visit(@Nullable String userKey) {
            if (userKey != null && userKey.length() > 0 && !UpgradeTask_Build6137.this.mappedKeys.contains(userKey)) {
                UpgradeTask_Build6137.this.unmappedKeys.add(userKey);
            }
        }
    }
}

