/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.upgrade.LegacyImmediateUpgradeTask;
import java.sql.Connection;
import java.sql.PreparedStatement;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.model.ModelEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build6135
extends LegacyImmediateUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask_Build6135.class);
    private final ProjectManager projectManager;
    private final String PROJECT_ENTITY_NAME = "Project";
    private final String PROJECT_TABLE_NAME = "project";

    public UpgradeTask_Build6135(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    @Override
    public int getBuildNumber() {
        return 6135;
    }

    @Override
    public String getShortDescription() {
        return "Filling in originalKey in project table.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        try (Connection connection = this.getDatabaseConnection();){
            ModelEntity issueTable = UpgradeTask_Build6135.getOfBizDelegator().getModelReader().getModelEntity("Project");
            String originalKeyColumn = issueTable.getField("originalkey").getColName();
            String keyColumn = issueTable.getField("key").getColName();
            String updateSql = "UPDATE " + this.convertToSchemaTableName("project") + " SET " + originalKeyColumn + "=" + keyColumn + " WHERE " + originalKeyColumn + " IS NULL";
            try (PreparedStatement updateStmt = connection.prepareStatement(updateSql);){
                int updatedCount = updateStmt.executeUpdate();
                log.info(String.format("Updated %d projects.", updatedCount));
            }
        }
        this.projectManager.refresh();
    }

    @Override
    @Nullable
    public Integer dependsUpon() {
        return 6134;
    }
}

