/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.entity.Delete;
import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.MovedIssueKey;
import com.atlassian.jira.upgrade.LegacyImmediateUpgradeTask;
import com.atlassian.jira.util.Visitor;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build6121
extends LegacyImmediateUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask_Build6121.class);

    @Override
    public int getBuildNumber() {
        return 6121;
    }

    @Override
    public String getShortDescription() {
        return "Populate the MovedIssueKey DB table from Change History Items.";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        EntityEngine entityEngine = UpgradeTask_Build6121.getEntityEngine();
        entityEngine.delete(Delete.from(Entity.MOVED_ISSUE_KEY).all());
        Select.columns("oldstring", "issue").from("ChangeGroupChangeItemView").whereEqual("field", "Key").runWith(entityEngine).visitWith(new ChangeItemVisitor(entityEngine));
    }

    @Override
    @Nullable
    public Integer dependsUpon() {
        return 6096;
    }

    private static final class ChangeItemVisitor
    implements Visitor<GenericValue> {
        private final EntityEngine entityEngine;

        private ChangeItemVisitor(EntityEngine entityEngine) {
            this.entityEngine = entityEngine;
        }

        public void visit(GenericValue entity) {
            MovedIssueKey movedIssueKey = new MovedIssueKey(null, entity.getString("oldstring"), entity.getLong("issue"));
            try {
                this.entityEngine.createValue(Entity.MOVED_ISSUE_KEY, movedIssueKey);
            }
            catch (DataAccessException ex) {
                MovedIssueKey existingValue = (MovedIssueKey)Select.from(Entity.MOVED_ISSUE_KEY).whereEqual("oldIssueKey", movedIssueKey.getOldIssueKey()).runWith(this.entityEngine).singleValue();
                if (existingValue == null) {
                    throw ex;
                }
                log.warn("Found duplicate moved issue key information for issue " + movedIssueKey.getOldIssueKey() + ". Ignoring issue " + movedIssueKey.getIssueId());
            }
        }
    }
}

